/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

import java.io.IOException;
import oracle.nosql.driver.query.PlanIter;
import oracle.nosql.driver.query.PlanIterState;
import oracle.nosql.driver.query.QueryFormatter;
import oracle.nosql.driver.query.QueryStateException;
import oracle.nosql.driver.query.RuntimeControlBlock;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.util.SerializationUtil;
import oracle.nosql.driver.values.EmptyValue;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.MapValue;
import oracle.nosql.driver.values.NullValue;

public class FieldStepIter
extends PlanIter {
    private final PlanIter theInputIter;
    private final String theFieldName;

    FieldStepIter(ByteInputStream in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theInputIter = FieldStepIter.deserializeIter(in, serialVersion);
        this.theFieldName = SerializationUtil.readString(in);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.FIELD_STEP;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
        this.theInputIter.open(rcb);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        FieldValue result;
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        int inputReg = this.theInputIter.getResultReg();
        while (true) {
            FieldValue ctxItem = null;
            boolean more = this.theInputIter.next(rcb);
            ctxItem = rcb.getRegVal(inputReg);
            if (!more || ctxItem == EmptyValue.getInstance()) {
                state.done();
                return false;
            }
            ctxItem = rcb.getRegVal(inputReg);
            if (ctxItem.isAtomic()) continue;
            if (ctxItem == NullValue.getInstance()) {
                rcb.setRegVal(this.theResultReg, ctxItem);
                return true;
            }
            FieldValue.Type ctxItemKind = ctxItem.getType();
            if (ctxItemKind != FieldValue.Type.MAP) {
                throw new QueryStateException("Input value in field step has invalid type.\n" + ctxItem);
            }
            MapValue map = (MapValue)ctxItem;
            result = map.get(this.theFieldName);
            if (result != null) break;
        }
        rcb.setRegVal(this.theResultReg, result);
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInputIter.reset(rcb);
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInputIter.close(rcb);
        state.close();
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInputIter.display(sb, formatter);
        sb.append(",\n");
        formatter.indent(sb);
        sb.append(this.theFieldName);
    }
}

