/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops.serde;

import java.io.IOException;
import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.ops.TableLimits;
import oracle.nosql.driver.ops.TableRequest;
import oracle.nosql.driver.ops.TableResult;
import oracle.nosql.driver.ops.serde.BinaryProtocol;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.util.BinaryProtocol;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.util.ByteOutputStream;

class TableRequestSerializer
extends BinaryProtocol
implements Serializer {
    TableRequestSerializer() {
    }

    @Override
    public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
        TableRequest rq = (TableRequest)request;
        TableRequestSerializer.writeOpCode(out, BinaryProtocol.OpCode.TABLE_REQUEST);
        TableRequestSerializer.serializeRequest(rq, out);
        TableRequestSerializer.writeString(out, rq.getStatement());
        TableLimits limits = rq.getTableLimits();
        if (limits != null) {
            out.writeBoolean(true);
            out.writeInt(limits.getReadUnits());
            out.writeInt(limits.getWriteUnits());
            out.writeInt(limits.getStorageGB());
            if (rq.getTableName() != null) {
                out.writeBoolean(true);
                TableRequestSerializer.writeString(out, rq.getTableName());
            } else {
                out.writeBoolean(false);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public TableResult deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
        return TableRequestSerializer.deserializeTableResult(in);
    }
}

