/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops.serde;

import java.io.IOException;
import oracle.nosql.driver.ops.GetIndexesRequest;
import oracle.nosql.driver.ops.GetIndexesResult;
import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.ops.Result;
import oracle.nosql.driver.ops.serde.BinaryProtocol;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.util.BinaryProtocol;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.util.ByteOutputStream;

class GetIndexesRequestSerializer
extends BinaryProtocol
implements Serializer {
    GetIndexesRequestSerializer() {
    }

    @Override
    public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
        GetIndexesRequest getRq = (GetIndexesRequest)request;
        GetIndexesRequestSerializer.writeOpCode(out, BinaryProtocol.OpCode.GET_INDEXES);
        GetIndexesRequestSerializer.serializeRequest(getRq, out);
        GetIndexesRequestSerializer.writeString(out, getRq.getTableName());
        if (getRq.getIndexName() != null) {
            out.writeBoolean(true);
            GetIndexesRequestSerializer.writeString(out, getRq.getIndexName());
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
        GetIndexesResult result = new GetIndexesResult();
        int numIndexes = GetIndexesRequestSerializer.readInt(in);
        GetIndexesResult.IndexInfo[] indexes = new GetIndexesResult.IndexInfo[numIndexes];
        for (int i = 0; i < numIndexes; ++i) {
            indexes[i] = this.deserializeIndexInfo(in);
        }
        result.setIndexes(indexes);
        return result;
    }

    private GetIndexesResult.IndexInfo deserializeIndexInfo(ByteInputStream in) throws IOException {
        String indexName = GetIndexesRequestSerializer.readString(in);
        int nFields = GetIndexesRequestSerializer.readInt(in);
        String[] fieldNames = new String[nFields];
        for (int n = 0; n < nFields; ++n) {
            fieldNames[n] = GetIndexesRequestSerializer.readString(in);
        }
        return new GetIndexesResult.IndexInfo(indexName, fieldNames);
    }
}

