/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops.serde;

import java.io.IOException;
import oracle.nosql.driver.Version;
import oracle.nosql.driver.ops.DeleteRequest;
import oracle.nosql.driver.ops.DeleteResult;
import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.ops.serde.BinaryProtocol;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.util.BinaryProtocol;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.util.ByteOutputStream;

class DeleteRequestSerializer
extends BinaryProtocol
implements Serializer {
    private final boolean isSubRequest;

    DeleteRequestSerializer() {
        this(false);
    }

    DeleteRequestSerializer(boolean isSubRequest) {
        this.isSubRequest = isSubRequest;
    }

    @Override
    public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
        DeleteRequest deleteRq = (DeleteRequest)request;
        Version matchVersion = deleteRq.getMatchVersion();
        DeleteRequestSerializer.writeOpCode(out, matchVersion != null ? BinaryProtocol.OpCode.DELETE_IF_VERSION : BinaryProtocol.OpCode.DELETE);
        if (this.isSubRequest) {
            out.writeBoolean(deleteRq.getReturnRow());
        } else {
            DeleteRequestSerializer.serializeWriteRequest(deleteRq, out);
        }
        DeleteRequestSerializer.writeFieldValue(out, deleteRq.getKey());
        if (matchVersion != null) {
            DeleteRequestSerializer.writeVersion(out, matchVersion);
        }
    }

    @Override
    public DeleteResult deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
        DeleteResult result = new DeleteResult();
        DeleteRequestSerializer.deserializeConsumedCapacity(in, result);
        boolean success = in.readBoolean();
        result.setSuccess(success);
        DeleteRequestSerializer.deserializeWriteResponse(in, result);
        return result;
    }
}

