/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import oracle.nosql.driver.Consistency;
import oracle.nosql.driver.ops.ReadRequest;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.ops.serde.SerializerFactory;
import oracle.nosql.driver.values.JsonOptions;
import oracle.nosql.driver.values.JsonUtils;
import oracle.nosql.driver.values.MapValue;

public class GetRequest
extends ReadRequest {
    private MapValue key;

    public MapValue getKey() {
        return this.key;
    }

    public GetRequest setKey(MapValue key) {
        this.key = key;
        return this;
    }

    public GetRequest setKeyFromJson(String jsonValue, JsonOptions options) {
        if (jsonValue == null) {
            throw new IllegalArgumentException("GetRequest: setKeyFromJson requires a non-null value");
        }
        this.key = (MapValue)JsonUtils.createValueFromJson(jsonValue, options);
        return this;
    }

    public GetRequest setTableName(String tableName) {
        super.setTableNameInternal(tableName);
        return this;
    }

    public GetRequest setCompartment(String compartment) {
        super.setCompartmentInternal(compartment);
        return this;
    }

    public GetRequest setConsistency(Consistency consistency) {
        super.setConsistencyInternal(consistency);
        return this;
    }

    public GetRequest setTimeout(int timeoutMs) {
        super.setTimeoutInternal(timeoutMs);
        return this;
    }

    @Override
    public void validate() {
        this.validateReadRequest("GetRequest");
        if (this.key == null) {
            throw new IllegalArgumentException("GetRequest requires a key value");
        }
    }

    @Override
    public Serializer createSerializer(SerializerFactory factory) {
        return factory.createGetSerializer();
    }

    @Override
    public Serializer createDeserializer(SerializerFactory factory) {
        return factory.createGetDeserializer();
    }
}

