/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import io.netty.handler.codec.http.HttpHeaders;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.nosql.driver.AuthorizationProvider;
import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.Region;
import oracle.nosql.driver.iam.AuthenticationProfileProvider;
import oracle.nosql.driver.iam.InstancePrincipalsProvider;
import oracle.nosql.driver.iam.OCIConfigFileProvider;
import oracle.nosql.driver.iam.PrivateKeyFileSupplier;
import oracle.nosql.driver.iam.PrivateKeyProvider;
import oracle.nosql.driver.iam.PrivateKeyStringSupplier;
import oracle.nosql.driver.iam.ResourcePrincipalProvider;
import oracle.nosql.driver.iam.SimpleProfileProvider;
import oracle.nosql.driver.iam.UserAuthenticationProfileProvider;
import oracle.nosql.driver.iam.Utils;
import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.util.HttpConstants;
import oracle.nosql.driver.util.LruCache;

public class SignatureProvider
implements AuthorizationProvider,
Region.RegionProvider {
    private static final String SIGNING_HEADERS = "(request-target) host date";
    private static final String SIGNING_HEADERS_WITH_OBO = "(request-target) host date opc-obo-token";
    private static final String OBO_TOKEN_HEADER = "opc-obo-token";
    private static final String CACHE_KEY = "signature";
    protected static final int MAX_ENTRY_LIFE_TIME = 300;
    protected static final int DEFAULT_REFRESH_AHEAD = 10000;
    private final AuthenticationProfileProvider provider;
    private final PrivateKeyProvider privateKeyProvider;
    private String delegationToken;
    private final LruCache<String, SignatureDetails> signatureCache;
    private volatile Timer refresher;
    private long refreshAheadMs = 10000L;
    private long refreshIntervalMs = 0L;
    private String serviceHost;
    private Region region;
    private Logger logger;

    public SignatureProvider() throws IOException {
        this(new OCIConfigFileProvider());
    }

    public SignatureProvider(String profileName) throws IOException {
        this(new OCIConfigFileProvider(profileName));
    }

    public SignatureProvider(String configFile, String profileName) throws IOException {
        this(new OCIConfigFileProvider(configFile, profileName));
    }

    public SignatureProvider(String tenantId, String userId, String fingerprint, String privateKey, char[] passphrase) {
        this(SimpleProfileProvider.builder().tenantId(tenantId).userId(userId).fingerprint(fingerprint).passphrase(passphrase).privateKeySupplier(new PrivateKeyStringSupplier(privateKey)).build());
    }

    public SignatureProvider(String tenantId, String userId, String fingerprint, File privateKeyFile, char[] passphrase) {
        this(SimpleProfileProvider.builder().tenantId(tenantId).userId(userId).fingerprint(fingerprint).passphrase(passphrase).privateKeySupplier(new PrivateKeyFileSupplier(privateKeyFile)).build());
    }

    public SignatureProvider(String tenantId, String userId, String fingerprint, File privateKeyFile, char[] passphrase, Region region) {
        this(SimpleProfileProvider.builder().tenantId(tenantId).userId(userId).fingerprint(fingerprint).passphrase(passphrase).privateKeySupplier(new PrivateKeyFileSupplier(privateKeyFile)).region(region).build());
    }

    public static SignatureProvider createWithInstancePrincipal() {
        return new SignatureProvider(InstancePrincipalsProvider.builder().build());
    }

    public static SignatureProvider createWithInstancePrincipal(Region region) {
        return new SignatureProvider(InstancePrincipalsProvider.builder().setRegion(region).build());
    }

    public static SignatureProvider createWithInstancePrincipal(String iamAuthUri) {
        return new SignatureProvider(InstancePrincipalsProvider.builder().setFederationEndpoint(iamAuthUri).build());
    }

    public static SignatureProvider createWithInstancePrincipal(String iamAuthUri, Region region, Logger logger) {
        SignatureProvider provider = new SignatureProvider(InstancePrincipalsProvider.builder().setFederationEndpoint(iamAuthUri).setLogger(logger).setRegion(region).build());
        provider.setLogger(logger);
        return provider;
    }

    public static SignatureProvider createWithInstancePrincipalForDelegation(String delegationToken) {
        SignatureProvider provider = new SignatureProvider(InstancePrincipalsProvider.builder().build());
        provider.setDelegationToken(delegationToken);
        return provider;
    }

    public static SignatureProvider createWithInstancePrincipalForDelegation(String iamAuthUri, Region region, String delegationToken, Logger logger) {
        SignatureProvider provider = new SignatureProvider(InstancePrincipalsProvider.builder().setFederationEndpoint(iamAuthUri).setLogger(logger).setRegion(region).build());
        provider.setLogger(logger);
        provider.setDelegationToken(delegationToken);
        return provider;
    }

    public static SignatureProvider createWithResourcePrincipal() {
        return SignatureProvider.createWithResourcePrincipal(null);
    }

    public static SignatureProvider createWithResourcePrincipal(Logger logger) {
        SignatureProvider provider = new SignatureProvider(ResourcePrincipalProvider.build(logger));
        provider.setLogger(logger);
        return provider;
    }

    protected SignatureProvider(AuthenticationProfileProvider provider) {
        this(provider, 300, 10000);
    }

    protected SignatureProvider(AuthenticationProfileProvider profileProvider, int durationSeconds, int refreshAhead) {
        if (profileProvider instanceof Region.RegionProvider) {
            this.region = ((Region.RegionProvider)((Object)profileProvider)).getRegion();
        }
        this.provider = profileProvider;
        PrivateKeyProvider privateKeyProvider = this.privateKeyProvider = this.provider == null ? null : new PrivateKeyProvider(this.provider);
        if (durationSeconds > 300) {
            throw new IllegalArgumentException("Access token cannot be cached longer than 300 seconds");
        }
        this.signatureCache = new LruCache(2, durationSeconds * 1000);
        this.refreshAheadMs = refreshAhead;
        long durationMS = durationSeconds * 1000;
        if (durationMS > this.refreshAheadMs) {
            this.refreshIntervalMs = durationMS - this.refreshAheadMs;
        }
    }

    @Override
    public String getAuthorizationString(Request request) {
        if (this.serviceHost == null) {
            throw new IllegalArgumentException("Unable to find service host, use setServiceHost to load from NoSQLHandleConfig");
        }
        SignatureDetails sigDetails = this.getSignatureDetails();
        if (sigDetails != null) {
            return sigDetails.getSignatureHeader();
        }
        return null;
    }

    @Override
    public void setRequiredHeaders(String authString, Request request, HttpHeaders headers) {
        String compartment;
        SignatureDetails sigDetails = this.getSignatureDetails();
        if (sigDetails == null) {
            return;
        }
        headers.add("Authorization", (Object)sigDetails.getSignatureHeader());
        headers.add("date", (Object)sigDetails.getDate());
        if (this.delegationToken != null) {
            headers.add(OBO_TOKEN_HEADER, (Object)this.delegationToken);
        }
        if ((compartment = request.getCompartment()) == null) {
            compartment = this.getTenantOCID();
        }
        if (compartment == null) {
            throw new IllegalArgumentException("Compartment is null. When authenticating using an Instance Principal the compartment for the operation must be specified.");
        }
        headers.add("x-nosql-compartment-id", (Object)compartment);
    }

    private String getTenantOCID() {
        if (this.provider instanceof UserAuthenticationProfileProvider) {
            return ((UserAuthenticationProfileProvider)this.provider).getTenantId();
        }
        return null;
    }

    @Override
    public void close() {
        this.signatureCache.stop(false);
        if (this.refresher != null) {
            this.refresher.cancel();
            this.refresher = null;
        }
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public SignatureProvider setServiceHost(NoSQLHandleConfig config) {
        URL serviceURL = config.getServiceURL();
        if (serviceURL == null) {
            throw new IllegalArgumentException("Must set service URL first");
        }
        this.serviceHost = serviceURL.getHost();
        return this;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getResourcePrincipalClaim(String key) {
        if (!(this.provider instanceof ResourcePrincipalProvider)) {
            throw new IllegalArgumentException("Only resource principal support");
        }
        ResourcePrincipalProvider rpp = (ResourcePrincipalProvider)this.provider;
        return rpp.getClaim(key);
    }

    void setDelegationToken(String token) {
        this.delegationToken = token;
    }

    private void logMessage(Level level, String msg) {
        if (this.logger != null) {
            this.logger.log(level, msg);
        }
    }

    private SignatureDetails getSignatureDetails() {
        SignatureDetails sigDetails = this.signatureCache.get(CACHE_KEY);
        if (sigDetails != null) {
            return sigDetails;
        }
        return this.getSignatureDetailsInternal();
    }

    synchronized SignatureDetails getSignatureDetailsInternal() {
        String signature;
        String date = Utils.createFormatter().format(new Date());
        String keyId = this.provider.getKeyId();
        if (this.provider instanceof InstancePrincipalsProvider) {
            this.privateKeyProvider.reload(this.provider.getPrivateKey(), this.provider.getPassphraseCharacters());
        }
        try {
            signature = Utils.sign(this.signingContent(date), this.privateKeyProvider.getKey());
        }
        catch (Exception e) {
            this.logMessage(Level.SEVERE, "Error signing request " + e.getMessage());
            return null;
        }
        String signingHeader = this.delegationToken == null ? SIGNING_HEADERS : SIGNING_HEADERS_WITH_OBO;
        String sigHeader = String.format(Utils.SIGNATURE_HEADER_FORMAT, signingHeader, keyId, "rsa-sha256", signature, 1);
        SignatureDetails sigDetails = new SignatureDetails(sigHeader, date);
        this.signatureCache.put(CACHE_KEY, sigDetails);
        this.scheduleRefresh();
        return sigDetails;
    }

    String signingContent(String date) {
        StringBuilder sb = new StringBuilder();
        sb.append("(request-target)").append(": ").append("post /").append(HttpConstants.NOSQL_DATA_PATH).append("\n").append("host").append(": ").append(this.serviceHost).append("\n").append("date").append(": ").append(date);
        if (this.delegationToken != null) {
            sb.append("\n").append(OBO_TOKEN_HEADER).append(": ").append(this.delegationToken);
        }
        return sb.toString();
    }

    private void scheduleRefresh() {
        if (this.refreshIntervalMs == 0L) {
            return;
        }
        if (this.refresher != null) {
            this.refresher.cancel();
            this.refresher = null;
        }
        this.refresher = new Timer(true);
        this.refresher.schedule((TimerTask)new RefreshTask(), this.refreshIntervalMs);
    }

    public static class ResourcePrincipalClaimKeys {
        public static final String COMPARTMENT_ID_CLAIM_KEY = "res_compartment";
        public static final String TENANT_ID_CLAIM_KEY = "res_tenant";
    }

    static class SignatureDetails {
        private String signatureHeader;
        private String date;

        SignatureDetails(String signatureHeader, String date) {
            this.signatureHeader = signatureHeader;
            this.date = date;
        }

        String getDate() {
            return this.date;
        }

        String getSignatureHeader() {
            return this.signatureHeader;
        }

        boolean isValid(String header) {
            if (header == null) {
                return false;
            }
            return header.equals(this.signatureHeader);
        }
    }

    private class RefreshTask
    extends TimerTask {
        private RefreshTask() {
        }

        @Override
        public void run() {
            try {
                SignatureProvider.this.getSignatureDetailsInternal();
            }
            catch (Exception e) {
                SignatureProvider.this.logMessage(Level.WARNING, "Unable to refresh cached request signature, " + e.getMessage());
                SignatureProvider.this.refresher.cancel();
                SignatureProvider.this.refresher = null;
            }
        }
    }
}

