/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver;

import io.netty.handler.ssl.SslContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.nosql.driver.AuthorizationProvider;
import oracle.nosql.driver.Consistency;
import oracle.nosql.driver.DefaultRetryHandler;
import oracle.nosql.driver.DriverMain;
import oracle.nosql.driver.Region;
import oracle.nosql.driver.RetryHandler;
import oracle.nosql.driver.util.CheckNull;

public class NoSQLHandleConfig
implements Cloneable {
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int DEFAULT_TABLE_REQ_TIMEOUT = 10000;
    private static final Consistency DEFAULT_CONSISTENCY = Consistency.EVENTUAL;
    private static final Set<String> VALID_SSL_PROTOCOLS = new HashSet<String>();
    private final URL serviceURL;
    private Region region;
    private int timeout;
    private int tableRequestTimeout;
    private Consistency consistency;
    private int connectionPoolSize = 2;
    private int poolMaxPending = 6;
    private int numThreads = 2;
    private int maxContentLength = 0;
    private int maxChunkSize = 0;
    private RetryHandler retryHandler;
    private AuthorizationProvider authProvider;
    private SslContext sslCtx;
    private Logger logger;
    private List<String> ciphers;
    private List<String> protocols;
    private int sslSessionCacheSize = 0;
    private int sslSessionTimeout = 0;
    private String compartment;
    private boolean rateLimitingEnabled;
    private double defaultRateLimiterPercentage;
    private String proxyHost;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;

    public NoSQLHandleConfig(String endpoint) {
        endpoint = NoSQLHandleConfig.checkRegionId(endpoint, null);
        this.serviceURL = NoSQLHandleConfig.createURL(endpoint, "/");
    }

    public NoSQLHandleConfig(String endpoint, AuthorizationProvider provider) {
        endpoint = NoSQLHandleConfig.checkRegionId(endpoint, provider);
        this.serviceURL = NoSQLHandleConfig.createURL(endpoint, "/");
        this.authProvider = provider;
    }

    public NoSQLHandleConfig(Region region, AuthorizationProvider provider) {
        CheckNull.requireNonNull(region, "Region must be non-null");
        NoSQLHandleConfig.checkRegion(region, provider);
        this.serviceURL = NoSQLHandleConfig.createURL(region.endpoint(), "/");
        this.region = region;
        this.authProvider = provider;
    }

    public NoSQLHandleConfig(AuthorizationProvider provider) {
        CheckNull.requireNonNull(provider, "AuthorizationProvider must be non-null");
        if (provider instanceof Region.RegionProvider) {
            this.region = ((Region.RegionProvider)((Object)provider)).getRegion();
        }
        if (this.region == null) {
            throw new IllegalArgumentException("Unable to find region from given AuthorizationProvider");
        }
        this.serviceURL = NoSQLHandleConfig.createURL(this.region.endpoint(), "/");
        this.authProvider = provider;
    }

    public static URL createURL(String endpoint, String path) {
        CheckNull.requireNonNull(endpoint, "Endpoint must be non-null");
        String protocol = "https";
        int port = 443;
        String host = null;
        String[] parts = endpoint.split(":");
        switch (parts.length) {
            case 1: {
                host = parts[0];
                break;
            }
            case 2: {
                if (parts[0].toLowerCase().startsWith("http")) {
                    protocol = parts[0].toLowerCase();
                    host = parts[1];
                    if (!protocol.equals("http")) break;
                    port = 8080;
                    break;
                }
                host = parts[0];
                port = NoSQLHandleConfig.validatePort(parts[1], endpoint);
                if (port == 443) break;
                protocol = "http";
                break;
            }
            case 3: {
                protocol = parts[0].toLowerCase();
                host = parts[1];
                port = NoSQLHandleConfig.validatePort(parts[2], endpoint);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid endpoint: " + endpoint);
            }
        }
        if (host.startsWith("//")) {
            host = host.substring(2);
        }
        try {
            return new URL(protocol, host, port, path);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static int validatePort(String portString, String endpoint) {
        try {
            int port = Integer.parseInt(portString);
            if (port < 0) {
                throw new IllegalArgumentException("invalid port value of " + port + " for endpoint:" + endpoint);
            }
            return port;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid port value for endpoint:" + e);
        }
    }

    public NoSQLHandleConfig(URL serviceURL) {
        CheckNull.requireNonNull(serviceURL, "NoSQLHandleConfig: serviceURL must be non-null");
        try {
            this.serviceURL = new URL(serviceURL.getProtocol(), serviceURL.getHost(), serviceURL.getPort(), "/");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getLibraryVersion() {
        return DriverMain.getLibraryVersion();
    }

    public URL getServiceURL() {
        return this.serviceURL;
    }

    public Region getRegion() {
        return this.region;
    }

    public int getRequestTimeout() {
        return this.timeout;
    }

    public int getDefaultRequestTimeout() {
        return this.timeout == 0 ? 5000 : this.timeout;
    }

    public int getTableRequestTimeout() {
        return this.tableRequestTimeout;
    }

    public int getDefaultTableRequestTimeout() {
        return this.tableRequestTimeout == 0 ? 10000 : this.tableRequestTimeout;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public Consistency getDefaultConsistency() {
        return this.consistency == null ? DEFAULT_CONSISTENCY : this.consistency;
    }

    public RetryHandler getRetryHandler() {
        return this.retryHandler;
    }

    public AuthorizationProvider getAuthorizationProvider() {
        return this.authProvider;
    }

    public NoSQLHandleConfig setRequestTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public NoSQLHandleConfig setTableRequestTimeout(int tableRequestTimeout) {
        this.tableRequestTimeout = tableRequestTimeout;
        return this;
    }

    public NoSQLHandleConfig setConsistency(Consistency consistency) {
        CheckNull.requireNonNull((Object)consistency, "NoSQLHandleConfig.setConsistency: consistency must be non-null");
        this.consistency = consistency;
        return this;
    }

    public NoSQLHandleConfig setNumThreads(int numThreads) {
        if (numThreads <= 0) {
            throw new IllegalArgumentException("NoSQLHandleConfig.setNumThreads: numThreads must be a positive value");
        }
        this.numThreads = numThreads;
        return this;
    }

    public NoSQLHandleConfig setConnectionPoolSize(int poolSize) {
        if (poolSize <= 0) {
            throw new IllegalArgumentException("NoSQLHandleConfig.setConnectionPoolSize: poolSize must be a positive value");
        }
        this.connectionPoolSize = poolSize;
        return this;
    }

    public NoSQLHandleConfig setPoolMaxPending(int poolMaxPending) {
        if (poolMaxPending <= 0) {
            throw new IllegalArgumentException("NoSQLHandleConfig.setPoolMaxPending: poolMaxPending must be a positive value");
        }
        this.poolMaxPending = poolMaxPending;
        return this;
    }

    public NoSQLHandleConfig setMaxContentLength(int maxContentLength) {
        if (maxContentLength < 0) {
            throw new IllegalArgumentException("NoSQLHandleConfig.setMaxContentLength: maxContentLength must not be negative");
        }
        this.maxContentLength = maxContentLength;
        return this;
    }

    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    public NoSQLHandleConfig setMaxChunkSize(int maxChunkSize) {
        if (maxChunkSize < 0) {
            throw new IllegalArgumentException("NoSQLHandleConfig.setMaxChunkSize: maxChunkSize must not be negative");
        }
        this.maxChunkSize = maxChunkSize;
        return this;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public int getPoolMaxPending() {
        return this.poolMaxPending;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public NoSQLHandleConfig setRetryHandler(RetryHandler retryHandler) {
        CheckNull.requireNonNull(retryHandler, "NoSQLHandleConfig.setRetryHandler: retryHandler must be non-null");
        this.retryHandler = retryHandler;
        return this;
    }

    public NoSQLHandleConfig setAuthorizationProvider(AuthorizationProvider provider) {
        CheckNull.requireNonNull(provider, "NoSQLHandleConfig.setAuthorizationProvider: provider must be non-null");
        this.authProvider = provider;
        return this;
    }

    public NoSQLHandleConfig setRateLimitingEnabled(boolean enable) {
        this.rateLimitingEnabled = enable;
        return this;
    }

    public boolean getRateLimitingEnabled() {
        return this.rateLimitingEnabled;
    }

    public void setDefaultRateLimitingPercentage(double percent) {
        if (percent <= 0.0) {
            throw new IllegalArgumentException("rate limiter percentage must be positive");
        }
        this.defaultRateLimiterPercentage = percent;
    }

    public double getDefaultRateLimitingPercentage() {
        if (this.defaultRateLimiterPercentage == 0.0) {
            return 100.0;
        }
        return this.defaultRateLimiterPercentage;
    }

    public NoSQLHandleConfig configureDefaultRetryHandler(int numRetries, int delayMS) {
        this.retryHandler = new DefaultRetryHandler(numRetries, delayMS);
        return this;
    }

    public NoSQLHandleConfig setLogger(Logger logger) {
        CheckNull.requireNonNull(logger, "NoSQLHandleConfig.setLogger: logger must be non-null");
        this.logger = logger;
        return this;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public NoSQLHandleConfig setDefaultCompartment(String compartment) {
        this.compartment = compartment;
        return this;
    }

    public String getDefaultCompartment() {
        return this.compartment;
    }

    public List<String> getSSLCipherSuites() {
        return this.ciphers;
    }

    public String[] getSSLProtocols() {
        if (this.protocols == null) {
            return null;
        }
        return (String[])this.protocols.stream().toArray(String[]::new);
    }

    public int getSSLSessionTimeout() {
        return this.sslSessionTimeout;
    }

    public int getSSLSessionCacheSize() {
        return this.sslSessionCacheSize;
    }

    public NoSQLHandleConfig setSSLCipherSuites(String ... cipherSuites) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>(Arrays.asList(cipherSuites));
        } else {
            this.ciphers.addAll(Arrays.asList(cipherSuites));
        }
        return this;
    }

    public NoSQLHandleConfig setSSLProtocols(String ... sslProtocols) {
        if (this.protocols == null) {
            this.protocols = new ArrayList<String>(Arrays.asList(sslProtocols));
        } else {
            this.protocols.addAll(Arrays.asList(sslProtocols));
        }
        for (String protocol : this.protocols) {
            if (VALID_SSL_PROTOCOLS.contains(protocol)) continue;
            throw new IllegalArgumentException("NoSQLHandleConfig.setSSLProtocols: " + protocol + " is not a valid SSL protocol name. Must be one of " + VALID_SSL_PROTOCOLS);
        }
        return this;
    }

    public NoSQLHandleConfig setSSLSessionCacheSize(int cacheSize) {
        if (cacheSize < 0) {
            throw new IllegalArgumentException("NoSQLHandleConfig.setSSLSessionCacheSize: cacheSize must be a positive value or zero");
        }
        this.sslSessionCacheSize = cacheSize;
        return this;
    }

    public NoSQLHandleConfig setSSLSessionTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("NoSQLHandleConfig.setSSLSessionTimeout: timeout must be a positive value or zero");
        }
        this.sslSessionTimeout = timeout;
        return this;
    }

    public NoSQLHandleConfig setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public NoSQLHandleConfig setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
        return this;
    }

    public NoSQLHandleConfig setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    public NoSQLHandleConfig setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public NoSQLHandleConfig setSslContext(SslContext sslCtx) {
        this.sslCtx = sslCtx;
        return this;
    }

    public SslContext getSslContext() {
        return this.sslCtx;
    }

    public NoSQLHandleConfig clone() {
        try {
            NoSQLHandleConfig clone = (NoSQLHandleConfig)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException neverHappens) {
            return null;
        }
    }

    private static String checkRegionId(String endpoint, AuthorizationProvider provider) {
        try {
            Region region = Region.fromRegionId(endpoint);
            if (region != null) {
                NoSQLHandleConfig.checkRegion(region, provider);
                return region.endpoint();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return endpoint;
    }

    private static void checkRegion(Region region, AuthorizationProvider provider) {
        Region regionInProvider;
        if (provider instanceof Region.RegionProvider && (regionInProvider = ((Region.RegionProvider)((Object)provider)).getRegion()) != null && regionInProvider != region) {
            throw new IllegalArgumentException("Specified region " + region + " doesn't match the region  in AuthorizationProvider");
        }
    }

    static {
        VALID_SSL_PROTOCOLS.add("SSLv2");
        VALID_SSL_PROTOCOLS.add("SSLv3");
        VALID_SSL_PROTOCOLS.add("TLSv1");
        VALID_SSL_PROTOCOLS.add("TLSv1.1");
        VALID_SSL_PROTOCOLS.add("TLSv1.2");
        VALID_SSL_PROTOCOLS.add("TLSv1.3");
    }
}

