/*Generated by xorm 2022-08-02 22:39:05, from mysql to mysql*/

SET sql_mode='NO_BACKSLASH_ESCAPES';
CREATE TABLE IF NOT EXISTS `email_hash` (`hash` VARCHAR(32) PRIMARY KEY NOT NULL, `email` VARCHAR(255) NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_email_hash_email` ON `email_hash` (`email`);

CREATE TABLE IF NOT EXISTS `oauth2_application` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `uid` BIGINT(20) NULL, `name` VARCHAR(255) NULL, `client_id` VARCHAR(255) NULL, `client_secret` VARCHAR(255) NULL, `redirect_uris` TEXT NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_oauth2_application_uid` ON `oauth2_application` (`uid`);
CREATE UNIQUE INDEX `UQE_oauth2_application_client_id` ON `oauth2_application` (`client_id`);
CREATE INDEX `IDX_oauth2_application_created_unix` ON `oauth2_application` (`created_unix`);
CREATE INDEX `IDX_oauth2_application_updated_unix` ON `oauth2_application` (`updated_unix`);

CREATE TABLE IF NOT EXISTS `oauth2_authorization_code` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `grant_id` BIGINT(20) NULL, `code` VARCHAR(255) NULL, `code_challenge` VARCHAR(255) NULL, `code_challenge_method` VARCHAR(255) NULL, `redirect_uri` VARCHAR(255) NULL, `valid_until` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_oauth2_authorization_code_code` ON `oauth2_authorization_code` (`code`);
CREATE INDEX `IDX_oauth2_authorization_code_valid_until` ON `oauth2_authorization_code` (`valid_until`);

CREATE TABLE IF NOT EXISTS `oauth2_grant` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `user_id` BIGINT(20) NULL, `application_id` BIGINT(20) NULL, `counter` BIGINT(20) DEFAULT 1 NOT NULL, `scope` TEXT NULL, `nonce` TEXT NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_oauth2_grant_user_application` ON `oauth2_grant` (`user_id`,`application_id`);
CREATE INDEX `IDX_oauth2_grant_user_id` ON `oauth2_grant` (`user_id`);
CREATE INDEX `IDX_oauth2_grant_application_id` ON `oauth2_grant` (`application_id`);

CREATE TABLE IF NOT EXISTS `session` (`key` CHAR(16) PRIMARY KEY NOT NULL, `data` BLOB NULL, `expiry` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;

CREATE TABLE IF NOT EXISTS `login_source` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `type` INT NULL, `name` VARCHAR(255) NULL, `is_active` TINYINT(1) DEFAULT false NOT NULL, `is_sync_enabled` TINYINT(1) DEFAULT false NOT NULL, `cfg` TEXT NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_login_source_name` ON `login_source` (`name`);
CREATE INDEX `IDX_login_source_is_active` ON `login_source` (`is_active`);
CREATE INDEX `IDX_login_source_is_sync_enabled` ON `login_source` (`is_sync_enabled`);
CREATE INDEX `IDX_login_source_created_unix` ON `login_source` (`created_unix`);
CREATE INDEX `IDX_login_source_updated_unix` ON `login_source` (`updated_unix`);

CREATE TABLE IF NOT EXISTS `two_factor` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `uid` BIGINT(20) NULL, `secret` VARCHAR(255) NULL, `scratch_salt` VARCHAR(255) NULL, `scratch_hash` VARCHAR(255) NULL, `last_used_passcode` VARCHAR(10) NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_two_factor_uid` ON `two_factor` (`uid`);
CREATE INDEX `IDX_two_factor_created_unix` ON `two_factor` (`created_unix`);
CREATE INDEX `IDX_two_factor_updated_unix` ON `two_factor` (`updated_unix`);

CREATE TABLE IF NOT EXISTS `webauthn_credential` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `name` VARCHAR(255) NULL, `lower_name` VARCHAR(255) NULL, `user_id` BIGINT(20) NULL, `credential_id` VARBINARY(1024) NULL, `public_key` BLOB NULL, `attestation_type` VARCHAR(255) NULL, `aaguid` BLOB NULL, `sign_count` BIGINT(20) NULL, `clone_warning` TINYINT(1) NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_webauthn_credential_s` ON `webauthn_credential` (`lower_name`,`user_id`);
CREATE INDEX `IDX_webauthn_credential_user_id` ON `webauthn_credential` (`user_id`);
CREATE INDEX `IDX_webauthn_credential_credential_id` ON `webauthn_credential` (`credential_id`);
CREATE INDEX `IDX_webauthn_credential_created_unix` ON `webauthn_credential` (`created_unix`);
CREATE INDEX `IDX_webauthn_credential_updated_unix` ON `webauthn_credential` (`updated_unix`);

CREATE TABLE IF NOT EXISTS `email_address` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `uid` BIGINT(20) NOT NULL, `email` VARCHAR(255) NOT NULL, `lower_email` VARCHAR(255) NOT NULL, `is_activated` TINYINT(1) NULL, `is_primary` TINYINT(1) DEFAULT false NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_email_address_uid` ON `email_address` (`uid`);
CREATE UNIQUE INDEX `UQE_email_address_email` ON `email_address` (`email`);
CREATE UNIQUE INDEX `UQE_email_address_lower_email` ON `email_address` (`lower_email`);
INSERT INTO `email_address` (`id`, `uid`, `email`, `lower_email`, `is_activated`, `is_primary`) VALUES (1,1,'localhost@localdomain.com','localhost@localdomain.com',1,1);
INSERT INTO `email_address` (`id`, `uid`, `email`, `lower_email`, `is_activated`, `is_primary`) VALUES (13,2,'j@j.com','j@j.com',1,1);

CREATE TABLE IF NOT EXISTS `external_login_user` (`external_id` VARCHAR(255) NOT NULL, `user_id` BIGINT(20) NOT NULL, `login_source_id` BIGINT(20) NOT NULL, `raw_data` TEXT NULL, `provider` VARCHAR(25) NULL, `email` VARCHAR(255) NULL, `name` VARCHAR(255) NULL, `first_name` VARCHAR(255) NULL, `last_name` VARCHAR(255) NULL, `nick_name` VARCHAR(255) NULL, `description` VARCHAR(255) NULL, `avatar_url` TEXT NULL, `location` VARCHAR(255) NULL, `access_token` TEXT NULL, `access_token_secret` TEXT NULL, `refresh_token` TEXT NULL, `expires_at` DATETIME NULL, PRIMARY KEY (`external_id`,`login_source_id`)) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_external_login_user_user_id` ON `external_login_user` (`user_id`);
CREATE INDEX `IDX_external_login_user_provider` ON `external_login_user` (`provider`);

CREATE TABLE IF NOT EXISTS `follow` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `user_id` BIGINT(20) NULL, `follow_id` BIGINT(20) NULL, `created_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_follow_follow` ON `follow` (`user_id`,`follow_id`);
CREATE INDEX `IDX_follow_created_unix` ON `follow` (`created_unix`);

CREATE TABLE IF NOT EXISTS `user_open_id` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `uid` BIGINT(20) NOT NULL, `uri` VARCHAR(255) NOT NULL, `show` TINYINT(1) DEFAULT false NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_user_open_id_uid` ON `user_open_id` (`uid`);
CREATE UNIQUE INDEX `UQE_user_open_id_uri` ON `user_open_id` (`uri`);

CREATE TABLE IF NOT EXISTS `user_redirect` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `lower_name` VARCHAR(255) NOT NULL, `redirect_user_id` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_user_redirect_s` ON `user_redirect` (`lower_name`);
CREATE INDEX `IDX_user_redirect_lower_name` ON `user_redirect` (`lower_name`);
INSERT INTO `user_redirect` (`id`, `lower_name`, `redirect_user_id`) VALUES (1,'system',12);
INSERT INTO `user_redirect` (`id`, `lower_name`, `redirect_user_id`) VALUES (2,'itit',15);
INSERT INTO `user_redirect` (`id`, `lower_name`, `redirect_user_id`) VALUES (3,'jrb1',2);
INSERT INTO `user_redirect` (`id`, `lower_name`, `redirect_user_id`) VALUES (4,'jrb',2);

CREATE TABLE IF NOT EXISTS `user_setting` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `user_id` BIGINT(20) NULL, `setting_key` VARCHAR(255) NULL, `setting_value` TEXT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_user_setting_setting_key` ON `user_setting` (`setting_key`);
CREATE UNIQUE INDEX `UQE_user_setting_key_userid` ON `user_setting` (`user_id`,`setting_key`);
CREATE INDEX `IDX_user_setting_user_id` ON `user_setting` (`user_id`);

CREATE TABLE IF NOT EXISTS `user` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `lower_name` VARCHAR(255) NOT NULL, `name` VARCHAR(255) NOT NULL, `full_name` VARCHAR(255) NULL, `email` VARCHAR(255) NOT NULL, `keep_email_private` TINYINT(1) NULL, `email_notifications_preference` VARCHAR(20) DEFAULT 'enabled' NOT NULL, `passwd` VARCHAR(255) NOT NULL, `passwd_hash_algo` VARCHAR(255) DEFAULT 'argon2' NOT NULL, `must_change_password` TINYINT(1) DEFAULT false NOT NULL, `login_type` INT NULL, `login_source` BIGINT(20) DEFAULT 0 NOT NULL, `login_name` VARCHAR(255) NULL, `type` INT NULL, `location` VARCHAR(255) NULL, `website` VARCHAR(255) NULL, `rands` VARCHAR(32) NULL, `salt` VARCHAR(32) NULL, `language` VARCHAR(5) NULL, `description` VARCHAR(255) NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL, `last_login_unix` BIGINT(20) NULL, `last_repo_visibility` TINYINT(1) NULL, `max_repo_creation` INT DEFAULT -1 NOT NULL, `is_active` TINYINT(1) NULL, `is_admin` TINYINT(1) NULL, `is_restricted` TINYINT(1) DEFAULT false NOT NULL, `allow_git_hook` TINYINT(1) NULL, `allow_import_local` TINYINT(1) NULL, `allow_create_organization` TINYINT(1) DEFAULT true NULL, `prohibit_login` TINYINT(1) DEFAULT false NOT NULL, `avatar` VARCHAR(2048) NOT NULL, `avatar_email` VARCHAR(255) NOT NULL, `use_custom_avatar` TINYINT(1) NULL, `num_followers` INT NULL, `num_following` INT DEFAULT 0 NOT NULL, `num_stars` INT NULL, `num_repos` INT NULL, `num_teams` INT NULL, `num_members` INT NULL, `visibility` INT DEFAULT 0 NOT NULL, `repo_admin_change_team_access` TINYINT(1) DEFAULT false NOT NULL, `diff_view_style` VARCHAR(255) DEFAULT '' NOT NULL, `theme` VARCHAR(255) DEFAULT '' NOT NULL, `keep_activity_private` TINYINT(1) DEFAULT false NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_user_lower_name` ON `user` (`lower_name`);
CREATE UNIQUE INDEX `UQE_user_name` ON `user` (`name`);
CREATE INDEX `IDX_user_created_unix` ON `user` (`created_unix`);
CREATE INDEX `IDX_user_updated_unix` ON `user` (`updated_unix`);
CREATE INDEX `IDX_user_last_login_unix` ON `user` (`last_login_unix`);
CREATE INDEX `IDX_user_is_active` ON `user` (`is_active`);
INSERT INTO `user` (`id`, `lower_name`, `name`, `full_name`, `email`, `keep_email_private`, `email_notifications_preference`, `passwd`, `passwd_hash_algo`, `must_change_password`, `login_type`, `login_source`, `login_name`, `type`, `location`, `website`, `rands`, `salt`, `language`, `description`, `created_unix`, `updated_unix`, `last_login_unix`, `last_repo_visibility`, `max_repo_creation`, `is_active`, `is_admin`, `is_restricted`, `allow_git_hook`, `allow_import_local`, `allow_create_organization`, `prohibit_login`, `avatar`, `avatar_email`, `use_custom_avatar`, `num_followers`, `num_following`, `num_stars`, `num_repos`, `num_teams`, `num_members`, `visibility`, `repo_admin_change_team_access`, `diff_view_style`, `theme`, `keep_activity_private`) VALUES (1,'administrator','administrator','','localhost@localdomain.com',0,'enabled','e174e847c995dd8cb849255a7e42f2316630a20afb9f0b753114aad527153cecf4dc895c3c35a64ee4e2a487668e4dc174fa','pbkdf2',0,0,0,'',0,'','','xMBFABm67Z','9b3465e59ab47f5a1e0bbdcf4c8c674f','en-US','',1607337106,1659476229,1659476229,0,-1,1,1,0,0,0,1,0,'87fbed8293e1b59157a23f17b44f2cc8','jon.roadley-battin@utas.utc.com',0,0,0,0,0,0,0,0,0,'unified','gitea',0);
INSERT INTO `user` (`id`, `lower_name`, `name`, `full_name`, `email`, `keep_email_private`, `email_notifications_preference`, `passwd`, `passwd_hash_algo`, `must_change_password`, `login_type`, `login_source`, `login_name`, `type`, `location`, `website`, `rands`, `salt`, `language`, `description`, `created_unix`, `updated_unix`, `last_login_unix`, `last_repo_visibility`, `max_repo_creation`, `is_active`, `is_admin`, `is_restricted`, `allow_git_hook`, `allow_import_local`, `allow_create_organization`, `prohibit_login`, `avatar`, `avatar_email`, `use_custom_avatar`, `num_followers`, `num_following`, `num_stars`, `num_repos`, `num_teams`, `num_members`, `visibility`, `repo_admin_change_team_access`, `diff_view_style`, `theme`, `keep_activity_private`) VALUES (2,'j','j','jjjj','j@j.com',0,'disabled','cdfa3f2513b747d46741f50cceaa9b958dbc48f43ffbad30d505e963f5c8985fecc7a38edc67970baa62936a6423e8931f44','pbkdf2',0,0,0,'jon.roadley-battin@utas.utc.com',0,'','','0wfq7218IM','8e44346bec873b5a35644f57d89c5d8e','en-US','',1607337298,1659476297,1659476297,0,-1,1,0,0,0,0,1,0,'953503e7a14d64b6ba8e97d8d737186b','jon.roadley-battin@collins.com',0,0,0,0,0,0,0,0,0,'unified','gitea',0);
INSERT INTO `user` (`id`, `lower_name`, `name`, `full_name`, `email`, `keep_email_private`, `email_notifications_preference`, `passwd`, `passwd_hash_algo`, `must_change_password`, `login_type`, `login_source`, `login_name`, `type`, `location`, `website`, `rands`, `salt`, `language`, `description`, `created_unix`, `updated_unix`, `last_login_unix`, `last_repo_visibility`, `max_repo_creation`, `is_active`, `is_admin`, `is_restricted`, `allow_git_hook`, `allow_import_local`, `allow_create_organization`, `prohibit_login`, `avatar`, `avatar_email`, `use_custom_avatar`, `num_followers`, `num_following`, `num_stars`, `num_repos`, `num_teams`, `num_members`, `visibility`, `repo_admin_change_team_access`, `diff_view_style`, `theme`, `keep_activity_private`) VALUES (22,'ipcca','IPCCA','BadOrg','',0,'','','',0,0,0,'',1,'','','a93c526622d9187db6928442950231b7','41d51305207e5e479bfedb3b4ae62274','','Bad Org cannot create repos',1643026527,1659475183,0,0,10,1,0,0,0,0,0,0,'c39a7f5e8d4b771b6288ca882ccaf131','',1,0,0,0,0,1,1,0,1,'','',0);
INSERT INTO `user` (`id`, `lower_name`, `name`, `full_name`, `email`, `keep_email_private`, `email_notifications_preference`, `passwd`, `passwd_hash_algo`, `must_change_password`, `login_type`, `login_source`, `login_name`, `type`, `location`, `website`, `rands`, `salt`, `language`, `description`, `created_unix`, `updated_unix`, `last_login_unix`, `last_repo_visibility`, `max_repo_creation`, `is_active`, `is_admin`, `is_restricted`, `allow_git_hook`, `allow_import_local`, `allow_create_organization`, `prohibit_login`, `avatar`, `avatar_email`, `use_custom_avatar`, `num_followers`, `num_following`, `num_stars`, `num_repos`, `num_teams`, `num_members`, `visibility`, `repo_admin_change_team_access`, `diff_view_style`, `theme`, `keep_activity_private`) VALUES (23,'goodorg','GoodOrg','GoodOrg can create repos','',0,'','','',0,0,0,'',1,'','','bac9c8b8dcbe09113d40a0117f44486d','e9f914a1301bda9a21647f8d2452e842','','',1659475198,1659475221,0,0,-1,1,0,0,0,0,0,0,'9f609eb2538d408c2f246eb36cf9818a','',1,0,0,0,1,1,1,0,1,'','',0);

CREATE TABLE IF NOT EXISTS `repo_archiver` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NULL, `type` INT NULL, `status` INT NULL, `commit_id` VARCHAR(40) NULL, `created_unix` BIGINT(20) NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_repo_archiver_repo_id` ON `repo_archiver` (`repo_id`);
CREATE INDEX `IDX_repo_archiver_created_unix` ON `repo_archiver` (`created_unix`);
CREATE UNIQUE INDEX `UQE_repo_archiver_s` ON `repo_archiver` (`repo_id`,`type`,`commit_id`);

CREATE TABLE IF NOT EXISTS `attachment` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `uuid` VARCHAR(40) NULL, `repo_id` BIGINT(20) NULL, `issue_id` BIGINT(20) NULL, `release_id` BIGINT(20) NULL, `uploader_id` BIGINT(20) DEFAULT 0 NULL, `comment_id` BIGINT(20) NULL, `name` VARCHAR(255) NULL, `download_count` BIGINT(20) DEFAULT 0 NULL, `size` BIGINT(20) DEFAULT 0 NULL, `created_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_attachment_issue_id` ON `attachment` (`issue_id`);
CREATE INDEX `IDX_attachment_release_id` ON `attachment` (`release_id`);
CREATE INDEX `IDX_attachment_uploader_id` ON `attachment` (`uploader_id`);
CREATE UNIQUE INDEX `UQE_attachment_uuid` ON `attachment` (`uuid`);
CREATE INDEX `IDX_attachment_repo_id` ON `attachment` (`repo_id`);
INSERT INTO `attachment` (`id`, `uuid`, `repo_id`, `issue_id`, `release_id`, `uploader_id`, `comment_id`, `name`, `download_count`, `size`, `created_unix`) VALUES (1,'19cfaa67-1ab3-4b32-8872-ad3ae1064037',0,0,1,0,0,'InternalTestInterface~v1.5.1_64b.exe',0,23239817,1633010694);

CREATE TABLE IF NOT EXISTS `collaboration` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NOT NULL, `user_id` BIGINT(20) NOT NULL, `mode` INT DEFAULT 2 NOT NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_collaboration_updated_unix` ON `collaboration` (`updated_unix`);
CREATE UNIQUE INDEX `UQE_collaboration_s` ON `collaboration` (`repo_id`,`user_id`);
CREATE INDEX `IDX_collaboration_repo_id` ON `collaboration` (`repo_id`);
CREATE INDEX `IDX_collaboration_user_id` ON `collaboration` (`user_id`);
CREATE INDEX `IDX_collaboration_created_unix` ON `collaboration` (`created_unix`);

CREATE TABLE IF NOT EXISTS `language_stat` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NOT NULL, `commit_id` VARCHAR(255) NULL, `is_primary` TINYINT(1) NULL, `language` VARCHAR(50) NOT NULL, `size` BIGINT(20) DEFAULT 0 NOT NULL, `created_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_language_stat_s` ON `language_stat` (`repo_id`,`language`);
CREATE INDEX `IDX_language_stat_repo_id` ON `language_stat` (`repo_id`);
CREATE INDEX `IDX_language_stat_language` ON `language_stat` (`language`);
CREATE INDEX `IDX_language_stat_created_unix` ON `language_stat` (`created_unix`);

CREATE TABLE IF NOT EXISTS `mirror` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NULL, `interval` BIGINT(20) NULL, `enable_prune` TINYINT(1) DEFAULT true NOT NULL, `updated_unix` BIGINT(20) NULL, `next_update_unix` BIGINT(20) NULL, `lfs_enabled` TINYINT(1) DEFAULT false NOT NULL, `lfs_endpoint` TEXT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_mirror_repo_id` ON `mirror` (`repo_id`);
CREATE INDEX `IDX_mirror_updated_unix` ON `mirror` (`updated_unix`);
CREATE INDEX `IDX_mirror_next_update_unix` ON `mirror` (`next_update_unix`);

CREATE TABLE IF NOT EXISTS `push_mirror` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NULL, `remote_name` VARCHAR(255) NULL, `interval` BIGINT(20) NULL, `created_unix` BIGINT(20) NULL, `last_update` BIGINT(20) NULL, `last_error` TEXT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_push_mirror_last_update` ON `push_mirror` (`last_update`);
CREATE INDEX `IDX_push_mirror_repo_id` ON `push_mirror` (`repo_id`);

CREATE TABLE IF NOT EXISTS `repo_redirect` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `owner_id` BIGINT(20) NULL, `lower_name` VARCHAR(255) NOT NULL, `redirect_repo_id` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_repo_redirect_s` ON `repo_redirect` (`owner_id`,`lower_name`);
CREATE INDEX `IDX_repo_redirect_lower_name` ON `repo_redirect` (`lower_name`);

CREATE TABLE IF NOT EXISTS `repository` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `owner_id` BIGINT(20) NULL, `owner_name` VARCHAR(255) NULL, `lower_name` VARCHAR(255) NOT NULL, `name` VARCHAR(255) NOT NULL, `description` TEXT NULL, `website` VARCHAR(2048) NULL, `original_service_type` INT NULL, `original_url` VARCHAR(2048) NULL, `default_branch` VARCHAR(255) NULL, `num_watches` INT NULL, `num_stars` INT NULL, `num_forks` INT NULL, `num_issues` INT NULL, `num_closed_issues` INT NULL, `num_pulls` INT NULL, `num_closed_pulls` INT NULL, `num_milestones` INT DEFAULT 0 NOT NULL, `num_closed_milestones` INT DEFAULT 0 NOT NULL, `num_projects` INT DEFAULT 0 NOT NULL, `num_closed_projects` INT DEFAULT 0 NOT NULL, `is_private` TINYINT(1) NULL, `is_empty` TINYINT(1) NULL, `is_archived` TINYINT(1) NULL, `is_mirror` TINYINT(1) NULL, `status` INT DEFAULT 0 NOT NULL, `is_fork` TINYINT(1) DEFAULT false NOT NULL, `fork_id` BIGINT(20) NULL, `is_template` TINYINT(1) DEFAULT false NOT NULL, `template_id` BIGINT(20) NULL, `size` BIGINT(20) DEFAULT 0 NOT NULL, `is_fsck_enabled` TINYINT(1) DEFAULT true NOT NULL, `close_issues_via_commit_in_any_branch` TINYINT(1) DEFAULT false NOT NULL, `topics` TEXT NULL, `trust_model` INT NULL, `avatar` VARCHAR(64) NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_repository_s` ON `repository` (`owner_id`,`lower_name`);
CREATE INDEX `IDX_repository_owner_id` ON `repository` (`owner_id`);
CREATE INDEX `IDX_repository_is_template` ON `repository` (`is_template`);
CREATE INDEX `IDX_repository_updated_unix` ON `repository` (`updated_unix`);
CREATE INDEX `IDX_repository_original_service_type` ON `repository` (`original_service_type`);
CREATE INDEX `IDX_repository_is_private` ON `repository` (`is_private`);
CREATE INDEX `IDX_repository_template_id` ON `repository` (`template_id`);
CREATE INDEX `IDX_repository_fork_id` ON `repository` (`fork_id`);
CREATE INDEX `IDX_repository_lower_name` ON `repository` (`lower_name`);
CREATE INDEX `IDX_repository_name` ON `repository` (`name`);
CREATE INDEX `IDX_repository_is_empty` ON `repository` (`is_empty`);
CREATE INDEX `IDX_repository_is_archived` ON `repository` (`is_archived`);
CREATE INDEX `IDX_repository_is_mirror` ON `repository` (`is_mirror`);
CREATE INDEX `IDX_repository_is_fork` ON `repository` (`is_fork`);
CREATE INDEX `IDX_repository_created_unix` ON `repository` (`created_unix`);
INSERT INTO `repository` (`id`, `owner_id`, `owner_name`, `lower_name`, `name`, `description`, `website`, `original_service_type`, `original_url`, `default_branch`, `num_watches`, `num_stars`, `num_forks`, `num_issues`, `num_closed_issues`, `num_pulls`, `num_closed_pulls`, `num_milestones`, `num_closed_milestones`, `num_projects`, `num_closed_projects`, `is_private`, `is_empty`, `is_archived`, `is_mirror`, `status`, `is_fork`, `fork_id`, `is_template`, `template_id`, `size`, `is_fsck_enabled`, `close_issues_via_commit_in_any_branch`, `topics`, `trust_model`, `avatar`, `created_unix`, `updated_unix`) VALUES (1,23,'GoodOrg','blah','blah','','',0,'','main',1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,78688,1,0,'null',0,'',1659475208,1659475208);

CREATE TABLE IF NOT EXISTS `repo_indexer_status` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NULL, `commit_sha` VARCHAR(40) NULL, `indexer_type` INT DEFAULT 0 NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_repo_indexer_status_s` ON `repo_indexer_status` (`repo_id`,`indexer_type`);

CREATE TABLE IF NOT EXISTS `repo_unit` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NULL, `type` INT NULL, `config` TEXT NULL, `created_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_repo_unit_created_unix` ON `repo_unit` (`created_unix`);
CREATE INDEX `IDX_repo_unit_s` ON `repo_unit` (`repo_id`,`type`);
INSERT INTO `repo_unit` (`id`, `repo_id`, `type`, `config`, `created_unix`) VALUES (1,1,1,NULL,1659475208);
INSERT INTO `repo_unit` (`id`, `repo_id`, `type`, `config`, `created_unix`) VALUES (2,1,2,'{"EnableTimetracker":true,"AllowOnlyContributorsToTrackTime":true,"EnableDependencies":true}',1659475208);
INSERT INTO `repo_unit` (`id`, `repo_id`, `type`, `config`, `created_unix`) VALUES (3,1,3,'{"IgnoreWhitespaceConflicts":false,"AllowMerge":true,"AllowRebase":true,"AllowRebaseMerge":true,"AllowSquash":true,"AllowManualMerge":false,"AutodetectManualMerge":false,"AllowRebaseUpdate":true,"DefaultDeleteBranchAfterMerge":false,"DefaultMergeStyle":"merge"}',1659475208);
INSERT INTO `repo_unit` (`id`, `repo_id`, `type`, `config`, `created_unix`) VALUES (4,1,4,NULL,1659475208);
INSERT INTO `repo_unit` (`id`, `repo_id`, `type`, `config`, `created_unix`) VALUES (5,1,5,NULL,1659475208);
INSERT INTO `repo_unit` (`id`, `repo_id`, `type`, `config`, `created_unix`) VALUES (6,1,8,NULL,1659475208);
INSERT INTO `repo_unit` (`id`, `repo_id`, `type`, `config`, `created_unix`) VALUES (7,1,9,NULL,1659475208);

CREATE TABLE IF NOT EXISTS `star` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `uid` BIGINT(20) NULL, `repo_id` BIGINT(20) NULL, `created_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_star_s` ON `star` (`uid`,`repo_id`);
CREATE INDEX `IDX_star_created_unix` ON `star` (`created_unix`);

CREATE TABLE IF NOT EXISTS `topic` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `name` VARCHAR(50) NULL, `repo_count` INT NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_topic_created_unix` ON `topic` (`created_unix`);
CREATE INDEX `IDX_topic_updated_unix` ON `topic` (`updated_unix`);
CREATE UNIQUE INDEX `UQE_topic_name` ON `topic` (`name`);
INSERT INTO `topic` (`id`, `name`, `repo_count`, `created_unix`, `updated_unix`) VALUES (1,'test',0,1638545959,1638546889);
INSERT INTO `topic` (`id`, `name`, `repo_count`, `created_unix`, `updated_unix`) VALUES (2,'models',0,1638545994,1638546889);
INSERT INTO `topic` (`id`, `name`, `repo_count`, `created_unix`, `updated_unix`) VALUES (3,'srm',0,1638545994,1659473730);
INSERT INTO `topic` (`id`, `name`, `repo_count`, `created_unix`, `updated_unix`) VALUES (4,'matlav',0,1638547630,1638548046);
INSERT INTO `topic` (`id`, `name`, `repo_count`, `created_unix`, `updated_unix`) VALUES (5,'tech',0,1638547630,1659473730);
INSERT INTO `topic` (`id`, `name`, `repo_count`, `created_unix`, `updated_unix`) VALUES (6,'cosimula',0,1638547630,1638548046);
INSERT INTO `topic` (`id`, `name`, `repo_count`, `created_unix`, `updated_unix`) VALUES (7,'matlab',0,1638548046,1659473730);
INSERT INTO `topic` (`id`, `name`, `repo_count`, `created_unix`, `updated_unix`) VALUES (8,'co-simulation',0,1638548046,1659473730);
INSERT INTO `topic` (`id`, `name`, `repo_count`, `created_unix`, `updated_unix`) VALUES (9,'vhdl',0,1638554379,1659473743);
INSERT INTO `topic` (`id`, `name`, `repo_count`, `created_unix`, `updated_unix`) VALUES (10,'nvm',0,1639497710,1659474125);
INSERT INTO `topic` (`id`, `name`, `repo_count`, `created_unix`, `updated_unix`) VALUES (11,'submodule',0,1641318497,1659473743);
INSERT INTO `topic` (`id`, `name`, `repo_count`, `created_unix`, `updated_unix`) VALUES (12,'hardware',0,1647971830,1659473717);
INSERT INTO `topic` (`id`, `name`, `repo_count`, `created_unix`, `updated_unix`) VALUES (13,'pod',0,1647971830,1659473717);
INSERT INTO `topic` (`id`, `name`, `repo_count`, `created_unix`, `updated_unix`) VALUES (14,'model',0,1657531854,1659473579);
INSERT INTO `topic` (`id`, `name`, `repo_count`, `created_unix`, `updated_unix`) VALUES (15,'simulation',0,1657531854,1659473579);
INSERT INTO `topic` (`id`, `name`, `repo_count`, `created_unix`, `updated_unix`) VALUES (16,'active-rectifier',0,1657531854,1659473579);
INSERT INTO `topic` (`id`, `name`, `repo_count`, `created_unix`, `updated_unix`) VALUES (17,'2-level',0,1657531854,1659473579);

CREATE TABLE IF NOT EXISTS `repo_topic` (`repo_id` BIGINT(20) NOT NULL, `topic_id` BIGINT(20) NOT NULL, PRIMARY KEY (`repo_id`,`topic_id`)) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;

CREATE TABLE IF NOT EXISTS `watch` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `user_id` BIGINT(20) NULL, `repo_id` BIGINT(20) NULL, `mode` SMALLINT DEFAULT 1 NOT NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_watch_watch` ON `watch` (`user_id`,`repo_id`);
CREATE INDEX `IDX_watch_created_unix` ON `watch` (`created_unix`);
CREATE INDEX `IDX_watch_updated_unix` ON `watch` (`updated_unix`);
INSERT INTO `watch` (`id`, `user_id`, `repo_id`, `mode`, `created_unix`, `updated_unix`) VALUES (1,2,1,1,1659475208,1659475208);

CREATE TABLE IF NOT EXISTS `org_user` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `uid` BIGINT(20) NULL, `org_id` BIGINT(20) NULL, `is_public` TINYINT(1) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_org_user_uid` ON `org_user` (`uid`);
CREATE INDEX `IDX_org_user_org_id` ON `org_user` (`org_id`);
CREATE INDEX `IDX_org_user_is_public` ON `org_user` (`is_public`);
CREATE UNIQUE INDEX `UQE_org_user_s` ON `org_user` (`uid`,`org_id`);
INSERT INTO `org_user` (`id`, `uid`, `org_id`, `is_public`) VALUES (96,2,22,0);
INSERT INTO `org_user` (`id`, `uid`, `org_id`, `is_public`) VALUES (97,2,23,0);

CREATE TABLE IF NOT EXISTS `team` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `org_id` BIGINT(20) NULL, `lower_name` VARCHAR(255) NULL, `name` VARCHAR(255) NULL, `description` VARCHAR(255) NULL, `authorize` INT NULL, `num_repos` INT NULL, `num_members` INT NULL, `includes_all_repositories` TINYINT(1) DEFAULT false NOT NULL, `can_create_org_repo` TINYINT(1) DEFAULT false NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_team_org_id` ON `team` (`org_id`);
INSERT INTO `team` (`id`, `org_id`, `lower_name`, `name`, `description`, `authorize`, `num_repos`, `num_members`, `includes_all_repositories`, `can_create_org_repo`) VALUES (18,22,'owners','Owners','Main organization administrators ',4,0,1,1,0);
INSERT INTO `team` (`id`, `org_id`, `lower_name`, `name`, `description`, `authorize`, `num_repos`, `num_members`, `includes_all_repositories`, `can_create_org_repo`) VALUES (19,23,'owners','Owners','',4,1,1,1,1);

CREATE TABLE IF NOT EXISTS `team_user` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `org_id` BIGINT(20) NULL, `team_id` BIGINT(20) NULL, `uid` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_team_user_org_id` ON `team_user` (`org_id`);
CREATE UNIQUE INDEX `UQE_team_user_s` ON `team_user` (`team_id`,`uid`);
INSERT INTO `team_user` (`id`, `org_id`, `team_id`, `uid`) VALUES (138,22,18,2);
INSERT INTO `team_user` (`id`, `org_id`, `team_id`, `uid`) VALUES (139,23,19,2);

CREATE TABLE IF NOT EXISTS `team_repo` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `org_id` BIGINT(20) NULL, `team_id` BIGINT(20) NULL, `repo_id` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_team_repo_s` ON `team_repo` (`team_id`,`repo_id`);
CREATE INDEX `IDX_team_repo_org_id` ON `team_repo` (`org_id`);
INSERT INTO `team_repo` (`id`, `org_id`, `team_id`, `repo_id`) VALUES (120,22,19,53);
INSERT INTO `team_repo` (`id`, `org_id`, `team_id`, `repo_id`) VALUES (121,22,19,55);
INSERT INTO `team_repo` (`id`, `org_id`, `team_id`, `repo_id`) VALUES (122,22,19,59);
INSERT INTO `team_repo` (`id`, `org_id`, `team_id`, `repo_id`) VALUES (199,22,31,53);
INSERT INTO `team_repo` (`id`, `org_id`, `team_id`, `repo_id`) VALUES (200,22,31,55);
INSERT INTO `team_repo` (`id`, `org_id`, `team_id`, `repo_id`) VALUES (201,22,31,59);
INSERT INTO `team_repo` (`id`, `org_id`, `team_id`, `repo_id`) VALUES (202,22,31,83);
INSERT INTO `team_repo` (`id`, `org_id`, `team_id`, `repo_id`) VALUES (203,22,31,85);
INSERT INTO `team_repo` (`id`, `org_id`, `team_id`, `repo_id`) VALUES (208,22,31,93);
INSERT INTO `team_repo` (`id`, `org_id`, `team_id`, `repo_id`) VALUES (209,23,19,1);

CREATE TABLE IF NOT EXISTS `team_unit` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `org_id` BIGINT(20) NULL, `team_id` BIGINT(20) NULL, `type` INT NULL, `access_mode` INT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_team_unit_org_id` ON `team_unit` (`org_id`);
CREATE UNIQUE INDEX `UQE_team_unit_s` ON `team_unit` (`team_id`,`type`);
INSERT INTO `team_unit` (`id`, `org_id`, `team_id`, `type`, `access_mode`) VALUES (167,22,18,1,0);
INSERT INTO `team_unit` (`id`, `org_id`, `team_id`, `type`, `access_mode`) VALUES (168,22,18,2,0);
INSERT INTO `team_unit` (`id`, `org_id`, `team_id`, `type`, `access_mode`) VALUES (169,22,18,3,0);
INSERT INTO `team_unit` (`id`, `org_id`, `team_id`, `type`, `access_mode`) VALUES (170,22,18,4,0);
INSERT INTO `team_unit` (`id`, `org_id`, `team_id`, `type`, `access_mode`) VALUES (171,22,18,5,0);
INSERT INTO `team_unit` (`id`, `org_id`, `team_id`, `type`, `access_mode`) VALUES (172,22,18,6,0);
INSERT INTO `team_unit` (`id`, `org_id`, `team_id`, `type`, `access_mode`) VALUES (173,22,18,7,0);
INSERT INTO `team_unit` (`id`, `org_id`, `team_id`, `type`, `access_mode`) VALUES (174,22,18,8,0);
INSERT INTO `team_unit` (`id`, `org_id`, `team_id`, `type`, `access_mode`) VALUES (175,23,19,1,0);
INSERT INTO `team_unit` (`id`, `org_id`, `team_id`, `type`, `access_mode`) VALUES (176,23,19,2,0);
INSERT INTO `team_unit` (`id`, `org_id`, `team_id`, `type`, `access_mode`) VALUES (177,23,19,3,0);
INSERT INTO `team_unit` (`id`, `org_id`, `team_id`, `type`, `access_mode`) VALUES (178,23,19,4,0);
INSERT INTO `team_unit` (`id`, `org_id`, `team_id`, `type`, `access_mode`) VALUES (179,23,19,5,0);
INSERT INTO `team_unit` (`id`, `org_id`, `team_id`, `type`, `access_mode`) VALUES (180,23,19,6,0);
INSERT INTO `team_unit` (`id`, `org_id`, `team_id`, `type`, `access_mode`) VALUES (181,23,19,7,0);
INSERT INTO `team_unit` (`id`, `org_id`, `team_id`, `type`, `access_mode`) VALUES (182,23,19,8,0);
INSERT INTO `team_unit` (`id`, `org_id`, `team_id`, `type`, `access_mode`) VALUES (183,23,19,9,0);

CREATE TABLE IF NOT EXISTS `access` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `user_id` BIGINT(20) NULL, `repo_id` BIGINT(20) NULL, `mode` INT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_access_s` ON `access` (`user_id`,`repo_id`);
INSERT INTO `access` (`id`, `user_id`, `repo_id`, `mode`) VALUES (1,2,1,4);

CREATE TABLE IF NOT EXISTS `gpg_key` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `owner_id` BIGINT(20) NOT NULL, `key_id` CHAR(16) NOT NULL, `primary_key_id` CHAR(16) NULL, `content` TEXT NOT NULL, `created_unix` BIGINT(20) NULL, `expired_unix` BIGINT(20) NULL, `added_unix` BIGINT(20) NULL, `emails` TEXT NULL, `verified` TINYINT(1) DEFAULT false NOT NULL, `can_sign` TINYINT(1) NULL, `can_encrypt_comms` TINYINT(1) NULL, `can_encrypt_storage` TINYINT(1) NULL, `can_certify` TINYINT(1) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_gpg_key_owner_id` ON `gpg_key` (`owner_id`);
CREATE INDEX `IDX_gpg_key_key_id` ON `gpg_key` (`key_id`);

CREATE TABLE IF NOT EXISTS `gpg_key_import` (`key_id` CHAR(16) PRIMARY KEY NOT NULL, `content` TEXT NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;

CREATE TABLE IF NOT EXISTS `public_key` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `owner_id` BIGINT(20) NOT NULL, `name` VARCHAR(255) NOT NULL, `fingerprint` VARCHAR(255) NOT NULL, `content` TEXT NOT NULL, `mode` INT DEFAULT 2 NOT NULL, `type` INT DEFAULT 1 NOT NULL, `login_source_id` BIGINT(20) DEFAULT 0 NOT NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL, `verified` TINYINT(1) DEFAULT false NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_public_key_fingerprint` ON `public_key` (`fingerprint`);
CREATE INDEX `IDX_public_key_owner_id` ON `public_key` (`owner_id`);

CREATE TABLE IF NOT EXISTS `deploy_key` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `key_id` BIGINT(20) NULL, `repo_id` BIGINT(20) NULL, `name` VARCHAR(255) NULL, `fingerprint` VARCHAR(255) NULL, `mode` INT DEFAULT 1 NOT NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_deploy_key_repo_id` ON `deploy_key` (`repo_id`);
CREATE UNIQUE INDEX `UQE_deploy_key_s` ON `deploy_key` (`key_id`,`repo_id`);
CREATE INDEX `IDX_deploy_key_key_id` ON `deploy_key` (`key_id`);

CREATE TABLE IF NOT EXISTS `protected_branch` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NULL, `branch_name` VARCHAR(255) NULL, `can_push` TINYINT(1) DEFAULT false NOT NULL, `enable_whitelist` TINYINT(1) NULL, `whitelist_user_i_ds` TEXT NULL, `whitelist_team_i_ds` TEXT NULL, `enable_merge_whitelist` TINYINT(1) DEFAULT false NOT NULL, `whitelist_deploy_keys` TINYINT(1) DEFAULT false NOT NULL, `merge_whitelist_user_i_ds` TEXT NULL, `merge_whitelist_team_i_ds` TEXT NULL, `enable_status_check` TINYINT(1) DEFAULT false NOT NULL, `status_check_contexts` TEXT NULL, `enable_approvals_whitelist` TINYINT(1) DEFAULT false NOT NULL, `approvals_whitelist_user_i_ds` TEXT NULL, `approvals_whitelist_team_i_ds` TEXT NULL, `required_approvals` BIGINT(20) DEFAULT 0 NOT NULL, `block_on_rejected_reviews` TINYINT(1) DEFAULT false NOT NULL, `block_on_official_review_requests` TINYINT(1) DEFAULT false NOT NULL, `block_on_outdated_branch` TINYINT(1) DEFAULT false NOT NULL, `dismiss_stale_approvals` TINYINT(1) DEFAULT false NOT NULL, `require_signed_commits` TINYINT(1) DEFAULT false NOT NULL, `protected_file_patterns` TEXT NULL, `unprotected_file_patterns` TEXT NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_protected_branch_s` ON `protected_branch` (`repo_id`,`branch_name`);

CREATE TABLE IF NOT EXISTS `deleted_branch` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NOT NULL, `name` VARCHAR(255) NOT NULL, `commit` VARCHAR(255) NOT NULL, `deleted_by_id` BIGINT(20) NULL, `deleted_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_deleted_branch_deleted_unix` ON `deleted_branch` (`deleted_unix`);
CREATE INDEX `IDX_deleted_branch_repo_id` ON `deleted_branch` (`repo_id`);
CREATE UNIQUE INDEX `UQE_deleted_branch_s` ON `deleted_branch` (`repo_id`,`name`,`commit`);
CREATE INDEX `IDX_deleted_branch_deleted_by_id` ON `deleted_branch` (`deleted_by_id`);

CREATE TABLE IF NOT EXISTS `renamed_branch` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NOT NULL, `from` VARCHAR(255) NULL, `to` VARCHAR(255) NULL, `created_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_renamed_branch_repo_id` ON `renamed_branch` (`repo_id`);

CREATE TABLE IF NOT EXISTS `commit_status` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `index` BIGINT(20) NULL, `repo_id` BIGINT(20) NULL, `state` VARCHAR(7) NOT NULL, `sha` VARCHAR(64) NOT NULL, `target_url` TEXT NULL, `description` TEXT NULL, `context_hash` CHAR(40) NULL, `context` TEXT NULL, `creator_id` BIGINT(20) NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_commit_status_repo_sha_index` ON `commit_status` (`index`,`repo_id`,`sha`);
CREATE INDEX `IDX_commit_status_index` ON `commit_status` (`index`);
CREATE INDEX `IDX_commit_status_repo_id` ON `commit_status` (`repo_id`);
CREATE INDEX `IDX_commit_status_sha` ON `commit_status` (`sha`);
CREATE INDEX `IDX_commit_status_context_hash` ON `commit_status` (`context_hash`);
CREATE INDEX `IDX_commit_status_created_unix` ON `commit_status` (`created_unix`);
CREATE INDEX `IDX_commit_status_updated_unix` ON `commit_status` (`updated_unix`);

CREATE TABLE IF NOT EXISTS `commit_status_index` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NULL, `sha` VARCHAR(255) NULL, `max_index` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_commit_status_index_repo_sha` ON `commit_status_index` (`repo_id`,`sha`);
CREATE INDEX `IDX_commit_status_index_max_index` ON `commit_status_index` (`max_index`);

CREATE TABLE IF NOT EXISTS `lfs_meta_object` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `oid` VARCHAR(255) NOT NULL, `size` BIGINT(20) NOT NULL, `repository_id` BIGINT(20) NOT NULL, `created_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_lfs_meta_object_s` ON `lfs_meta_object` (`oid`,`repository_id`);
CREATE INDEX `IDX_lfs_meta_object_oid` ON `lfs_meta_object` (`oid`);
CREATE INDEX `IDX_lfs_meta_object_repository_id` ON `lfs_meta_object` (`repository_id`);

CREATE TABLE IF NOT EXISTS `lfs_lock` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NOT NULL, `owner_id` BIGINT(20) NOT NULL, `path` TEXT NULL, `created` DATETIME NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_lfs_lock_owner_id` ON `lfs_lock` (`owner_id`);
CREATE INDEX `IDX_lfs_lock_repo_id` ON `lfs_lock` (`repo_id`);

CREATE TABLE IF NOT EXISTS `protected_tag` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NULL, `name_pattern` VARCHAR(255) NULL, `allowlist_user_i_ds` TEXT NULL, `allowlist_team_i_ds` TEXT NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;

CREATE TABLE IF NOT EXISTS `project_board` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `title` VARCHAR(255) NULL, `default` TINYINT(1) DEFAULT false NOT NULL, `sorting` INT DEFAULT 0 NOT NULL, `color` VARCHAR(7) NULL, `project_id` BIGINT(20) NOT NULL, `creator_id` BIGINT(20) NOT NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_project_board_project_id` ON `project_board` (`project_id`);
CREATE INDEX `IDX_project_board_created_unix` ON `project_board` (`created_unix`);
CREATE INDEX `IDX_project_board_updated_unix` ON `project_board` (`updated_unix`);

CREATE TABLE IF NOT EXISTS `project_issue` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `issue_id` BIGINT(20) NULL, `project_id` BIGINT(20) NULL, `project_board_id` BIGINT(20) NULL, `sorting` BIGINT(20) DEFAULT 0 NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_project_issue_issue_id` ON `project_issue` (`issue_id`);
CREATE INDEX `IDX_project_issue_project_id` ON `project_issue` (`project_id`);
CREATE INDEX `IDX_project_issue_project_board_id` ON `project_issue` (`project_board_id`);

CREATE TABLE IF NOT EXISTS `project` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `title` VARCHAR(255) NOT NULL, `description` TEXT NULL, `repo_id` BIGINT(20) NULL, `creator_id` BIGINT(20) NOT NULL, `is_closed` TINYINT(1) NULL, `board_type` INT UNSIGNED NULL, `type` INT UNSIGNED NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL, `closed_date_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_project_title` ON `project` (`title`);
CREATE INDEX `IDX_project_repo_id` ON `project` (`repo_id`);
CREATE INDEX `IDX_project_is_closed` ON `project` (`is_closed`);
CREATE INDEX `IDX_project_created_unix` ON `project` (`created_unix`);
CREATE INDEX `IDX_project_updated_unix` ON `project` (`updated_unix`);

CREATE TABLE IF NOT EXISTS `notice` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `type` INT NULL, `description` TEXT NULL, `created_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_notice_created_unix` ON `notice` (`created_unix`);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (435,2,'Cron: Delete old repository archives has finished',1641513600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (436,2,'Cron: Clean-up deleted branches has finished',1641513600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (437,2,'Cron: Cleanup hook_task table has finished',1641513600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (438,2,'Cron: Check all repository statistics has finished',1641513600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (439,2,'Cron: Update migration poster IDs has finished',1641513600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (440,2,'Cron: Synchronize external user data has finished',1641513600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (441,2,'Cron: Health check all repositories has finished',1641513606);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (442,2,'Cron: Clean-up deleted branches has finished',1641600000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (443,2,'Cron: Cleanup hook_task table has finished',1641600000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (444,2,'Cron: Update migration poster IDs has finished',1641600000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (445,2,'Cron: Check all repository statistics has finished',1641600000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (446,2,'Cron: Delete old repository archives has finished',1641600000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (447,2,'Cron: Synchronize external user data has finished',1641600000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (448,2,'Cron: Health check all repositories has finished',1641600007);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (449,2,'Cron: Cleanup hook_task table has finished',1641686400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (450,2,'Cron: Clean-up deleted branches has finished',1641686400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (451,2,'Cron: Delete old repository archives has finished',1641686400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (452,2,'Cron: Update migration poster IDs has finished',1641686400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (453,2,'Cron: Check all repository statistics has finished',1641686400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (454,2,'Cron: Synchronize external user data has finished',1641686400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (455,2,'Cron: Health check all repositories has finished',1641686407);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (456,2,'Cron: Cleanup hook_task table has finished',1641772800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (457,2,'Cron: Delete old repository archives has finished',1641772800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (458,2,'Cron: Clean-up deleted branches has finished',1641772800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (459,2,'Cron: Check all repository statistics has finished',1641772800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (460,2,'Cron: Update migration poster IDs has finished',1641772800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (461,2,'Cron: Synchronize external user data has finished',1641772800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (462,2,'Cron: Health check all repositories has finished',1641772808);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (463,2,'Cron: Cleanup hook_task table has finished',1641859200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (464,2,'Cron: Delete old repository archives has finished',1641859200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (465,2,'Cron: Clean-up deleted branches has finished',1641859200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (466,2,'Cron: Check all repository statistics has finished',1641859200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (467,2,'Cron: Update migration poster IDs has finished',1641859200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (468,2,'Cron: Synchronize external user data has finished',1641859200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (469,2,'Cron: Health check all repositories has finished',1641859206);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (470,2,'Error in Cron: dashboard.update_checker: Get "https://dl.gitea.io/gitea/version.json": dial tcp 104.21.60.7:443: connectex: A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond.',1641902167);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (471,2,'Cron: Clean-up deleted branches has finished',1641945600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (472,2,'Cron: Check all repository statistics has finished',1641945600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (473,2,'Cron: Delete old repository archives has finished',1641945600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (474,2,'Cron: Synchronize external user data has finished',1641945600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (475,2,'Cron: Update migration poster IDs has finished',1641945600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (476,2,'Cron: Cleanup hook_task table has finished',1641945600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (477,2,'Cron: Health check all repositories has finished',1641945608);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (478,2,'Cron: Cleanup hook_task table has finished',1642032000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (479,2,'Cron: Clean-up deleted branches has finished',1642032000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (480,2,'Cron: Delete old repository archives has finished',1642032000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (481,2,'Cron: Update migration poster IDs has finished',1642032000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (482,2,'Cron: Check all repository statistics has finished',1642032000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (483,2,'Cron: Synchronize external user data has finished',1642032000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (484,2,'Cron: Health check all repositories has finished',1642032008);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (485,2,'Cron: Delete old repository archives has finished',1642118400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (486,2,'Cron: Cleanup hook_task table has finished',1642118400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (487,2,'Cron: Clean-up deleted branches has finished',1642118400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (488,2,'Cron: Update migration poster IDs has finished',1642118400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (489,2,'Cron: Check all repository statistics has finished',1642118400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (490,2,'Cron: Synchronize external user data has finished',1642118400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (491,2,'Cron: Health check all repositories has finished',1642118408);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (492,2,'Cron: Delete old repository archives has finished',1642204800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (493,2,'Cron: Cleanup hook_task table has finished',1642204800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (494,2,'Cron: Check all repository statistics has finished',1642204800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (495,2,'Cron: Clean-up deleted branches has finished',1642204800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (496,2,'Cron: Update migration poster IDs has finished',1642204800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (497,2,'Cron: Synchronize external user data has finished',1642204800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (498,2,'Cron: Health check all repositories has finished',1642204809);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (499,2,'Cron: Cleanup hook_task table has finished',1642291200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (500,2,'Cron: Clean-up deleted branches has finished',1642291200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (501,2,'Cron: Delete old repository archives has finished',1642291200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (502,2,'Cron: Synchronize external user data has finished',1642291200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (503,2,'Cron: Update migration poster IDs has finished',1642291200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (504,2,'Cron: Check all repository statistics has finished',1642291200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (505,2,'Cron: Health check all repositories has finished',1642291208);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (506,2,'Cron: Clean-up deleted branches has finished',1642315103);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (507,2,'Cron: Delete old repository archives has finished',1642315103);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (508,2,'Cron: Update migration poster IDs has finished',1642315103);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (509,2,'Cron: Check all repository statistics has finished',1642315103);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (510,2,'Cron: Clean-up deleted branches has finished',1642325407);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (511,2,'Cron: Delete old repository archives has finished',1642325407);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (512,2,'Cron: Update migration poster IDs has finished',1642325407);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (513,2,'Cron: Check all repository statistics has finished',1642325407);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (514,2,'Cron: Clean-up deleted branches has finished',1642377600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (515,2,'Cron: Cleanup hook_task table has finished',1642377600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (516,2,'Cron: Delete old repository archives has finished',1642377600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (517,2,'Cron: Update migration poster IDs has finished',1642377600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (518,2,'Cron: Check all repository statistics has finished',1642377600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (519,2,'Cron: Synchronize external user data has finished',1642377600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (520,2,'Cron: Health check all repositories has finished',1642377608);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (521,2,'Cron: Clean-up deleted branches has finished',1642464000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (522,2,'Cron: Cleanup hook_task table has finished',1642464000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (523,2,'Cron: Delete old repository archives has finished',1642464000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (524,2,'Cron: Update migration poster IDs has finished',1642464000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (525,2,'Cron: Synchronize external user data has finished',1642464000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (526,2,'Cron: Check all repository statistics has finished',1642464000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (527,2,'Cron: Health check all repositories has finished',1642464008);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (528,2,'Cron: Cleanup hook_task table has finished',1642550400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (529,2,'Cron: Delete old repository archives has finished',1642550400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (530,2,'Cron: Clean-up deleted branches has finished',1642550400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (531,2,'Cron: Update migration poster IDs has finished',1642550400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (532,2,'Cron: Check all repository statistics has finished',1642550400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (533,2,'Cron: Synchronize external user data has finished',1642550400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (534,2,'Cron: Health check all repositories has finished',1642550408);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (535,2,'Task: Garbage collect all repositories started by administrator has finished',1642604525);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (536,2,'Cron: Cleanup hook_task table has finished',1642636800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (537,2,'Cron: Clean-up deleted branches has finished',1642636800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (538,2,'Cron: Delete old repository archives has finished',1642636800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (539,2,'Cron: Update migration poster IDs has finished',1642636800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (540,2,'Cron: Synchronize external user data has finished',1642636800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (541,2,'Cron: Check all repository statistics has finished',1642636800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (542,2,'Cron: Health check all repositories has finished',1642636804);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (543,2,'Cron: Cleanup hook_task table has finished',1642723200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (544,2,'Cron: Delete old repository archives has finished',1642723200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (545,2,'Cron: Clean-up deleted branches has finished',1642723200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (546,2,'Cron: Synchronize external user data has finished',1642723200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (547,2,'Cron: Check all repository statistics has finished',1642723200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (548,2,'Cron: Update migration poster IDs has finished',1642723200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (549,2,'Cron: Health check all repositories has finished',1642723205);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (550,2,'Cron: Clean-up deleted branches has finished',1642809600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (551,2,'Cron: Cleanup hook_task table has finished',1642809600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (552,2,'Cron: Synchronize external user data has finished',1642809600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (553,2,'Cron: Delete old repository archives has finished',1642809600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (554,2,'Cron: Check all repository statistics has finished',1642809600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (555,2,'Cron: Update migration poster IDs has finished',1642809600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (556,2,'Cron: Health check all repositories has finished',1642809606);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (557,2,'Cron: Clean-up deleted branches has finished',1642896000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (558,2,'Cron: Cleanup hook_task table has finished',1642896000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (559,2,'Cron: Delete old repository archives has finished',1642896000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (560,2,'Cron: Check all repository statistics has finished',1642896000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (561,2,'Cron: Update migration poster IDs has finished',1642896000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (562,2,'Cron: Synchronize external user data has finished',1642896000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (563,2,'Cron: Health check all repositories has finished',1642896006);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (564,2,'Error in Cron: dashboard.update_checker: Get "https://dl.gitea.io/gitea/version.json": dial tcp 172.67.186.211:443: connectex: A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond.',1642930249);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (565,2,'Cron: Clean-up deleted branches has finished',1642982400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (566,2,'Cron: Cleanup hook_task table has finished',1642982400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (567,2,'Cron: Synchronize external user data has finished',1642982400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (568,2,'Cron: Update migration poster IDs has finished',1642982400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (569,2,'Cron: Check all repository statistics has finished',1642982400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (570,2,'Cron: Delete old repository archives has finished',1642982400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (571,2,'Cron: Health check all repositories has finished',1642982405);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (572,2,'Cron: Delete old repository archives has finished',1643026412);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (573,2,'Cron: Clean-up deleted branches has finished',1643026412);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (574,2,'Cron: Update migration poster IDs has finished',1643026412);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (575,2,'Cron: Check all repository statistics has finished',1643026412);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (576,2,'Cron: Cleanup hook_task table has finished',1643068800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (577,2,'Cron: Delete old repository archives has finished',1643068800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (578,2,'Cron: Clean-up deleted branches has finished',1643068800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (579,2,'Cron: Update migration poster IDs has finished',1643068800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (580,2,'Cron: Check all repository statistics has finished',1643068800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (581,2,'Cron: Synchronize external user data has finished',1643068800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (582,2,'Cron: Health check all repositories has finished',1643068812);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (583,2,'Cron: Clean-up deleted branches has finished',1643155200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (584,2,'Cron: Cleanup hook_task table has finished',1643155200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (585,2,'Cron: Delete old repository archives has finished',1643155200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (586,2,'Cron: Update migration poster IDs has finished',1643155200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (587,2,'Cron: Check all repository statistics has finished',1643155200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (588,2,'Cron: Synchronize external user data has finished',1643155200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (589,2,'Cron: Health check all repositories has finished',1643155206);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (590,2,'Cron: Delete old repository archives has finished',1643241600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (591,2,'Cron: Clean-up deleted branches has finished',1643241600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (592,2,'Cron: Cleanup hook_task table has finished',1643241600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (593,2,'Cron: Synchronize external user data has finished',1643241600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (594,2,'Cron: Update migration poster IDs has finished',1643241600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (595,2,'Cron: Check all repository statistics has finished',1643241600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (596,2,'Cron: Health check all repositories has finished',1643241608);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (597,2,'Cron: Delete old repository archives has finished',1643328000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (598,2,'Cron: Cleanup hook_task table has finished',1643328000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (599,2,'Cron: Clean-up deleted branches has finished',1643328000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (600,2,'Cron: Check all repository statistics has finished',1643328000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (601,2,'Cron: Synchronize external user data has finished',1643328000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (602,2,'Cron: Update migration poster IDs has finished',1643328000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (603,2,'Cron: Health check all repositories has finished',1643328008);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (604,2,'Cron: Clean-up deleted branches has finished',1643414400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (605,2,'Cron: Delete old repository archives has finished',1643414400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (606,2,'Cron: Cleanup hook_task table has finished',1643414400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (607,2,'Cron: Synchronize external user data has finished',1643414400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (608,2,'Cron: Update migration poster IDs has finished',1643414400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (609,2,'Cron: Check all repository statistics has finished',1643414400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (610,2,'Cron: Health check all repositories has finished',1643414408);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (611,2,'Cron: Cleanup hook_task table has finished',1643500800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (612,2,'Cron: Clean-up deleted branches has finished',1643500800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (613,2,'Cron: Delete old repository archives has finished',1643500800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (614,2,'Cron: Synchronize external user data has finished',1643500800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (615,2,'Cron: Update migration poster IDs has finished',1643500800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (616,2,'Cron: Check all repository statistics has finished',1643500800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (617,2,'Cron: Health check all repositories has finished',1643500808);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (618,2,'Cron: Cleanup hook_task table has finished',1643587200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (619,2,'Cron: Delete old repository archives has finished',1643587200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (620,2,'Cron: Clean-up deleted branches has finished',1643587200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (621,2,'Cron: Update migration poster IDs has finished',1643587200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (622,2,'Cron: Check all repository statistics has finished',1643587200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (623,2,'Cron: Synchronize external user data has finished',1643587200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (624,2,'Cron: Health check all repositories has finished',1643587208);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (625,2,'Error in Cron: dashboard.update_checker: Get "https://dl.gitea.io/gitea/version.json": dial tcp 104.21.60.7:443: connectex: A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond.',1643631254);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (626,2,'Cron: Delete old repository archives has finished',1643673600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (627,2,'Cron: Cleanup hook_task table has finished',1643673600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (628,2,'Cron: Clean-up deleted branches has finished',1643673600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (629,2,'Cron: Update migration poster IDs has finished',1643673600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (630,2,'Cron: Synchronize external user data has finished',1643673600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (631,2,'Cron: Check all repository statistics has finished',1643673600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (632,2,'Cron: Health check all repositories has finished',1643673608);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (633,2,'Cron: Clean-up deleted branches has finished',1643760000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (634,2,'Cron: Delete old repository archives has finished',1643760000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (635,2,'Cron: Cleanup hook_task table has finished',1643760000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (636,2,'Cron: Synchronize external user data has finished',1643760000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (637,2,'Cron: Update migration poster IDs has finished',1643760000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (638,2,'Cron: Check all repository statistics has finished',1643760000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (639,2,'Cron: Health check all repositories has finished',1643760008);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (640,2,'Cron: Clean-up deleted branches has finished',1643846400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (641,2,'Cron: Delete old repository archives has finished',1643846400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (642,2,'Cron: Update migration poster IDs has finished',1643846400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (643,2,'Cron: Check all repository statistics has finished',1643846400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (644,2,'Cron: Cleanup hook_task table has finished',1643846400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (645,2,'Cron: Synchronize external user data has finished',1643846400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (646,2,'Cron: Health check all repositories has finished',1643846408);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (647,2,'Cron: Clean-up deleted branches has finished',1643932800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (648,2,'Cron: Cleanup hook_task table has finished',1643932800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (649,2,'Cron: Delete old repository archives has finished',1643932800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (650,2,'Cron: Update migration poster IDs has finished',1643932800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (651,2,'Cron: Check all repository statistics has finished',1643932800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (652,2,'Cron: Synchronize external user data has finished',1643932800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (653,2,'Cron: Health check all repositories has finished',1643932809);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (654,2,'Cron: Clean-up deleted branches has finished',1644019200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (655,2,'Cron: Cleanup hook_task table has finished',1644019200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (656,2,'Cron: Synchronize external user data has finished',1644019200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (657,2,'Cron: Update migration poster IDs has finished',1644019200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (658,2,'Cron: Check all repository statistics has finished',1644019200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (659,2,'Cron: Delete old repository archives has finished',1644019200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (660,2,'Cron: Health check all repositories has finished',1644019210);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (661,2,'Cron: Clean-up deleted branches has finished',1644105600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (662,2,'Cron: Delete old repository archives has finished',1644105600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (663,2,'Cron: Cleanup hook_task table has finished',1644105600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (664,2,'Cron: Synchronize external user data has finished',1644105600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (665,2,'Cron: Update migration poster IDs has finished',1644105600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (666,2,'Cron: Check all repository statistics has finished',1644105600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (667,2,'Cron: Health check all repositories has finished',1644105609);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (668,2,'Cron: Cleanup hook_task table has finished',1644192000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (669,2,'Cron: Delete old repository archives has finished',1644192000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (670,2,'Cron: Clean-up deleted branches has finished',1644192000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (671,2,'Cron: Update migration poster IDs has finished',1644192000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (672,2,'Cron: Check all repository statistics has finished',1644192000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (673,2,'Cron: Synchronize external user data has finished',1644192000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (674,2,'Cron: Health check all repositories has finished',1644192009);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (675,2,'Error in Cron: dashboard.update_checker: Get "https://dl.gitea.io/gitea/version.json": dial tcp 104.21.60.7:443: connectex: A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond.',1644236054);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (676,2,'Cron: Cleanup hook_task table has finished',1644278400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (677,2,'Cron: Clean-up deleted branches has finished',1644278400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (678,2,'Cron: Delete old repository archives has finished',1644278400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (679,2,'Cron: Update migration poster IDs has finished',1644278400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (680,2,'Cron: Check all repository statistics has finished',1644278400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (681,2,'Cron: Synchronize external user data has finished',1644278400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (682,2,'Cron: Health check all repositories has finished',1644278408);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (683,2,'Cron: Clean-up deleted branches has finished',1644364800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (684,2,'Cron: Cleanup hook_task table has finished',1644364800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (685,2,'Cron: Delete old repository archives has finished',1644364800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (686,2,'Cron: Update migration poster IDs has finished',1644364800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (687,2,'Cron: Synchronize external user data has finished',1644364800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (688,2,'Cron: Check all repository statistics has finished',1644364800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (689,2,'Cron: Health check all repositories has finished',1644364809);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (690,2,'Cron: Clean-up deleted branches has finished',1644451200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (691,2,'Cron: Cleanup hook_task table has finished',1644451200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (692,2,'Cron: Delete old repository archives has finished',1644451200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (693,2,'Cron: Check all repository statistics has finished',1644451200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (694,2,'Cron: Update migration poster IDs has finished',1644451200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (695,2,'Cron: Synchronize external user data has finished',1644451200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (696,2,'Cron: Health check all repositories has finished',1644451210);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (697,2,'Cron: Clean-up deleted branches has finished',1644537600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (698,2,'Cron: Cleanup hook_task table has finished',1644537600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (699,2,'Cron: Delete old repository archives has finished',1644537600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (700,2,'Cron: Update migration poster IDs has finished',1644537600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (701,2,'Cron: Synchronize external user data has finished',1644537600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (702,2,'Cron: Check all repository statistics has finished',1644537600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (703,2,'Cron: Health check all repositories has finished',1644537609);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (704,2,'Cron: Clean-up deleted branches has finished',1644624000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (705,2,'Cron: Delete old repository archives has finished',1644624000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (706,2,'Cron: Cleanup hook_task table has finished',1644624000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (707,2,'Cron: Update migration poster IDs has finished',1644624000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (708,2,'Cron: Synchronize external user data has finished',1644624000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (709,2,'Cron: Check all repository statistics has finished',1644624000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (710,2,'Cron: Health check all repositories has finished',1644624010);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (711,2,'Cron: Clean-up deleted branches has finished',1644710400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (712,2,'Cron: Delete old repository archives has finished',1644710400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (713,2,'Cron: Cleanup hook_task table has finished',1644710400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (714,2,'Cron: Update migration poster IDs has finished',1644710400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (715,2,'Cron: Synchronize external user data has finished',1644710400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (716,2,'Cron: Check all repository statistics has finished',1644710400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (717,2,'Cron: Health check all repositories has finished',1644710410);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (718,2,'Cron: Clean-up deleted branches has finished',1644796800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (719,2,'Cron: Delete old repository archives has finished',1644796800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (720,2,'Cron: Cleanup hook_task table has finished',1644796800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (721,2,'Cron: Check all repository statistics has finished',1644796800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (722,2,'Cron: Update migration poster IDs has finished',1644796800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (723,2,'Cron: Synchronize external user data has finished',1644796800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (724,2,'Cron: Health check all repositories has finished',1644796810);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (725,2,'Error in Cron: dashboard.update_checker: Get "https://dl.gitea.io/gitea/version.json": dial tcp 104.26.1.119:443: connectex: A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond.',1644840875);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (726,2,'Cron: Clean-up deleted branches has finished',1644883200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (727,2,'Cron: Cleanup hook_task table has finished',1644883200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (728,2,'Cron: Update migration poster IDs has finished',1644883200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (729,2,'Cron: Delete old repository archives has finished',1644883200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (730,2,'Cron: Check all repository statistics has finished',1644883200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (731,2,'Cron: Synchronize external user data has finished',1644883200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (732,2,'Cron: Health check all repositories has finished',1644883212);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (733,2,'Cron: Delete old repository archives has finished',1644935275);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (734,2,'Cron: Clean-up deleted branches has finished',1644935275);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (735,2,'Cron: Update migration poster IDs has finished',1644935276);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (736,2,'Cron: Check all repository statistics has finished',1644935276);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (737,2,'Cron: Delete old repository archives has finished',1644935733);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (738,2,'Cron: Clean-up deleted branches has finished',1644935733);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (739,2,'Cron: Update migration poster IDs has finished',1644935733);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (740,2,'Cron: Check all repository statistics has finished',1644935733);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (741,2,'Cron: Cleanup hook_task table has finished',1644969600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (742,2,'Cron: Delete old repository archives has finished',1644969600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (743,2,'Cron: Clean-up deleted branches has finished',1644969600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (744,2,'Cron: Update migration poster IDs has finished',1644969600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (745,2,'Cron: Synchronize external user data has finished',1644969600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (746,2,'Cron: Check all repository statistics has finished',1644969600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (747,2,'Cron: Health check all repositories has finished',1644969607);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (748,2,'Cron: Clean-up deleted branches has finished',1645056000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (749,2,'Cron: Cleanup hook_task table has finished',1645056000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (750,2,'Cron: Delete old repository archives has finished',1645056000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (751,2,'Cron: Update migration poster IDs has finished',1645056000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (752,2,'Cron: Check all repository statistics has finished',1645056000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (753,2,'Cron: Synchronize external user data has finished',1645056000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (754,2,'Cron: Health check all repositories has finished',1645056007);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (755,2,'Cron: Synchronize external user data has finished',1645142400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (756,2,'Cron: Clean-up deleted branches has finished',1645142400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (757,2,'Cron: Delete old repository archives has finished',1645142400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (758,2,'Cron: Cleanup hook_task table has finished',1645142400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (759,2,'Cron: Update migration poster IDs has finished',1645142400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (760,2,'Cron: Check all repository statistics has finished',1645142400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (761,2,'Cron: Health check all repositories has finished',1645142411);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (762,2,'Cron: Cleanup hook_task table has finished',1645228800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (763,2,'Cron: Delete old repository archives has finished',1645228800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (764,2,'Cron: Clean-up deleted branches has finished',1645228800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (765,2,'Cron: Synchronize external user data has finished',1645228800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (766,2,'Cron: Check all repository statistics has finished',1645228800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (767,2,'Cron: Update migration poster IDs has finished',1645228800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (768,2,'Cron: Health check all repositories has finished',1645228812);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (769,2,'Cron: Cleanup hook_task table has finished',1645315200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (770,2,'Cron: Synchronize external user data has finished',1645315200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (771,2,'Cron: Delete old repository archives has finished',1645315200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (772,2,'Cron: Clean-up deleted branches has finished',1645315200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (773,2,'Cron: Update migration poster IDs has finished',1645315200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (774,2,'Cron: Check all repository statistics has finished',1645315200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (775,2,'Cron: Health check all repositories has finished',1645315211);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (776,2,'Cron: Delete old repository archives has finished',1645349707);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (777,2,'Cron: Update migration poster IDs has finished',1645349707);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (778,2,'Cron: Clean-up deleted branches has finished',1645349707);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (779,2,'Cron: Check all repository statistics has finished',1645349707);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (780,2,'Cron: Clean-up deleted branches has finished',1645389833);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (781,2,'Cron: Delete old repository archives has finished',1645389833);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (782,2,'Cron: Update migration poster IDs has finished',1645389833);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (783,2,'Cron: Check all repository statistics has finished',1645389834);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (784,2,'Cron: Clean-up deleted branches has finished',1645401600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (785,2,'Cron: Cleanup hook_task table has finished',1645401600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (786,2,'Cron: Delete old repository archives has finished',1645401600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (787,2,'Cron: Synchronize external user data has finished',1645401600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (788,2,'Cron: Update migration poster IDs has finished',1645401600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (789,2,'Cron: Check all repository statistics has finished',1645401600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (790,2,'Cron: Health check all repositories has finished',1645401612);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (791,2,'Cron: Delete old repository archives has finished',1645488000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (792,2,'Cron: Synchronize external user data has finished',1645488000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (793,2,'Cron: Clean-up deleted branches has finished',1645488000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (794,2,'Cron: Cleanup hook_task table has finished',1645488000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (795,2,'Cron: Update migration poster IDs has finished',1645488000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (796,2,'Cron: Check all repository statistics has finished',1645488000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (797,2,'Cron: Health check all repositories has finished',1645488011);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (798,2,'Cron: Cleanup hook_task table has finished',1645574400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (799,2,'Cron: Synchronize external user data has finished',1645574400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (800,2,'Cron: Clean-up deleted branches has finished',1645574400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (801,2,'Cron: Delete old repository archives has finished',1645574400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (802,2,'Cron: Check all repository statistics has finished',1645574400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (803,2,'Cron: Update migration poster IDs has finished',1645574400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (804,2,'Cron: Health check all repositories has finished',1645574414);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (805,2,'Cron: Synchronize external user data has finished',1645660800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (806,2,'Cron: Cleanup hook_task table has finished',1645660800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (807,2,'Cron: Clean-up deleted branches has finished',1645660800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (808,2,'Cron: Delete old repository archives has finished',1645660800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (809,2,'Cron: Update migration poster IDs has finished',1645660800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (810,2,'Cron: Check all repository statistics has finished',1645660800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (811,2,'Cron: Health check all repositories has finished',1645660815);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (812,2,'Cron: Cleanup hook_task table has finished',1645747200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (813,2,'Cron: Clean-up deleted branches has finished',1645747200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (814,2,'Cron: Delete old repository archives has finished',1645747200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (815,2,'Cron: Synchronize external user data has finished',1645747200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (816,2,'Cron: Update migration poster IDs has finished',1645747200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (817,2,'Cron: Check all repository statistics has finished',1645747200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (818,2,'Cron: Health check all repositories has finished',1645747215);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (819,2,'Cron: Clean-up deleted branches has finished',1645833600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (820,2,'Cron: Delete old repository archives has finished',1645833600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (821,2,'Cron: Synchronize external user data has finished',1645833600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (822,2,'Cron: Cleanup hook_task table has finished',1645833600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (823,2,'Cron: Update migration poster IDs has finished',1645833600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (824,2,'Cron: Check all repository statistics has finished',1645833600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (825,2,'Cron: Health check all repositories has finished',1645833616);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (826,2,'Cron: Clean-up deleted branches has finished',1645920000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (827,2,'Cron: Synchronize external user data has finished',1645920000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (828,2,'Cron: Cleanup hook_task table has finished',1645920000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (829,2,'Cron: Delete old repository archives has finished',1645920000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (830,2,'Cron: Update migration poster IDs has finished',1645920000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (831,2,'Cron: Check all repository statistics has finished',1645920000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (832,2,'Cron: Health check all repositories has finished',1645920016);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (833,2,'Error in Cron: dashboard.update_checker: Get "https://dl.gitea.io/gitea/version.json": dial tcp 172.67.74.188:443: connectex: A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond.',1645994696);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (834,2,'Cron: Delete old repository archives has finished',1646006400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (835,2,'Cron: Clean-up deleted branches has finished',1646006400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (836,2,'Cron: Synchronize external user data has finished',1646006400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (837,2,'Cron: Update migration poster IDs has finished',1646006400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (838,2,'Cron: Cleanup hook_task table has finished',1646006400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (839,2,'Cron: Check all repository statistics has finished',1646006400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (840,2,'Cron: Health check all repositories has finished',1646006411);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (841,2,'Cron: Cleanup hook_task table has finished',1646092800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (842,2,'Cron: Synchronize external user data has finished',1646092800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (843,2,'Cron: Delete old repository archives has finished',1646092800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (844,2,'Cron: Clean-up deleted branches has finished',1646092800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (845,2,'Cron: Update migration poster IDs has finished',1646092800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (846,2,'Cron: Check all repository statistics has finished',1646092800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (847,2,'Cron: Health check all repositories has finished',1646092815);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (848,2,'Cron: Synchronize external user data has finished',1646179200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (849,2,'Cron: Clean-up deleted branches has finished',1646179200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (850,2,'Cron: Cleanup hook_task table has finished',1646179200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (851,2,'Cron: Update migration poster IDs has finished',1646179200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (852,2,'Cron: Delete old repository archives has finished',1646179200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (853,2,'Cron: Check all repository statistics has finished',1646179200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (854,2,'Cron: Health check all repositories has finished',1646179216);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (855,2,'Cron: Clean-up deleted branches has finished',1646265600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (856,2,'Cron: Delete old repository archives has finished',1646265600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (857,2,'Cron: Cleanup hook_task table has finished',1646265600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (858,2,'Cron: Update migration poster IDs has finished',1646265600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (859,2,'Cron: Synchronize external user data has finished',1646265600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (860,2,'Cron: Check all repository statistics has finished',1646265600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (861,2,'Cron: Health check all repositories has finished',1646265617);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (862,2,'Cron: Delete old repository archives has finished',1646352000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (863,2,'Cron: Clean-up deleted branches has finished',1646352000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (864,2,'Cron: Cleanup hook_task table has finished',1646352000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (865,2,'Cron: Synchronize external user data has finished',1646352000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (866,2,'Cron: Update migration poster IDs has finished',1646352000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (867,2,'Cron: Check all repository statistics has finished',1646352000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (868,2,'Cron: Health check all repositories has finished',1646352017);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (869,2,'Cron: Clean-up deleted branches has finished',1646438400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (870,2,'Cron: Synchronize external user data has finished',1646438400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (871,2,'Cron: Delete old repository archives has finished',1646438400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (872,2,'Cron: Update migration poster IDs has finished',1646438400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (873,2,'Cron: Cleanup hook_task table has finished',1646438400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (874,2,'Cron: Check all repository statistics has finished',1646438400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (875,2,'Cron: Health check all repositories has finished',1646438419);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (876,2,'Cron: Cleanup hook_task table has finished',1646524800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (877,2,'Cron: Synchronize external user data has finished',1646524800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (878,2,'Cron: Clean-up deleted branches has finished',1646524800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (879,2,'Cron: Update migration poster IDs has finished',1646524800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (880,2,'Cron: Delete old repository archives has finished',1646524800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (881,2,'Cron: Check all repository statistics has finished',1646524800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (882,2,'Cron: Health check all repositories has finished',1646524818);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (883,2,'Cron: Clean-up deleted branches has finished',1646530216);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (884,2,'Cron: Delete old repository archives has finished',1646530216);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (885,2,'Cron: Check all repository statistics has finished',1646530216);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (886,2,'Cron: Update migration poster IDs has finished',1646530216);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (887,2,'Cron: Cleanup hook_task table has finished',1646611200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (888,2,'Cron: Clean-up deleted branches has finished',1646611200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (889,2,'Cron: Synchronize external user data has finished',1646611200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (890,2,'Cron: Delete old repository archives has finished',1646611200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (891,2,'Cron: Update migration poster IDs has finished',1646611200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (892,2,'Cron: Check all repository statistics has finished',1646611200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (893,2,'Cron: Health check all repositories has finished',1646611218);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (894,2,'Cron: Delete old repository archives has finished',1646697600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (895,2,'Cron: Synchronize external user data has finished',1646697600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (896,2,'Cron: Cleanup hook_task table has finished',1646697600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (897,2,'Cron: Clean-up deleted branches has finished',1646697600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (898,2,'Cron: Update migration poster IDs has finished',1646697600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (899,2,'Cron: Check all repository statistics has finished',1646697600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (900,2,'Cron: Health check all repositories has finished',1646697617);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (901,2,'Cron: Clean-up deleted branches has finished',1646784000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (902,2,'Cron: Synchronize external user data has finished',1646784000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (903,2,'Cron: Delete old repository archives has finished',1646784000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (904,2,'Cron: Update migration poster IDs has finished',1646784000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (905,2,'Cron: Cleanup hook_task table has finished',1646784000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (906,2,'Cron: Check all repository statistics has finished',1646784000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (907,2,'Cron: Health check all repositories has finished',1646784017);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (908,2,'Cron: Clean-up deleted branches has finished',1646870400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (909,2,'Cron: Synchronize external user data has finished',1646870400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (910,2,'Cron: Update migration poster IDs has finished',1646870400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (911,2,'Cron: Delete old repository archives has finished',1646870400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (912,2,'Cron: Cleanup hook_task table has finished',1646870400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (913,2,'Cron: Check all repository statistics has finished',1646870400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (914,2,'Cron: Health check all repositories has finished',1646870417);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (915,2,'Cron: Delete old repository archives has finished',1646956800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (916,2,'Cron: Clean-up deleted branches has finished',1646956800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (917,2,'Cron: Synchronize external user data has finished',1646956800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (918,2,'Cron: Update migration poster IDs has finished',1646956800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (919,2,'Cron: Cleanup hook_task table has finished',1646956800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (920,2,'Cron: Check all repository statistics has finished',1646956800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (921,2,'Cron: Health check all repositories has finished',1646956819);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (922,2,'Cron: Delete old repository archives has finished',1647043200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (923,2,'Cron: Cleanup hook_task table has finished',1647043200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (924,2,'Cron: Clean-up deleted branches has finished',1647043200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (925,2,'Cron: Synchronize external user data has finished',1647043200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (926,2,'Cron: Update migration poster IDs has finished',1647043200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (927,2,'Cron: Check all repository statistics has finished',1647043200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (928,2,'Cron: Health check all repositories has finished',1647043218);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (929,2,'Cron: Clean-up deleted branches has finished',1647129600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (930,2,'Cron: Cleanup hook_task table has finished',1647129600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (931,2,'Cron: Synchronize external user data has finished',1647129600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (932,2,'Cron: Delete old repository archives has finished',1647129600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (933,2,'Cron: Update migration poster IDs has finished',1647129600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (934,2,'Cron: Check all repository statistics has finished',1647129600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (935,2,'Cron: Health check all repositories has finished',1647129615);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (936,2,'Error in Cron: Update checker: Get "https://dl.gitea.io/gitea/version.json": dial tcp 104.26.0.119:443: connectex: A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond.',1647135079);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (937,2,'Cron: Synchronize external user data has finished',1647216000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (938,2,'Cron: Cleanup hook_task table has finished',1647216000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (939,2,'Cron: Delete old repository archives has finished',1647216000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (940,2,'Cron: Clean-up deleted branches has finished',1647216000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (941,2,'Cron: Update migration poster IDs has finished',1647216000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (942,2,'Cron: Check all repository statistics has finished',1647216000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (943,2,'Cron: Health check all repositories has finished',1647216019);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (944,2,'Cron: Clean-up deleted branches has finished',1647302400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (945,2,'Cron: Cleanup hook_task table has finished',1647302400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (946,2,'Cron: Synchronize external user data has finished',1647302400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (947,2,'Cron: Delete old repository archives has finished',1647302400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (948,2,'Cron: Update migration poster IDs has finished',1647302400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (949,2,'Cron: Check all repository statistics has finished',1647302400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (950,2,'Cron: Health check all repositories has finished',1647302417);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (951,2,'Cron: Clean-up deleted branches has finished',1647388800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (952,2,'Cron: Cleanup hook_task table has finished',1647388800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (953,2,'Cron: Synchronize external user data has finished',1647388800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (954,2,'Cron: Delete old repository archives has finished',1647388800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (955,2,'Cron: Update migration poster IDs has finished',1647388800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (956,2,'Cron: Check all repository statistics has finished',1647388800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (957,2,'Cron: Health check all repositories has finished',1647388818);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (958,2,'Cron: Cleanup hook_task table has finished',1647475200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (959,2,'Cron: Clean-up deleted branches has finished',1647475200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (960,2,'Cron: Synchronize external user data has finished',1647475200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (961,2,'Cron: Delete old repository archives has finished',1647475200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (962,2,'Cron: Update migration poster IDs has finished',1647475200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (963,2,'Cron: Check all repository statistics has finished',1647475200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (964,2,'Cron: Health check all repositories has finished',1647475217);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (965,2,'Cron: Clean-up deleted branches has finished',1647561600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (966,2,'Cron: Cleanup hook_task table has finished',1647561600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (967,2,'Cron: Delete old repository archives has finished',1647561600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (968,2,'Cron: Synchronize external user data has finished',1647561600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (969,2,'Cron: Update migration poster IDs has finished',1647561600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (970,2,'Cron: Check all repository statistics has finished',1647561600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (971,2,'Cron: Health check all repositories has finished',1647561619);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (972,2,'Cron: Cleanup hook_task table has finished',1647648000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (973,2,'Cron: Update migration poster IDs has finished',1647648000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (974,2,'Cron: Clean-up deleted branches has finished',1647648000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (975,2,'Cron: Delete old repository archives has finished',1647648000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (976,2,'Cron: Synchronize external user data has finished',1647648000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (977,2,'Cron: Check all repository statistics has finished',1647648000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (978,2,'Cron: Health check all repositories has finished',1647648020);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (979,2,'Cron: Clean-up deleted branches has finished',1647734400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (980,2,'Cron: Cleanup hook_task table has finished',1647734400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (981,2,'Cron: Delete old repository archives has finished',1647734400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (982,2,'Cron: Update migration poster IDs has finished',1647734400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (983,2,'Cron: Synchronize external user data has finished',1647734400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (984,2,'Cron: Check all repository statistics has finished',1647734400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (985,2,'Cron: Health check all repositories has finished',1647734413);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (986,2,'Error in Cron: Update checker: Get "https://dl.gitea.io/gitea/version.json": dial tcp 104.26.0.119:443: connectex: A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond.',1647739879);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (987,2,'Cron: Update migration poster IDs has finished',1647771287);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (988,2,'Cron: Clean-up deleted branches has finished',1647771287);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (989,2,'Cron: Delete old repository archives has finished',1647771287);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (990,2,'Cron: Check all repository statistics has finished',1647771288);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (991,2,'Cron: Clean-up deleted branches has finished',1647784829);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (992,2,'Cron: Delete old repository archives has finished',1647784829);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (993,2,'Cron: Update migration poster IDs has finished',1647784829);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (994,2,'Cron: Check all repository statistics has finished',1647784829);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (995,2,'Cron: Cleanup hook_task table has finished',1647820800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (996,2,'Cron: Clean-up deleted branches has finished',1647820800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (997,2,'Cron: Delete old repository archives has finished',1647820800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (998,2,'Cron: Synchronize external user data has finished',1647820800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (999,2,'Cron: Update migration poster IDs has finished',1647820800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1000,2,'Cron: Check all repository statistics has finished',1647820800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1001,2,'Cron: Health check all repositories has finished',1647820823);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1002,2,'Cron: Clean-up deleted branches has finished',1647907200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1003,2,'Cron: Cleanup hook_task table has finished',1647907200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1004,2,'Cron: Delete old repository archives has finished',1647907200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1005,2,'Cron: Update migration poster IDs has finished',1647907200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1006,2,'Cron: Check all repository statistics has finished',1647907200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1007,2,'Cron: Synchronize external user data has finished',1647907200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1008,2,'Cron: Health check all repositories has finished',1647907220);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1009,2,'Cron: Clean-up deleted branches has finished',1647992900);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1010,2,'Cron: Delete old repository archives has finished',1647992900);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1011,2,'Cron: Update migration poster IDs has finished',1647992900);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1012,2,'Cron: Check all repository statistics has finished',1647992900);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1013,2,'Cron: Cleanup hook_task table has finished',1647993600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1014,2,'Cron: Delete old repository archives has finished',1647993600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1015,2,'Cron: Clean-up deleted branches has finished',1647993600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1016,2,'Cron: Update migration poster IDs has finished',1647993600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1017,2,'Cron: Check all repository statistics has finished',1647993600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1018,2,'Cron: Synchronize external user data has finished',1647993600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1019,2,'Cron: Health check all repositories has finished',1647993613);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1020,2,'Cron: Clean-up deleted branches has finished',1648060052);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1021,2,'Cron: Delete old repository archives has finished',1648060052);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1022,2,'Cron: Update migration poster IDs has finished',1648060052);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1023,2,'Cron: Check all repository statistics has finished',1648060052);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1024,2,'Task: Health check all repositories started by administrator has finished',1648060333);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1025,2,'Cron: Update migration poster IDs has finished',1648080000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1026,2,'Cron: Clean-up deleted branches has finished',1648080000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1027,2,'Cron: Cleanup hook_task table has finished',1648080000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1028,2,'Cron: Delete old repository archives has finished',1648080000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1029,2,'Cron: Check all repository statistics has finished',1648080000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1030,2,'Cron: Synchronize external user data has finished',1648080000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1031,2,'Cron: Health check all repositories has finished',1648080020);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1032,2,'Cron: Clean-up deleted branches has finished',1648166400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1033,2,'Cron: Delete old repository archives has finished',1648166400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1034,2,'Cron: Cleanup hook_task table has finished',1648166400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1035,2,'Cron: Update migration poster IDs has finished',1648166400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1036,2,'Cron: Synchronize external user data has finished',1648166400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1037,2,'Cron: Check all repository statistics has finished',1648166400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1038,2,'Cron: Health check all repositories has finished',1648166421);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1039,2,'Cron: Clean-up deleted branches has finished',1648252800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1040,2,'Cron: Cleanup hook_task table has finished',1648252800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1041,2,'Cron: Delete old repository archives has finished',1648252800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1042,2,'Cron: Synchronize external user data has finished',1648252800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1043,2,'Cron: Update migration poster IDs has finished',1648252800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1044,2,'Cron: Check all repository statistics has finished',1648252800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1045,2,'Cron: Health check all repositories has finished',1648252824);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1046,2,'Cron: Clean-up deleted branches has finished',1648339200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1047,2,'Cron: Delete old repository archives has finished',1648339200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1048,2,'Cron: Cleanup hook_task table has finished',1648339200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1049,2,'Cron: Update migration poster IDs has finished',1648339200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1050,2,'Cron: Synchronize external user data has finished',1648339200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1051,2,'Cron: Check all repository statistics has finished',1648339200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1052,2,'Cron: Health check all repositories has finished',1648339213);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1053,2,'Cron: Clean-up deleted branches has finished',1648422000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1054,2,'Cron: Cleanup hook_task table has finished',1648422000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1055,2,'Cron: Delete old repository archives has finished',1648422000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1056,2,'Cron: Synchronize external user data has finished',1648422000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1057,2,'Cron: Update migration poster IDs has finished',1648422000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1058,2,'Cron: Check all repository statistics has finished',1648422000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1059,2,'Cron: Health check all repositories has finished',1648422012);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1060,2,'Cron: Cleanup hook_task table has finished',1648508400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1061,2,'Cron: Clean-up deleted branches has finished',1648508400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1062,2,'Cron: Delete old repository archives has finished',1648508400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1063,2,'Cron: Synchronize external user data has finished',1648508400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1064,2,'Cron: Update migration poster IDs has finished',1648508400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1065,2,'Cron: Check all repository statistics has finished',1648508400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1066,2,'Cron: Health check all repositories has finished',1648508421);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1067,2,'Cron: Cleanup hook_task table has finished',1648594800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1068,2,'Cron: Delete old repository archives has finished',1648594800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1069,2,'Cron: Clean-up deleted branches has finished',1648594800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1070,2,'Cron: Update migration poster IDs has finished',1648594800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1071,2,'Cron: Synchronize external user data has finished',1648594800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1072,2,'Cron: Check all repository statistics has finished',1648594800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1073,2,'Cron: Health check all repositories has finished',1648594821);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1074,2,'Error in Cron: Update checker: Get "https://dl.gitea.io/gitea/version.json": dial tcp 172.67.74.188:443: connectex: A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond.',1648664915);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1075,2,'Cron: Clean-up deleted branches has finished',1648681200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1076,2,'Cron: Cleanup hook_task table has finished',1648681200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1077,2,'Cron: Delete old repository archives has finished',1648681200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1078,2,'Cron: Synchronize external user data has finished',1648681200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1079,2,'Cron: Update migration poster IDs has finished',1648681200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1080,2,'Cron: Check all repository statistics has finished',1648681200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1081,2,'Cron: Health check all repositories has finished',1648681221);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1082,2,'Cron: Delete old repository archives has finished',1648767600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1083,2,'Cron: Clean-up deleted branches has finished',1648767600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1084,2,'Cron: Cleanup hook_task table has finished',1648767600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1085,2,'Cron: Check all repository statistics has finished',1648767600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1086,2,'Cron: Update migration poster IDs has finished',1648767600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1087,2,'Cron: Synchronize external user data has finished',1648767600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1088,2,'Cron: Health check all repositories has finished',1648767622);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1089,2,'Cron: Clean-up deleted branches has finished',1648854000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1090,2,'Cron: Cleanup hook_task table has finished',1648854000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1091,2,'Cron: Synchronize external user data has finished',1648854000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1092,2,'Cron: Update migration poster IDs has finished',1648854000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1093,2,'Cron: Delete old repository archives has finished',1648854000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1094,2,'Cron: Check all repository statistics has finished',1648854000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1095,2,'Cron: Health check all repositories has finished',1648854022);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1096,2,'Cron: Clean-up deleted branches has finished',1648940400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1097,2,'Cron: Delete old repository archives has finished',1648940400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1098,2,'Cron: Cleanup hook_task table has finished',1648940400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1099,2,'Cron: Synchronize external user data has finished',1648940400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1100,2,'Cron: Update migration poster IDs has finished',1648940400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1101,2,'Cron: Check all repository statistics has finished',1648940400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1102,2,'Cron: Health check all repositories has finished',1648940423);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1103,2,'Cron: Clean-up deleted branches has finished',1649026800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1104,2,'Cron: Cleanup hook_task table has finished',1649026800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1105,2,'Cron: Delete old repository archives has finished',1649026800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1106,2,'Cron: Synchronize external user data has finished',1649026800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1107,2,'Cron: Update migration poster IDs has finished',1649026800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1108,2,'Cron: Check all repository statistics has finished',1649026800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1109,2,'Cron: Health check all repositories has finished',1649026827);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1110,2,'Cron: Clean-up deleted branches has finished',1649113200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1111,2,'Cron: Cleanup hook_task table has finished',1649113200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1112,2,'Cron: Update migration poster IDs has finished',1649113200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1113,2,'Cron: Synchronize external user data has finished',1649113200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1114,2,'Cron: Delete old repository archives has finished',1649113200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1115,2,'Cron: Check all repository statistics has finished',1649113200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1116,2,'Cron: Health check all repositories has finished',1649113223);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1117,2,'Cron: Cleanup hook_task table has finished',1649199600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1118,2,'Cron: Clean-up deleted branches has finished',1649199600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1119,2,'Cron: Delete old repository archives has finished',1649199600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1120,2,'Cron: Synchronize external user data has finished',1649199600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1121,2,'Cron: Update migration poster IDs has finished',1649199600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1122,2,'Cron: Check all repository statistics has finished',1649199600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1123,2,'Cron: Health check all repositories has finished',1649199622);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1124,2,'Error in Cron: Update checker: Get "https://dl.gitea.io/gitea/version.json": dial tcp 172.67.74.188:443: connectex: A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond.',1649269715);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1125,2,'Cron: Cleanup hook_task table has finished',1649286000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1126,2,'Cron: Delete old repository archives has finished',1649286000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1127,2,'Cron: Clean-up deleted branches has finished',1649286000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1128,2,'Cron: Synchronize external user data has finished',1649286000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1129,2,'Cron: Update migration poster IDs has finished',1649286000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1130,2,'Cron: Check all repository statistics has finished',1649286000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1131,2,'Cron: Health check all repositories has finished',1649286023);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1132,2,'Cron: Clean-up deleted branches has finished',1649372400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1133,2,'Cron: Delete old repository archives has finished',1649372400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1134,2,'Cron: Synchronize external user data has finished',1649372400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1135,2,'Cron: Cleanup hook_task table has finished',1649372400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1136,2,'Cron: Update migration poster IDs has finished',1649372400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1137,2,'Cron: Check all repository statistics has finished',1649372400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1138,2,'Cron: Health check all repositories has finished',1649372424);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1139,2,'Cron: Clean-up deleted branches has finished',1649458800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1140,2,'Cron: Cleanup hook_task table has finished',1649458800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1141,2,'Cron: Delete old repository archives has finished',1649458800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1142,2,'Cron: Update migration poster IDs has finished',1649458800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1143,2,'Cron: Synchronize external user data has finished',1649458800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1144,2,'Cron: Check all repository statistics has finished',1649458800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1145,2,'Cron: Health check all repositories has finished',1649458820);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1146,2,'Cron: Delete old repository archives has finished',1649545200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1147,2,'Cron: Cleanup hook_task table has finished',1649545200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1148,2,'Cron: Clean-up deleted branches has finished',1649545200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1149,2,'Cron: Update migration poster IDs has finished',1649545200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1150,2,'Cron: Synchronize external user data has finished',1649545200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1151,2,'Cron: Check all repository statistics has finished',1649545200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1152,2,'Cron: Health check all repositories has finished',1649545218);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1153,2,'Cron: Clean-up deleted branches has finished',1649631600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1154,2,'Cron: Cleanup hook_task table has finished',1649631600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1155,2,'Cron: Delete old repository archives has finished',1649631600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1156,2,'Cron: Check all repository statistics has finished',1649631600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1157,2,'Cron: Synchronize external user data has finished',1649631600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1158,2,'Cron: Update migration poster IDs has finished',1649631600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1159,2,'Cron: Health check all repositories has finished',1649631614);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1160,2,'Cron: Delete old repository archives has finished',1649718000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1161,2,'Cron: Cleanup hook_task table has finished',1649718000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1162,2,'Cron: Clean-up deleted branches has finished',1649718000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1163,2,'Cron: Synchronize external user data has finished',1649718000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1164,2,'Cron: Update migration poster IDs has finished',1649718000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1165,2,'Cron: Check all repository statistics has finished',1649718000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1166,2,'Cron: Health check all repositories has finished',1649718017);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1167,2,'Cron: Delete old repository archives has finished',1649804400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1168,2,'Cron: Clean-up deleted branches has finished',1649804400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1169,2,'Cron: Cleanup hook_task table has finished',1649804400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1170,2,'Cron: Synchronize external user data has finished',1649804400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1171,2,'Cron: Update migration poster IDs has finished',1649804400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1172,2,'Cron: Check all repository statistics has finished',1649804400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1173,2,'Cron: Health check all repositories has finished',1649804414);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1174,2,'Error in Cron: Update checker: Get "https://dl.gitea.io/gitea/version.json": dial tcp 104.26.1.119:443: connectex: A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond.',1649874515);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1175,2,'Cron: Clean-up deleted branches has finished',1649890800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1176,2,'Cron: Cleanup hook_task table has finished',1649890800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1177,2,'Cron: Delete old repository archives has finished',1649890800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1178,2,'Cron: Update migration poster IDs has finished',1649890800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1179,2,'Cron: Synchronize external user data has finished',1649890800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1180,2,'Cron: Check all repository statistics has finished',1649890800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1181,2,'Cron: Health check all repositories has finished',1649890817);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1182,2,'Cron: Clean-up deleted branches has finished',1649977200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1183,2,'Cron: Update migration poster IDs has finished',1649977200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1184,2,'Cron: Synchronize external user data has finished',1649977200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1185,2,'Cron: Delete old repository archives has finished',1649977200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1186,2,'Cron: Cleanup hook_task table has finished',1649977200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1187,2,'Cron: Check all repository statistics has finished',1649977200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1188,2,'Cron: Health check all repositories has finished',1649977216);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1189,2,'Cron: Delete old repository archives has finished',1650063600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1190,2,'Cron: Cleanup hook_task table has finished',1650063600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1191,2,'Cron: Clean-up deleted branches has finished',1650063600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1192,2,'Cron: Update migration poster IDs has finished',1650063600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1193,2,'Cron: Synchronize external user data has finished',1650063600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1194,2,'Cron: Check all repository statistics has finished',1650063600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1195,2,'Cron: Health check all repositories has finished',1650063620);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1196,2,'Cron: Clean-up deleted branches has finished',1650150000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1197,2,'Cron: Cleanup hook_task table has finished',1650150000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1198,2,'Cron: Delete old repository archives has finished',1650150000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1199,2,'Cron: Update migration poster IDs has finished',1650150000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1200,2,'Cron: Synchronize external user data has finished',1650150000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1201,2,'Cron: Check all repository statistics has finished',1650150000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1202,2,'Cron: Health check all repositories has finished',1650150015);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1203,2,'Cron: Clean-up deleted branches has finished',1650205294);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1204,2,'Cron: Delete old repository archives has finished',1650205294);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1205,2,'Cron: Update migration poster IDs has finished',1650205294);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1206,2,'Cron: Check all repository statistics has finished',1650205294);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1207,2,'Cron: Delete old repository archives has finished',1650206122);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1208,2,'Cron: Clean-up deleted branches has finished',1650206122);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1209,2,'Cron: Update migration poster IDs has finished',1650206122);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1210,2,'Cron: Check all repository statistics has finished',1650206122);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1211,2,'Cron: Delete old repository archives has finished',1650236400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1212,2,'Cron: Cleanup hook_task table has finished',1650236400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1213,2,'Cron: Clean-up deleted branches has finished',1650236400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1214,2,'Cron: Update migration poster IDs has finished',1650236400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1215,2,'Cron: Synchronize external user data has finished',1650236400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1216,2,'Cron: Check all repository statistics has finished',1650236400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1217,2,'Cron: Health check all repositories has finished',1650236417);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1218,2,'Cron: Clean-up deleted branches has finished',1650322800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1219,2,'Cron: Delete old repository archives has finished',1650322800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1220,2,'Cron: Cleanup hook_task table has finished',1650322800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1221,2,'Cron: Update migration poster IDs has finished',1650322800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1222,2,'Cron: Synchronize external user data has finished',1650322800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1223,2,'Cron: Check all repository statistics has finished',1650322800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1224,2,'Cron: Health check all repositories has finished',1650322816);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1225,2,'Cron: Cleanup hook_task table has finished',1650409200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1226,2,'Cron: Clean-up deleted branches has finished',1650409200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1227,2,'Cron: Delete old repository archives has finished',1650409200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1228,2,'Cron: Update migration poster IDs has finished',1650409200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1229,2,'Cron: Synchronize external user data has finished',1650409200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1230,2,'Cron: Check all repository statistics has finished',1650409200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1231,2,'Cron: Health check all repositories has finished',1650409215);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1232,2,'Cron: Cleanup hook_task table has finished',1650495600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1233,2,'Cron: Clean-up deleted branches has finished',1650495600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1234,2,'Cron: Delete old repository archives has finished',1650495600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1235,2,'Cron: Update migration poster IDs has finished',1650495600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1236,2,'Cron: Synchronize external user data has finished',1650495600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1237,2,'Cron: Check all repository statistics has finished',1650495600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1238,2,'Cron: Health check all repositories has finished',1650495616);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1239,2,'Cron: Update migration poster IDs has finished',1650582000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1240,2,'Cron: Cleanup hook_task table has finished',1650582000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1241,2,'Cron: Clean-up deleted branches has finished',1650582000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1242,2,'Cron: Delete old repository archives has finished',1650582000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1243,2,'Cron: Synchronize external user data has finished',1650582000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1244,2,'Cron: Check all repository statistics has finished',1650582000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1245,2,'Cron: Health check all repositories has finished',1650582024);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1246,2,'Cron: Delete old repository archives has finished',1650668400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1247,2,'Cron: Clean-up deleted branches has finished',1650668400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1248,2,'Cron: Synchronize external user data has finished',1650668400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1249,2,'Cron: Update migration poster IDs has finished',1650668400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1250,2,'Cron: Cleanup hook_task table has finished',1650668400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1251,2,'Cron: Check all repository statistics has finished',1650668400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1252,2,'Cron: Health check all repositories has finished',1650668426);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1253,2,'Cron: Clean-up deleted branches has finished',1650754800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1254,2,'Cron: Delete old repository archives has finished',1650754800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1255,2,'Cron: Update migration poster IDs has finished',1650754800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1256,2,'Cron: Cleanup hook_task table has finished',1650754800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1257,2,'Cron: Synchronize external user data has finished',1650754800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1258,2,'Cron: Check all repository statistics has finished',1650754800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1259,2,'Cron: Health check all repositories has finished',1650754827);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1260,2,'Error in Cron: Update checker: Get "https://dl.gitea.io/gitea/version.json": dial tcp 104.26.1.119:443: connectex: A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond.',1650810985);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1261,2,'Cron: Clean-up deleted branches has finished',1650841200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1262,2,'Cron: Cleanup hook_task table has finished',1650841200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1263,2,'Cron: Delete old repository archives has finished',1650841200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1264,2,'Cron: Update migration poster IDs has finished',1650841200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1265,2,'Cron: Synchronize external user data has finished',1650841200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1266,2,'Cron: Check all repository statistics has finished',1650841200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1267,2,'Cron: Health check all repositories has finished',1650841228);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1268,2,'Cron: Clean-up deleted branches has finished',1650927600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1269,2,'Cron: Cleanup hook_task table has finished',1650927600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1270,2,'Cron: Update migration poster IDs has finished',1650927600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1271,2,'Cron: Delete old repository archives has finished',1650927600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1272,2,'Cron: Synchronize external user data has finished',1650927600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1273,2,'Cron: Check all repository statistics has finished',1650927600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1274,2,'Cron: Health check all repositories has finished',1650927619);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1275,2,'Cron: Clean-up deleted branches has finished',1651014000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1276,2,'Cron: Delete old repository archives has finished',1651014000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1277,2,'Cron: Cleanup hook_task table has finished',1651014000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1278,2,'Cron: Update migration poster IDs has finished',1651014000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1279,2,'Cron: Synchronize external user data has finished',1651014000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1280,2,'Cron: Check all repository statistics has finished',1651014000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1281,2,'Cron: Health check all repositories has finished',1651014028);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1282,2,'Cron: Clean-up deleted branches has finished',1651100400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1283,2,'Cron: Cleanup hook_task table has finished',1651100400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1284,2,'Cron: Update migration poster IDs has finished',1651100400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1285,2,'Cron: Delete old repository archives has finished',1651100400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1286,2,'Cron: Check all repository statistics has finished',1651100400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1287,2,'Cron: Synchronize external user data has finished',1651100400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1288,2,'Cron: Health check all repositories has finished',1651100429);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1289,2,'Cron: Delete old repository archives has finished',1651186800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1290,2,'Cron: Cleanup hook_task table has finished',1651186800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1291,2,'Cron: Clean-up deleted branches has finished',1651186800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1292,2,'Cron: Synchronize external user data has finished',1651186800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1293,2,'Cron: Update migration poster IDs has finished',1651186800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1294,2,'Cron: Check all repository statistics has finished',1651186800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1295,2,'Cron: Health check all repositories has finished',1651186827);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1296,2,'Cron: Clean-up deleted branches has finished',1651273200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1297,2,'Cron: Cleanup hook_task table has finished',1651273200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1298,2,'Cron: Delete old repository archives has finished',1651273200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1299,2,'Cron: Update migration poster IDs has finished',1651273200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1300,2,'Cron: Synchronize external user data has finished',1651273200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1301,2,'Cron: Check all repository statistics has finished',1651273200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1302,2,'Cron: Health check all repositories has finished',1651273228);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1303,2,'Cron: Clean-up deleted branches has finished',1651359600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1304,2,'Cron: Delete old repository archives has finished',1651359600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1305,2,'Cron: Cleanup hook_task table has finished',1651359600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1306,2,'Cron: Update migration poster IDs has finished',1651359600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1307,2,'Cron: Synchronize external user data has finished',1651359600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1308,2,'Cron: Check all repository statistics has finished',1651359600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1309,2,'Cron: Health check all repositories has finished',1651359628);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1310,2,'Error in Cron: Update checker: Get "https://dl.gitea.io/gitea/version.json": dial tcp 172.67.74.188:443: connectex: A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond.',1651415785);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1311,2,'Cron: Clean-up deleted branches has finished',1651446000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1312,2,'Cron: Cleanup hook_task table has finished',1651446000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1313,2,'Cron: Delete old repository archives has finished',1651446000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1314,2,'Cron: Synchronize external user data has finished',1651446000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1315,2,'Cron: Update migration poster IDs has finished',1651446000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1316,2,'Cron: Check all repository statistics has finished',1651446000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1317,2,'Cron: Health check all repositories has finished',1651446028);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1318,2,'Cron: Cleanup hook_task table has finished',1651532400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1319,2,'Cron: Delete old repository archives has finished',1651532400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1320,2,'Cron: Clean-up deleted branches has finished',1651532400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1321,2,'Cron: Update migration poster IDs has finished',1651532400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1322,2,'Cron: Synchronize external user data has finished',1651532400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1323,2,'Cron: Check all repository statistics has finished',1651532400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1324,2,'Cron: Health check all repositories has finished',1651532427);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1325,2,'Cron: Clean-up deleted branches has finished',1651618800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1326,2,'Cron: Update migration poster IDs has finished',1651618800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1327,2,'Cron: Cleanup hook_task table has finished',1651618800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1328,2,'Cron: Delete old repository archives has finished',1651618800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1329,2,'Cron: Check all repository statistics has finished',1651618800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1330,2,'Cron: Synchronize external user data has finished',1651618800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1331,2,'Cron: Health check all repositories has finished',1651618828);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1332,2,'Cron: Cleanup hook_task table has finished',1651705200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1333,2,'Cron: Delete old repository archives has finished',1651705200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1334,2,'Cron: Clean-up deleted branches has finished',1651705200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1335,2,'Cron: Update migration poster IDs has finished',1651705200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1336,2,'Cron: Synchronize external user data has finished',1651705200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1337,2,'Cron: Check all repository statistics has finished',1651705200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1338,2,'Cron: Health check all repositories has finished',1651705226);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1339,2,'Cron: Cleanup hook_task table has finished',1651791600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1340,2,'Cron: Delete old repository archives has finished',1651791600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1341,2,'Cron: Clean-up deleted branches has finished',1651791600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1342,2,'Cron: Update migration poster IDs has finished',1651791600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1343,2,'Cron: Synchronize external user data has finished',1651791600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1344,2,'Cron: Check all repository statistics has finished',1651791600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1345,2,'Cron: Health check all repositories has finished',1651791629);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1346,2,'Cron: Clean-up deleted branches has finished',1651878000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1347,2,'Cron: Delete old repository archives has finished',1651878000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1348,2,'Cron: Update migration poster IDs has finished',1651878000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1349,2,'Cron: Cleanup hook_task table has finished',1651878000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1350,2,'Cron: Synchronize external user data has finished',1651878000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1351,2,'Cron: Check all repository statistics has finished',1651878000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1352,2,'Cron: Health check all repositories has finished',1651878032);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1353,2,'Cron: Clean-up deleted branches has finished',1651964400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1354,2,'Cron: Delete old repository archives has finished',1651964400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1355,2,'Cron: Cleanup hook_task table has finished',1651964400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1356,2,'Cron: Synchronize external user data has finished',1651964400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1357,2,'Cron: Update migration poster IDs has finished',1651964400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1358,2,'Cron: Check all repository statistics has finished',1651964400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1359,2,'Cron: Health check all repositories has finished',1651964428);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1360,2,'Error in Cron: Update checker: Get "https://dl.gitea.io/gitea/version.json": dial tcp 172.67.74.188:443: connectex: A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond.',1652020585);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1361,2,'Cron: Clean-up deleted branches has finished',1652050800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1362,2,'Cron: Cleanup hook_task table has finished',1652050800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1363,2,'Cron: Delete old repository archives has finished',1652050800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1364,2,'Cron: Synchronize external user data has finished',1652050800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1365,2,'Cron: Update migration poster IDs has finished',1652050800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1366,2,'Cron: Check all repository statistics has finished',1652050800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1367,2,'Cron: Health check all repositories has finished',1652050817);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1368,2,'Cron: Clean-up deleted branches has finished',1652137200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1369,2,'Cron: Delete old repository archives has finished',1652137200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1370,2,'Cron: Update migration poster IDs has finished',1652137200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1371,2,'Cron: Cleanup hook_task table has finished',1652137200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1372,2,'Cron: Synchronize external user data has finished',1652137200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1373,2,'Cron: Check all repository statistics has finished',1652137200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1374,2,'Cron: Health check all repositories has finished',1652137228);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1375,2,'Cron: Clean-up deleted branches has finished',1652223600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1376,2,'Cron: Cleanup hook_task table has finished',1652223600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1377,2,'Cron: Delete old repository archives has finished',1652223600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1378,2,'Cron: Update migration poster IDs has finished',1652223600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1379,2,'Cron: Synchronize external user data has finished',1652223600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1380,2,'Cron: Check all repository statistics has finished',1652223600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1381,2,'Cron: Health check all repositories has finished',1652223630);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1382,2,'Cron: Clean-up deleted branches has finished',1652310000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1383,2,'Cron: Cleanup hook_task table has finished',1652310000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1384,2,'Cron: Delete old repository archives has finished',1652310000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1385,2,'Cron: Synchronize external user data has finished',1652310000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1386,2,'Cron: Update migration poster IDs has finished',1652310000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1387,2,'Cron: Check all repository statistics has finished',1652310000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1388,2,'Cron: Health check all repositories has finished',1652310031);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1389,2,'Cron: Cleanup hook_task table has finished',1652396400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1390,2,'Cron: Clean-up deleted branches has finished',1652396400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1391,2,'Cron: Delete old repository archives has finished',1652396400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1392,2,'Cron: Update migration poster IDs has finished',1652396400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1393,2,'Cron: Synchronize external user data has finished',1652396400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1394,2,'Cron: Check all repository statistics has finished',1652396400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1395,2,'Cron: Health check all repositories has finished',1652396430);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1396,2,'Cron: Cleanup hook_task table has finished',1652482800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1397,2,'Cron: Clean-up deleted branches has finished',1652482800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1398,2,'Cron: Delete old repository archives has finished',1652482800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1399,2,'Cron: Update migration poster IDs has finished',1652482800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1400,2,'Cron: Synchronize external user data has finished',1652482800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1401,2,'Cron: Check all repository statistics has finished',1652482800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1402,2,'Cron: Health check all repositories has finished',1652482830);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1403,2,'Cron: Clean-up deleted branches has finished',1652524691);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1404,2,'Cron: Delete old repository archives has finished',1652524691);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1405,2,'Cron: Update migration poster IDs has finished',1652524691);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1406,2,'Cron: Check all repository statistics has finished',1652524691);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1407,2,'Cron: Delete old repository archives has finished',1652524765);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1408,2,'Cron: Clean-up deleted branches has finished',1652524765);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1409,2,'Cron: Update migration poster IDs has finished',1652524765);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1410,2,'Cron: Check all repository statistics has finished',1652524766);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1411,2,'Cron: Clean-up deleted branches has finished',1652524841);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1412,2,'Cron: Delete old repository archives has finished',1652524841);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1413,2,'Cron: Update migration poster IDs has finished',1652524841);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1414,2,'Cron: Check all repository statistics has finished',1652524841);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1415,2,'Cron: Delete old repository archives has finished',1652525058);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1416,2,'Cron: Clean-up deleted branches has finished',1652525058);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1417,2,'Cron: Update migration poster IDs has finished',1652525058);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1418,2,'Cron: Check all repository statistics has finished',1652525058);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1419,2,'Cron: Clean-up deleted branches has finished',1652525164);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1420,2,'Cron: Delete old repository archives has finished',1652525164);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1421,2,'Cron: Update migration poster IDs has finished',1652525164);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1422,2,'Cron: Check all repository statistics has finished',1652525165);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1423,2,'Cron: Delete old repository archives has finished',1652525701);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1424,2,'Cron: Clean-up deleted branches has finished',1652525701);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1425,2,'Cron: Update migration poster IDs has finished',1652525701);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1426,2,'Cron: Check all repository statistics has finished',1652525702);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1427,2,'Cron: Delete old repository archives has finished',1652526302);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1428,2,'Cron: Clean-up deleted branches has finished',1652526302);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1429,2,'Cron: Update migration poster IDs has finished',1652526302);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1430,2,'Cron: Check all repository statistics has finished',1652526302);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1431,2,'Cron: Clean-up deleted branches has finished',1652526382);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1432,2,'Cron: Delete old repository archives has finished',1652526382);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1433,2,'Cron: Update migration poster IDs has finished',1652526382);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1434,2,'Cron: Check all repository statistics has finished',1652526383);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1435,2,'Cron: Cleanup hook_task table has finished',1652569200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1436,2,'Cron: Delete old repository archives has finished',1652569200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1437,2,'Cron: Clean-up deleted branches has finished',1652569200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1438,2,'Cron: Update migration poster IDs has finished',1652569200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1439,2,'Cron: Synchronize external user data has finished',1652569200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1440,2,'Cron: Check all repository statistics has finished',1652569200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1441,2,'Cron: Health check all repositories has finished',1652569227);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1442,2,'Cron: Clean-up deleted branches has finished',1652603464);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1443,2,'Cron: Delete old repository archives has finished',1652603465);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1444,2,'Cron: Update migration poster IDs has finished',1652603465);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1445,2,'Cron: Check all repository statistics has finished',1652603465);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1446,2,'Cron: Cleanup hook_task table has finished',1652655600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1447,2,'Cron: Clean-up deleted branches has finished',1652655600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1448,2,'Cron: Delete old repository archives has finished',1652655600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1449,2,'Cron: Update migration poster IDs has finished',1652655600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1450,2,'Cron: Synchronize external user data has finished',1652655600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1451,2,'Cron: Check all repository statistics has finished',1652655600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1452,2,'Cron: Health check all repositories has finished',1652655633);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1453,2,'Cron: Cleanup hook_task table has finished',1652742000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1454,2,'Cron: Delete old repository archives has finished',1652742000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1455,2,'Cron: Synchronize external user data has finished',1652742000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1456,2,'Cron: Clean-up deleted branches has finished',1652742000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1457,2,'Cron: Update migration poster IDs has finished',1652742000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1458,2,'Cron: Check all repository statistics has finished',1652742000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1459,2,'Cron: Health check all repositories has finished',1652742018);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1460,2,'Cron: Cleanup hook_task table has finished',1652828400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1461,2,'Cron: Update migration poster IDs has finished',1652828400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1462,2,'Cron: Clean-up deleted branches has finished',1652828400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1463,2,'Cron: Delete old repository archives has finished',1652828400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1464,2,'Cron: Synchronize external user data has finished',1652828400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1465,2,'Cron: Check all repository statistics has finished',1652828400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1466,2,'Cron: Health check all repositories has finished',1652828418);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1467,2,'Cron: Cleanup hook_task table has finished',1652914800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1468,2,'Cron: Delete old repository archives has finished',1652914800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1469,2,'Cron: Clean-up deleted branches has finished',1652914800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1470,2,'Cron: Synchronize external user data has finished',1652914800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1471,2,'Cron: Update migration poster IDs has finished',1652914800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1472,2,'Cron: Check all repository statistics has finished',1652914800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1473,2,'Cron: Health check all repositories has finished',1652914818);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1474,2,'Cron: Clean-up deleted branches has finished',1653001200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1475,2,'Cron: Delete old repository archives has finished',1653001200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1476,2,'Cron: Cleanup hook_task table has finished',1653001200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1477,2,'Cron: Update migration poster IDs has finished',1653001200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1478,2,'Cron: Synchronize external user data has finished',1653001200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1479,2,'Cron: Check all repository statistics has finished',1653001200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1480,2,'Cron: Health check all repositories has finished',1653001219);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1481,2,'Cron: Delete old repository archives has finished',1653008421);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1482,2,'Cron: Clean-up deleted branches has finished',1653008421);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1483,2,'Cron: Update migration poster IDs has finished',1653008421);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1484,2,'Cron: Check all repository statistics has finished',1653008421);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1485,2,'Cron: Cleanup hook_task table has finished',1653087600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1486,2,'Cron: Delete old repository archives has finished',1653087600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1487,2,'Cron: Clean-up deleted branches has finished',1653087600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1488,2,'Cron: Synchronize external user data has finished',1653087600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1489,2,'Cron: Update migration poster IDs has finished',1653087600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1490,2,'Cron: Check all repository statistics has finished',1653087600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1491,2,'Cron: Health check all repositories has finished',1653087619);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1492,2,'Cron: Clean-up deleted branches has finished',1653174000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1493,2,'Cron: Cleanup hook_task table has finished',1653174000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1494,2,'Cron: Delete old repository archives has finished',1653174000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1495,2,'Cron: Synchronize external user data has finished',1653174000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1496,2,'Cron: Update migration poster IDs has finished',1653174000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1497,2,'Cron: Check all repository statistics has finished',1653174000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1498,2,'Cron: Health check all repositories has finished',1653174018);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1499,2,'Cron: Clean-up deleted branches has finished',1653260400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1500,2,'Cron: Cleanup hook_task table has finished',1653260400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1501,2,'Cron: Delete old repository archives has finished',1653260400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1502,2,'Cron: Update migration poster IDs has finished',1653260400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1503,2,'Cron: Synchronize external user data has finished',1653260400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1504,2,'Cron: Check all repository statistics has finished',1653260400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1505,2,'Cron: Health check all repositories has finished',1653260418);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1506,2,'Cron: Delete old repository archives has finished',1653316128);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1507,2,'Cron: Clean-up deleted branches has finished',1653316128);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1508,2,'Cron: Update migration poster IDs has finished',1653316128);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1509,2,'Cron: Check all repository statistics has finished',1653316128);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1510,2,'Cron: Clean-up deleted branches has finished',1653346800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1511,2,'Cron: Cleanup hook_task table has finished',1653346800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1512,2,'Cron: Delete old repository archives has finished',1653346800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1513,2,'Cron: Update migration poster IDs has finished',1653346800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1514,2,'Cron: Synchronize external user data has finished',1653346800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1515,2,'Cron: Check all repository statistics has finished',1653346800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1516,2,'Cron: Health check all repositories has finished',1653346818);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1517,2,'Cron: Delete old repository archives has finished',1653433200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1518,2,'Cron: Cleanup hook_task table has finished',1653433200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1519,2,'Cron: Clean-up deleted branches has finished',1653433200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1520,2,'Cron: Synchronize external user data has finished',1653433200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1521,2,'Cron: Update migration poster IDs has finished',1653433200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1522,2,'Cron: Check all repository statistics has finished',1653433200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1523,2,'Cron: Health check all repositories has finished',1653433215);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1524,2,'Cron: Clean-up deleted branches has finished',1653519600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1525,2,'Cron: Update migration poster IDs has finished',1653519600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1526,2,'Cron: Cleanup hook_task table has finished',1653519600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1527,2,'Cron: Delete old repository archives has finished',1653519600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1528,2,'Cron: Synchronize external user data has finished',1653519600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1529,2,'Cron: Check all repository statistics has finished',1653519600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1530,2,'Cron: Health check all repositories has finished',1653519615);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1531,2,'Cron: Delete old repository archives has finished',1653606000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1532,2,'Cron: Cleanup hook_task table has finished',1653606000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1533,2,'Cron: Clean-up deleted branches has finished',1653606000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1534,2,'Cron: Synchronize external user data has finished',1653606000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1535,2,'Cron: Update migration poster IDs has finished',1653606000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1536,2,'Cron: Check all repository statistics has finished',1653606000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1537,2,'Cron: Health check all repositories has finished',1653606015);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1538,2,'Cron: Clean-up deleted branches has finished',1653613220);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1539,2,'Cron: Delete old repository archives has finished',1653613220);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1540,2,'Cron: Update migration poster IDs has finished',1653613220);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1541,2,'Cron: Check all repository statistics has finished',1653613221);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1542,2,'Cron: Clean-up deleted branches has finished',1653692400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1543,2,'Cron: Cleanup hook_task table has finished',1653692400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1544,2,'Cron: Update migration poster IDs has finished',1653692400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1545,2,'Cron: Delete old repository archives has finished',1653692400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1546,2,'Cron: Synchronize external user data has finished',1653692400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1547,2,'Cron: Check all repository statistics has finished',1653692400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1548,2,'Cron: Health check all repositories has finished',1653692416);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1549,2,'Cron: Clean-up deleted branches has finished',1653778800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1550,2,'Cron: Delete old repository archives has finished',1653778800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1551,2,'Cron: Cleanup hook_task table has finished',1653778800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1552,2,'Cron: Update migration poster IDs has finished',1653778800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1553,2,'Cron: Synchronize external user data has finished',1653778800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1554,2,'Cron: Check all repository statistics has finished',1653778800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1555,2,'Cron: Health check all repositories has finished',1653778815);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1556,2,'Cron: Cleanup hook_task table has finished',1653865200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1557,2,'Cron: Clean-up deleted branches has finished',1653865200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1558,2,'Cron: Update migration poster IDs has finished',1653865200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1559,2,'Cron: Delete old repository archives has finished',1653865200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1560,2,'Cron: Synchronize external user data has finished',1653865200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1561,2,'Cron: Check all repository statistics has finished',1653865200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1562,2,'Cron: Health check all repositories has finished',1653865215);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1563,2,'Cron: Cleanup hook_task table has finished',1653951600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1564,2,'Cron: Clean-up deleted branches has finished',1653951600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1565,2,'Cron: Delete old repository archives has finished',1653951600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1566,2,'Cron: Synchronize external user data has finished',1653951600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1567,2,'Cron: Update migration poster IDs has finished',1653951600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1568,2,'Cron: Check all repository statistics has finished',1653951600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1569,2,'Cron: Health check all repositories has finished',1653951615);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1570,2,'Cron: Clean-up deleted branches has finished',1654038000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1571,2,'Cron: Delete old repository archives has finished',1654038000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1572,2,'Cron: Cleanup hook_task table has finished',1654038000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1573,2,'Cron: Synchronize external user data has finished',1654038000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1574,2,'Cron: Update migration poster IDs has finished',1654038000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1575,2,'Cron: Check all repository statistics has finished',1654038000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1576,2,'Cron: Health check all repositories has finished',1654038015);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1577,2,'Cron: Cleanup hook_task table has finished',1654124400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1578,2,'Cron: Delete old repository archives has finished',1654124400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1579,2,'Cron: Clean-up deleted branches has finished',1654124400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1580,2,'Cron: Update migration poster IDs has finished',1654124400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1581,2,'Cron: Synchronize external user data has finished',1654124400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1582,2,'Cron: Check all repository statistics has finished',1654124400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1583,2,'Cron: Health check all repositories has finished',1654124415);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1584,2,'Cron: Cleanup hook_task table has finished',1654210800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1585,2,'Cron: Clean-up deleted branches has finished',1654210800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1586,2,'Cron: Delete old repository archives has finished',1654210800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1587,2,'Cron: Synchronize external user data has finished',1654210800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1588,2,'Cron: Update migration poster IDs has finished',1654210800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1589,2,'Cron: Check all repository statistics has finished',1654210800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1590,2,'Cron: Health check all repositories has finished',1654210816);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1591,2,'Cron: Delete old repository archives has finished',1654218015);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1592,2,'Cron: Clean-up deleted branches has finished',1654218015);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1593,2,'Cron: Update migration poster IDs has finished',1654218015);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1594,2,'Cron: Check all repository statistics has finished',1654218015);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1595,2,'Cron: Clean-up deleted branches has finished',1654297200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1596,2,'Cron: Delete old repository archives has finished',1654297200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1597,2,'Cron: Cleanup hook_task table has finished',1654297200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1598,2,'Cron: Update migration poster IDs has finished',1654297200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1599,2,'Cron: Synchronize external user data has finished',1654297200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1600,2,'Cron: Check all repository statistics has finished',1654297200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1601,2,'Cron: Health check all repositories has finished',1654297215);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1602,2,'Cron: Clean-up deleted branches has finished',1654383600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1603,2,'Cron: Delete old repository archives has finished',1654383600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1604,2,'Cron: Cleanup hook_task table has finished',1654383600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1605,2,'Cron: Update migration poster IDs has finished',1654383600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1606,2,'Cron: Synchronize external user data has finished',1654383600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1607,2,'Cron: Check all repository statistics has finished',1654383600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1608,2,'Cron: Health check all repositories has finished',1654383615);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1609,2,'Cron: Clean-up deleted branches has finished',1654470000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1610,2,'Cron: Cleanup hook_task table has finished',1654470000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1611,2,'Cron: Delete old repository archives has finished',1654470000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1612,2,'Cron: Update migration poster IDs has finished',1654470000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1613,2,'Cron: Synchronize external user data has finished',1654470000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1614,2,'Cron: Check all repository statistics has finished',1654470000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1615,2,'Cron: Health check all repositories has finished',1654470015);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1616,2,'Cron: Clean-up deleted branches has finished',1654556400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1617,2,'Cron: Cleanup hook_task table has finished',1654556400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1618,2,'Cron: Delete old repository archives has finished',1654556400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1619,2,'Cron: Update migration poster IDs has finished',1654556400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1620,2,'Cron: Synchronize external user data has finished',1654556400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1621,2,'Cron: Check all repository statistics has finished',1654556400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1622,2,'Cron: Health check all repositories has finished',1654556415);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1623,2,'Cron: Clean-up deleted branches has finished',1654642800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1624,2,'Cron: Delete old repository archives has finished',1654642800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1625,2,'Cron: Cleanup hook_task table has finished',1654642800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1626,2,'Cron: Synchronize external user data has finished',1654642800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1627,2,'Cron: Update migration poster IDs has finished',1654642800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1628,2,'Cron: Check all repository statistics has finished',1654642800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1629,2,'Cron: Health check all repositories has finished',1654642816);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1630,2,'Cron: Clean-up deleted branches has finished',1654729200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1631,2,'Cron: Cleanup hook_task table has finished',1654729200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1632,2,'Cron: Delete old repository archives has finished',1654729200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1633,2,'Cron: Update migration poster IDs has finished',1654729200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1634,2,'Cron: Synchronize external user data has finished',1654729200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1635,2,'Cron: Check all repository statistics has finished',1654729200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1636,2,'Cron: Health check all repositories has finished',1654729215);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1637,2,'Cron: Cleanup hook_task table has finished',1654815600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1638,2,'Cron: Clean-up deleted branches has finished',1654815600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1639,2,'Cron: Delete old repository archives has finished',1654815600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1640,2,'Cron: Update migration poster IDs has finished',1654815600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1641,2,'Cron: Synchronize external user data has finished',1654815600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1642,2,'Cron: Check all repository statistics has finished',1654815600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1643,2,'Cron: Health check all repositories has finished',1654815614);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1644,2,'Cron: Delete old repository archives has finished',1654822814);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1645,2,'Cron: Clean-up deleted branches has finished',1654822814);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1646,2,'Cron: Update migration poster IDs has finished',1654822814);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1647,2,'Cron: Check all repository statistics has finished',1654822814);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1648,2,'Cron: Cleanup hook_task table has finished',1654902000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1649,2,'Cron: Clean-up deleted branches has finished',1654902000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1650,2,'Cron: Delete old repository archives has finished',1654902000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1651,2,'Cron: Update migration poster IDs has finished',1654902000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1652,2,'Cron: Synchronize external user data has finished',1654902000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1653,2,'Cron: Check all repository statistics has finished',1654902000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1654,2,'Cron: Health check all repositories has finished',1654902016);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1655,2,'Cron: Clean-up deleted branches has finished',1654988400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1656,2,'Cron: Cleanup hook_task table has finished',1654988400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1657,2,'Cron: Delete old repository archives has finished',1654988400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1658,2,'Cron: Synchronize external user data has finished',1654988400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1659,2,'Cron: Update migration poster IDs has finished',1654988400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1660,2,'Cron: Check all repository statistics has finished',1654988400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1661,2,'Cron: Health check all repositories has finished',1654988414);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1662,2,'Cron: Clean-up deleted branches has finished',1655074800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1663,2,'Cron: Cleanup hook_task table has finished',1655074800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1664,2,'Cron: Update migration poster IDs has finished',1655074800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1665,2,'Cron: Delete old repository archives has finished',1655074800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1666,2,'Cron: Synchronize external user data has finished',1655074800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1667,2,'Cron: Check all repository statistics has finished',1655074800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1668,2,'Cron: Health check all repositories has finished',1655074815);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1669,2,'Cron: Delete old repository archives has finished',1655161200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1670,2,'Cron: Update migration poster IDs has finished',1655161200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1671,2,'Cron: Clean-up deleted branches has finished',1655161200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1672,2,'Cron: Cleanup hook_task table has finished',1655161200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1673,2,'Cron: Synchronize external user data has finished',1655161200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1674,2,'Cron: Check all repository statistics has finished',1655161200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1675,2,'Cron: Health check all repositories has finished',1655161215);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1676,2,'Cron: Clean-up deleted branches has finished',1655247600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1677,2,'Cron: Update migration poster IDs has finished',1655247600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1678,2,'Cron: Cleanup hook_task table has finished',1655247600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1679,2,'Cron: Delete old repository archives has finished',1655247600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1680,2,'Cron: Synchronize external user data has finished',1655247600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1681,2,'Cron: Check all repository statistics has finished',1655247600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1682,2,'Cron: Health check all repositories has finished',1655247614);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1683,2,'Cron: Cleanup hook_task table has finished',1655334000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1684,2,'Cron: Clean-up deleted branches has finished',1655334000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1685,2,'Cron: Delete old repository archives has finished',1655334000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1686,2,'Cron: Update migration poster IDs has finished',1655334000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1687,2,'Cron: Synchronize external user data has finished',1655334000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1688,2,'Cron: Check all repository statistics has finished',1655334000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1689,2,'Cron: Health check all repositories has finished',1655334015);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1690,2,'Cron: Update migration poster IDs has finished',1655420400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1691,2,'Cron: Delete old repository archives has finished',1655420400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1692,2,'Cron: Clean-up deleted branches has finished',1655420400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1693,2,'Cron: Cleanup hook_task table has finished',1655420400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1694,2,'Cron: Synchronize external user data has finished',1655420400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1695,2,'Cron: Check all repository statistics has finished',1655420400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1696,2,'Cron: Health check all repositories has finished',1655420415);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1697,2,'Cron: Delete old repository archives has finished',1655427615);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1698,2,'Cron: Clean-up deleted branches has finished',1655427615);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1699,2,'Cron: Update migration poster IDs has finished',1655427615);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1700,2,'Cron: Check all repository statistics has finished',1655427615);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1701,2,'Cron: Clean-up deleted branches has finished',1655506800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1702,2,'Cron: Cleanup hook_task table has finished',1655506800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1703,2,'Cron: Delete old repository archives has finished',1655506800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1704,2,'Cron: Update migration poster IDs has finished',1655506800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1705,2,'Cron: Synchronize external user data has finished',1655506800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1706,2,'Cron: Check all repository statistics has finished',1655506800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1707,2,'Cron: Health check all repositories has finished',1655506816);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1708,2,'Cron: Delete old repository archives has finished',1655593200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1709,2,'Cron: Cleanup hook_task table has finished',1655593200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1710,2,'Cron: Clean-up deleted branches has finished',1655593200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1711,2,'Cron: Synchronize external user data has finished',1655593200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1712,2,'Cron: Update migration poster IDs has finished',1655593200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1713,2,'Cron: Check all repository statistics has finished',1655593200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1714,2,'Cron: Health check all repositories has finished',1655593215);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1715,2,'Cron: Delete old repository archives has finished',1655646110);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1716,2,'Cron: Update migration poster IDs has finished',1655646110);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1717,2,'Cron: Clean-up deleted branches has finished',1655646110);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1718,2,'Cron: Check all repository statistics has finished',1655646110);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1719,2,'Cron: Clean-up deleted branches has finished',1655679600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1720,2,'Cron: Delete old repository archives has finished',1655679600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1721,2,'Cron: Cleanup hook_task table has finished',1655679600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1722,2,'Cron: Update migration poster IDs has finished',1655679600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1723,2,'Cron: Synchronize external user data has finished',1655679600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1724,2,'Cron: Check all repository statistics has finished',1655679600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1725,2,'Cron: Health check all repositories has finished',1655679616);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1726,2,'Cron: Update migration poster IDs has finished',1655766000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1727,2,'Cron: Clean-up deleted branches has finished',1655766000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1728,2,'Cron: Cleanup hook_task table has finished',1655766000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1729,2,'Cron: Delete old repository archives has finished',1655766000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1730,2,'Cron: Synchronize external user data has finished',1655766000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1731,2,'Cron: Check all repository statistics has finished',1655766000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1732,2,'Cron: Health check all repositories has finished',1655766015);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1733,2,'Cron: Cleanup hook_task table has finished',1655852400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1734,2,'Cron: Delete old repository archives has finished',1655852400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1735,2,'Cron: Clean-up deleted branches has finished',1655852400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1736,2,'Cron: Update migration poster IDs has finished',1655852400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1737,2,'Cron: Synchronize external user data has finished',1655852400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1738,2,'Cron: Check all repository statistics has finished',1655852400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1739,2,'Cron: Health check all repositories has finished',1655852416);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1740,2,'Cron: Cleanup hook_task table has finished',1655938800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1741,2,'Cron: Delete old repository archives has finished',1655938800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1742,2,'Cron: Clean-up deleted branches has finished',1655938800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1743,2,'Cron: Update migration poster IDs has finished',1655938800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1744,2,'Cron: Synchronize external user data has finished',1655938800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1745,2,'Cron: Check all repository statistics has finished',1655938800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1746,2,'Cron: Health check all repositories has finished',1655938815);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1747,2,'Cron: Clean-up deleted branches has finished',1656025200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1748,2,'Cron: Cleanup hook_task table has finished',1656025200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1749,2,'Cron: Delete old repository archives has finished',1656025200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1750,2,'Cron: Synchronize external user data has finished',1656025200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1751,2,'Cron: Update migration poster IDs has finished',1656025200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1752,2,'Cron: Check all repository statistics has finished',1656025200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1753,2,'Cron: Health check all repositories has finished',1656025216);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1754,2,'Cron: Delete old repository archives has finished',1656032416);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1755,2,'Cron: Clean-up deleted branches has finished',1656032416);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1756,2,'Cron: Update migration poster IDs has finished',1656032416);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1757,2,'Cron: Check all repository statistics has finished',1656032416);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1758,2,'Cron: Cleanup hook_task table has finished',1656111600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1759,2,'Cron: Delete old repository archives has finished',1656111600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1760,2,'Cron: Clean-up deleted branches has finished',1656111600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1761,2,'Cron: Update migration poster IDs has finished',1656111600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1762,2,'Cron: Synchronize external user data has finished',1656111600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1763,2,'Cron: Check all repository statistics has finished',1656111600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1764,2,'Cron: Health check all repositories has finished',1656111616);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1765,2,'Cron: Clean-up deleted branches has finished',1656198000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1766,2,'Cron: Delete old repository archives has finished',1656198000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1767,2,'Cron: Synchronize external user data has finished',1656198000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1768,2,'Cron: Cleanup hook_task table has finished',1656198000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1769,2,'Cron: Update migration poster IDs has finished',1656198000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1770,2,'Cron: Check all repository statistics has finished',1656198000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1771,2,'Cron: Health check all repositories has finished',1656198016);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1772,2,'Cron: Cleanup hook_task table has finished',1656284400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1773,2,'Cron: Delete old repository archives has finished',1656284400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1774,2,'Cron: Clean-up deleted branches has finished',1656284400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1775,2,'Cron: Synchronize external user data has finished',1656284400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1776,2,'Cron: Update migration poster IDs has finished',1656284400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1777,2,'Cron: Check all repository statistics has finished',1656284400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1778,2,'Cron: Health check all repositories has finished',1656284416);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1779,2,'Cron: Delete old repository archives has finished',1656370800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1780,2,'Cron: Clean-up deleted branches has finished',1656370800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1781,2,'Cron: Cleanup hook_task table has finished',1656370800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1782,2,'Cron: Update migration poster IDs has finished',1656370800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1783,2,'Cron: Synchronize external user data has finished',1656370800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1784,2,'Cron: Check all repository statistics has finished',1656370800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1785,2,'Cron: Health check all repositories has finished',1656370817);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1786,2,'Cron: Cleanup hook_task table has finished',1656457200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1787,2,'Cron: Delete old repository archives has finished',1656457200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1788,2,'Cron: Clean-up deleted branches has finished',1656457200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1789,2,'Cron: Update migration poster IDs has finished',1656457200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1790,2,'Cron: Synchronize external user data has finished',1656457200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1791,2,'Cron: Check all repository statistics has finished',1656457200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1792,2,'Cron: Health check all repositories has finished',1656457220);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1793,2,'Cron: Cleanup hook_task table has finished',1656543600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1794,2,'Cron: Clean-up deleted branches has finished',1656543600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1795,2,'Cron: Delete old repository archives has finished',1656543600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1796,2,'Cron: Synchronize external user data has finished',1656543600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1797,2,'Cron: Update migration poster IDs has finished',1656543600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1798,2,'Cron: Check all repository statistics has finished',1656543600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1799,2,'Cron: Health check all repositories has finished',1656543620);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1800,2,'Cron: Clean-up deleted branches has finished',1656630000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1801,2,'Cron: Cleanup hook_task table has finished',1656630000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1802,2,'Cron: Delete old repository archives has finished',1656630000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1803,2,'Cron: Update migration poster IDs has finished',1656630000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1804,2,'Cron: Synchronize external user data has finished',1656630000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1805,2,'Cron: Check all repository statistics has finished',1656630000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1806,2,'Cron: Health check all repositories has finished',1656630020);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1807,2,'Cron: Clean-up deleted branches has finished',1656637217);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1808,2,'Cron: Delete old repository archives has finished',1656637217);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1809,2,'Cron: Update migration poster IDs has finished',1656637217);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1810,2,'Cron: Check all repository statistics has finished',1656637217);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1811,2,'Cron: Cleanup hook_task table has finished',1656716400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1812,2,'Cron: Clean-up deleted branches has finished',1656716400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1813,2,'Cron: Update migration poster IDs has finished',1656716400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1814,2,'Cron: Delete old repository archives has finished',1656716400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1815,2,'Cron: Synchronize external user data has finished',1656716400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1816,2,'Cron: Check all repository statistics has finished',1656716400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1817,2,'Cron: Health check all repositories has finished',1656716420);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1818,2,'Cron: Cleanup hook_task table has finished',1656802800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1819,2,'Cron: Delete old repository archives has finished',1656802800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1820,2,'Cron: Clean-up deleted branches has finished',1656802800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1821,2,'Cron: Synchronize external user data has finished',1656802800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1822,2,'Cron: Update migration poster IDs has finished',1656802800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1823,2,'Cron: Check all repository statistics has finished',1656802800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1824,2,'Cron: Health check all repositories has finished',1656802819);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1825,2,'Cron: Clean-up deleted branches has finished',1656889200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1826,2,'Cron: Delete old repository archives has finished',1656889200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1827,2,'Cron: Cleanup hook_task table has finished',1656889200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1828,2,'Cron: Synchronize external user data has finished',1656889200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1829,2,'Cron: Check all repository statistics has finished',1656889200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1830,2,'Cron: Update migration poster IDs has finished',1656889200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1831,2,'Cron: Health check all repositories has finished',1656889220);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1832,2,'Cron: Clean-up deleted branches has finished',1656975600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1833,2,'Cron: Cleanup hook_task table has finished',1656975600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1834,2,'Cron: Delete old repository archives has finished',1656975600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1835,2,'Cron: Synchronize external user data has finished',1656975600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1836,2,'Cron: Update migration poster IDs has finished',1656975600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1837,2,'Cron: Check all repository statistics has finished',1656975600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1838,2,'Cron: Health check all repositories has finished',1656975621);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1839,2,'Cron: Clean-up deleted branches has finished',1657062000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1840,2,'Cron: Cleanup hook_task table has finished',1657062000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1841,2,'Cron: Delete old repository archives has finished',1657062000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1842,2,'Cron: Update migration poster IDs has finished',1657062000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1843,2,'Cron: Synchronize external user data has finished',1657062000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1844,2,'Cron: Check all repository statistics has finished',1657062000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1845,2,'Cron: Health check all repositories has finished',1657062020);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1846,2,'Cron: Cleanup hook_task table has finished',1657148400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1847,2,'Cron: Delete old repository archives has finished',1657148400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1848,2,'Cron: Clean-up deleted branches has finished',1657148400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1849,2,'Cron: Update migration poster IDs has finished',1657148400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1850,2,'Cron: Synchronize external user data has finished',1657148400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1851,2,'Cron: Check all repository statistics has finished',1657148400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1852,2,'Cron: Health check all repositories has finished',1657148421);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1853,2,'Cron: Cleanup hook_task table has finished',1657234800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1854,2,'Cron: Delete old repository archives has finished',1657234800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1855,2,'Cron: Clean-up deleted branches has finished',1657234800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1856,2,'Cron: Update migration poster IDs has finished',1657234800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1857,2,'Cron: Synchronize external user data has finished',1657234800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1858,2,'Cron: Check all repository statistics has finished',1657234800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1859,2,'Cron: Health check all repositories has finished',1657234820);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1860,2,'Cron: Delete old repository archives has finished',1657242018);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1861,2,'Cron: Clean-up deleted branches has finished',1657242018);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1862,2,'Cron: Update migration poster IDs has finished',1657242018);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1863,2,'Cron: Check all repository statistics has finished',1657242018);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1864,2,'Cron: Delete old repository archives has finished',1657321200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1865,2,'Cron: Clean-up deleted branches has finished',1657321200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1866,2,'Cron: Cleanup hook_task table has finished',1657321200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1867,2,'Cron: Update migration poster IDs has finished',1657321200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1868,2,'Cron: Synchronize external user data has finished',1657321200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1869,2,'Cron: Check all repository statistics has finished',1657321200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1870,2,'Cron: Health check all repositories has finished',1657321220);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1871,2,'Cron: Clean-up deleted branches has finished',1657407600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1872,2,'Cron: Delete old repository archives has finished',1657407600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1873,2,'Cron: Cleanup hook_task table has finished',1657407600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1874,2,'Cron: Synchronize external user data has finished',1657407600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1875,2,'Cron: Update migration poster IDs has finished',1657407600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1876,2,'Cron: Check all repository statistics has finished',1657407600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1877,2,'Cron: Health check all repositories has finished',1657407620);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1878,2,'Cron: Cleanup hook_task table has finished',1657494000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1879,2,'Cron: Update migration poster IDs has finished',1657494000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1880,2,'Cron: Clean-up deleted branches has finished',1657494000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1881,2,'Cron: Delete old repository archives has finished',1657494000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1882,2,'Cron: Synchronize external user data has finished',1657494000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1883,2,'Cron: Check all repository statistics has finished',1657494000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1884,2,'Cron: Health check all repositories has finished',1657494020);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1885,2,'Cron: Cleanup hook_task table has finished',1657580400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1886,2,'Cron: Clean-up deleted branches has finished',1657580400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1887,2,'Cron: Delete old repository archives has finished',1657580400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1888,2,'Cron: Synchronize external user data has finished',1657580400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1889,2,'Cron: Update migration poster IDs has finished',1657580400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1890,2,'Cron: Check all repository statistics has finished',1657580400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1891,2,'Cron: Health check all repositories has finished',1657580420);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1892,2,'Cron: Cleanup hook_task table has finished',1657666800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1893,2,'Cron: Delete old repository archives has finished',1657666800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1894,2,'Cron: Clean-up deleted branches has finished',1657666800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1895,2,'Cron: Update migration poster IDs has finished',1657666800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1896,2,'Cron: Synchronize external user data has finished',1657666800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1897,2,'Cron: Check all repository statistics has finished',1657666800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1898,2,'Cron: Health check all repositories has finished',1657666820);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1899,2,'Cron: Clean-up deleted branches has finished',1657753200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1900,2,'Cron: Cleanup hook_task table has finished',1657753200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1901,2,'Cron: Delete old repository archives has finished',1657753200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1902,2,'Cron: Synchronize external user data has finished',1657753200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1903,2,'Cron: Update migration poster IDs has finished',1657753200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1904,2,'Cron: Check all repository statistics has finished',1657753200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1905,2,'Cron: Health check all repositories has finished',1657753220);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1906,2,'Cron: Clean-up deleted branches has finished',1657839600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1907,2,'Cron: Delete old repository archives has finished',1657839600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1908,2,'Cron: Cleanup hook_task table has finished',1657839600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1909,2,'Cron: Update migration poster IDs has finished',1657839600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1910,2,'Cron: Synchronize external user data has finished',1657839600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1911,2,'Cron: Check all repository statistics has finished',1657839600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1912,2,'Cron: Health check all repositories has finished',1657839621);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1913,2,'Cron: Delete old repository archives has finished',1657846827);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1914,2,'Cron: Clean-up deleted branches has finished',1657846827);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1915,2,'Cron: Update migration poster IDs has finished',1657846827);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1916,2,'Cron: Check all repository statistics has finished',1657846827);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1917,2,'Cron: Cleanup hook_task table has finished',1657926000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1918,2,'Cron: Delete old repository archives has finished',1657926000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1919,2,'Cron: Update migration poster IDs has finished',1657926000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1920,2,'Cron: Synchronize external user data has finished',1657926000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1921,2,'Cron: Clean-up deleted branches has finished',1657926000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1922,2,'Cron: Check all repository statistics has finished',1657926000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1923,2,'Cron: Health check all repositories has finished',1657926021);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1924,2,'Cron: Delete old repository archives has finished',1658012400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1925,2,'Cron: Clean-up deleted branches has finished',1658012400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1926,2,'Cron: Update migration poster IDs has finished',1658012400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1927,2,'Cron: Cleanup hook_task table has finished',1658012400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1928,2,'Cron: Synchronize external user data has finished',1658012400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1929,2,'Cron: Check all repository statistics has finished',1658012400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1930,2,'Cron: Health check all repositories has finished',1658012420);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1931,2,'Cron: Delete old repository archives has finished',1658092335);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1932,2,'Cron: Clean-up deleted branches has finished',1658092335);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1933,2,'Cron: Update migration poster IDs has finished',1658092335);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1934,2,'Cron: Check all repository statistics has finished',1658092335);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1935,2,'Cron: Clean-up deleted branches has finished',1658098800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1936,2,'Cron: Cleanup hook_task table has finished',1658098800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1937,2,'Cron: Delete old repository archives has finished',1658098800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1938,2,'Cron: Update migration poster IDs has finished',1658098800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1939,2,'Cron: Synchronize external user data has finished',1658098800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1940,2,'Cron: Check all repository statistics has finished',1658098800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1941,2,'Cron: Health check all repositories has finished',1658098821);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1942,2,'Cron: Clean-up deleted branches has finished',1658185200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1943,2,'Cron: Cleanup hook_task table has finished',1658185200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1944,2,'Cron: Synchronize external user data has finished',1658185200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1945,2,'Cron: Delete old repository archives has finished',1658185200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1946,2,'Cron: Update migration poster IDs has finished',1658185200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1947,2,'Cron: Check all repository statistics has finished',1658185200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1948,2,'Cron: Health check all repositories has finished',1658185220);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1949,2,'Cron: Clean-up deleted branches has finished',1658271600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1950,2,'Cron: Delete old repository archives has finished',1658271600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1951,2,'Cron: Update migration poster IDs has finished',1658271600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1952,2,'Cron: Cleanup hook_task table has finished',1658271600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1953,2,'Cron: Synchronize external user data has finished',1658271600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1954,2,'Cron: Check all repository statistics has finished',1658271600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1955,2,'Cron: Health check all repositories has finished',1658271632);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1956,2,'Cron: Cleanup hook_task table has finished',1658358000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1957,2,'Cron: Clean-up deleted branches has finished',1658358000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1958,2,'Cron: Delete old repository archives has finished',1658358000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1959,2,'Cron: Update migration poster IDs has finished',1658358000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1960,2,'Cron: Synchronize external user data has finished',1658358000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1961,2,'Cron: Check all repository statistics has finished',1658358000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1962,2,'Cron: Health check all repositories has finished',1658358043);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1963,2,'Cron: Cleanup hook_task table has finished',1658444400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1964,2,'Cron: Delete old repository archives has finished',1658444400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1965,2,'Cron: Synchronize external user data has finished',1658444400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1966,2,'Cron: Clean-up deleted branches has finished',1658444400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1967,2,'Cron: Check all repository statistics has finished',1658444400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1968,2,'Cron: Update migration poster IDs has finished',1658444400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1969,2,'Cron: Health check all repositories has finished',1658444421);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1970,2,'Cron: Delete old repository archives has finished',1658451628);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1971,2,'Cron: Clean-up deleted branches has finished',1658451628);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1972,2,'Cron: Update migration poster IDs has finished',1658451628);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1973,2,'Cron: Check all repository statistics has finished',1658451628);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1974,2,'Cron: Clean-up deleted branches has finished',1658530800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1975,2,'Cron: Cleanup hook_task table has finished',1658530800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1976,2,'Cron: Delete old repository archives has finished',1658530800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1977,2,'Cron: Update migration poster IDs has finished',1658530800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1978,2,'Cron: Synchronize external user data has finished',1658530800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1979,2,'Cron: Check all repository statistics has finished',1658530800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1980,2,'Cron: Health check all repositories has finished',1658530822);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1981,2,'Cron: Delete old repository archives has finished',1658617200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1982,2,'Cron: Clean-up deleted branches has finished',1658617200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1983,2,'Cron: Cleanup hook_task table has finished',1658617200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1984,2,'Cron: Update migration poster IDs has finished',1658617200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1985,2,'Cron: Synchronize external user data has finished',1658617200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1986,2,'Cron: Check all repository statistics has finished',1658617200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1987,2,'Cron: Health check all repositories has finished',1658617221);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1988,2,'Cron: Cleanup hook_task table has finished',1658703600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1989,2,'Cron: Clean-up deleted branches has finished',1658703600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1990,2,'Cron: Delete old repository archives has finished',1658703600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1991,2,'Cron: Synchronize external user data has finished',1658703600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1992,2,'Cron: Check all repository statistics has finished',1658703600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1993,2,'Cron: Update migration poster IDs has finished',1658703600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1994,2,'Cron: Health check all repositories has finished',1658703641);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1995,2,'Cron: Delete old repository archives has finished',1658790000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1996,2,'Cron: Cleanup hook_task table has finished',1658790000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1997,2,'Cron: Clean-up deleted branches has finished',1658790000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1998,2,'Cron: Update migration poster IDs has finished',1658790000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (1999,2,'Cron: Synchronize external user data has finished',1658790000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2000,2,'Cron: Check all repository statistics has finished',1658790000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2001,2,'Cron: Health check all repositories has finished',1658790021);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2002,2,'Cron: Clean-up deleted branches has finished',1658876400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2003,2,'Cron: Cleanup hook_task table has finished',1658876400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2004,2,'Cron: Delete old repository archives has finished',1658876400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2005,2,'Cron: Update migration poster IDs has finished',1658876400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2006,2,'Cron: Synchronize external user data has finished',1658876400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2007,2,'Cron: Check all repository statistics has finished',1658876400);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2008,2,'Cron: Health check all repositories has finished',1658876421);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2009,2,'Cron: Clean-up deleted branches has finished',1658962800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2010,2,'Cron: Cleanup hook_task table has finished',1658962800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2011,2,'Cron: Update migration poster IDs has finished',1658962800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2012,2,'Cron: Delete old repository archives has finished',1658962800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2013,2,'Cron: Synchronize external user data has finished',1658962800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2014,2,'Cron: Check all repository statistics has finished',1658962800);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2015,2,'Cron: Health check all repositories has finished',1658962821);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2016,2,'Cron: Cleanup hook_task table has finished',1659049200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2017,2,'Cron: Clean-up deleted branches has finished',1659049200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2018,2,'Cron: Update migration poster IDs has finished',1659049200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2019,2,'Cron: Delete old repository archives has finished',1659049200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2020,2,'Cron: Synchronize external user data has finished',1659049200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2021,2,'Cron: Check all repository statistics has finished',1659049200);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2022,2,'Cron: Health check all repositories has finished',1659049221);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2023,2,'Cron: Delete old repository archives has finished',1659056428);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2024,2,'Cron: Clean-up deleted branches has finished',1659056428);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2025,2,'Cron: Update migration poster IDs has finished',1659056428);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2026,2,'Cron: Check all repository statistics has finished',1659056429);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2027,2,'Task: Synchronize external user data started by administrator has finished',1659089963);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2028,2,'Cron: Delete old repository archives has finished',1659135600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2029,2,'Cron: Cleanup hook_task table has finished',1659135600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2030,2,'Cron: Clean-up deleted branches has finished',1659135600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2031,2,'Cron: Update migration poster IDs has finished',1659135600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2032,2,'Cron: Synchronize external user data has finished',1659135600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2033,2,'Cron: Check all repository statistics has finished',1659135600);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2034,2,'Cron: Health check all repositories has finished',1659135622);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2035,2,'Cron: Clean-up deleted branches has finished',1659222000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2036,2,'Cron: Delete old repository archives has finished',1659222000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2037,2,'Cron: Cleanup hook_task table has finished',1659222000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2038,2,'Cron: Update migration poster IDs has finished',1659222000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2039,2,'Cron: Synchronize external user data has finished',1659222000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2040,2,'Cron: Check all repository statistics has finished',1659222000);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2041,2,'Cron: Health check all repositories has finished',1659222021);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2042,2,'Task: Update checker cancelled: Get "https://dl.gitea.io/gitea/version.json": dial tcp 172.67.74.188:443: connectex: A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond.',1659347662);
INSERT INTO `notice` (`id`, `type`, `description`, `created_unix`) VALUES (2043,1,'Clean up temporary repositories [D:/gitea/data/tmp/local-repo]: remove D:/gitea/data/tmp/local-repo: Access is denied.',1659348753);

CREATE TABLE IF NOT EXISTS `foreign_reference` (`repo_id` BIGINT(20) NULL, `local_index` BIGINT(20) NULL, `foreign_index` VARCHAR(255) NULL, `type` VARCHAR(16) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_foreign_reference_repo_local` ON `foreign_reference` (`repo_id`,`local_index`);
CREATE INDEX `IDX_foreign_reference_foreign_index` ON `foreign_reference` (`foreign_index`);
CREATE INDEX `IDX_foreign_reference_type` ON `foreign_reference` (`type`);
CREATE UNIQUE INDEX `UQE_foreign_reference_repo_foreign_type` ON `foreign_reference` (`repo_id`,`foreign_index`,`type`);

CREATE TABLE IF NOT EXISTS `pull_auto_merge` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `pull_id` BIGINT(20) NULL, `doer_id` BIGINT(20) NOT NULL, `merge_style` VARCHAR(30) NULL, `message` LONGTEXT NULL, `created_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_pull_auto_merge_pull_id` ON `pull_auto_merge` (`pull_id`);

CREATE TABLE IF NOT EXISTS `review_state` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `user_id` BIGINT(20) NOT NULL, `pull_id` BIGINT(20) DEFAULT 0 NOT NULL, `commit_sha` VARCHAR(40) NOT NULL, `updated_files` TEXT NOT NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_review_state_pull_commit_user` ON `review_state` (`user_id`,`pull_id`,`commit_sha`);
CREATE INDEX `IDX_review_state_pull_id` ON `review_state` (`pull_id`);

CREATE TABLE IF NOT EXISTS `issue_assignees` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `assignee_id` BIGINT(20) NULL, `issue_id` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_issue_assignees_assignee_id` ON `issue_assignees` (`assignee_id`);
CREATE INDEX `IDX_issue_assignees_issue_id` ON `issue_assignees` (`issue_id`);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (1,2,1);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (2,2,9);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (3,2,32);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (27,2,55);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (29,2,58);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (33,2,61);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (36,2,65);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (37,2,69);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (40,2,152);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (42,2,155);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (44,2,71);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (47,2,73);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (49,2,74);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (51,2,72);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (53,2,156);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (54,2,157);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (55,2,159);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (56,2,161);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (57,2,164);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (58,2,165);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (60,2,166);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (61,2,168);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (62,2,169);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (63,2,170);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (64,2,177);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (67,2,179);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (70,2,180);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (74,2,185);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (75,2,193);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (76,2,194);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (78,2,196);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (79,2,198);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (80,2,199);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (81,2,203);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (83,2,238);
INSERT INTO `issue_assignees` (`id`, `assignee_id`, `issue_id`) VALUES (84,2,241);

CREATE TABLE IF NOT EXISTS `comment` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `type` INT NULL, `poster_id` BIGINT(20) NULL, `original_author` VARCHAR(255) NULL, `original_author_id` BIGINT(20) NULL, `issue_id` BIGINT(20) NULL, `label_id` BIGINT(20) NULL, `old_project_id` BIGINT(20) NULL, `project_id` BIGINT(20) NULL, `old_milestone_id` BIGINT(20) NULL, `milestone_id` BIGINT(20) NULL, `time_id` BIGINT(20) NULL, `assignee_id` BIGINT(20) NULL, `removed_assignee` TINYINT(1) NULL, `assignee_team_id` BIGINT(20) DEFAULT 0 NOT NULL, `resolve_doer_id` BIGINT(20) NULL, `old_title` VARCHAR(255) NULL, `new_title` VARCHAR(255) NULL, `old_ref` VARCHAR(255) NULL, `new_ref` VARCHAR(255) NULL, `dependent_issue_id` BIGINT(20) NULL, `commit_id` BIGINT(20) NULL, `line` BIGINT(20) NULL, `tree_path` VARCHAR(255) NULL, `content` LONGTEXT NULL, `patch` LONGTEXT NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL, `commit_sha` VARCHAR(40) NULL, `review_id` BIGINT(20) NULL, `invalidated` TINYINT(1) NULL, `ref_repo_id` BIGINT(20) NULL, `ref_issue_id` BIGINT(20) NULL, `ref_comment_id` BIGINT(20) NULL, `ref_action` SMALLINT NULL, `ref_is_pull` TINYINT(1) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_comment_issue_id` ON `comment` (`issue_id`);
CREATE INDEX `IDX_comment_ref_issue_id` ON `comment` (`ref_issue_id`);
CREATE INDEX `IDX_comment_ref_comment_id` ON `comment` (`ref_comment_id`);
CREATE INDEX `IDX_comment_type` ON `comment` (`type`);
CREATE INDEX `IDX_comment_poster_id` ON `comment` (`poster_id`);
CREATE INDEX `IDX_comment_created_unix` ON `comment` (`created_unix`);
CREATE INDEX `IDX_comment_updated_unix` ON `comment` (`updated_unix`);
CREATE INDEX `IDX_comment_review_id` ON `comment` (`review_id`);
CREATE INDEX `IDX_comment_ref_repo_id` ON `comment` (`ref_repo_id`);

CREATE TABLE IF NOT EXISTS `issue_content_history` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `poster_id` BIGINT(20) NULL, `issue_id` BIGINT(20) NULL, `comment_id` BIGINT(20) NULL, `edited_unix` BIGINT(20) NULL, `content_text` LONGTEXT NULL, `is_first_created` TINYINT(1) NULL, `is_deleted` TINYINT(1) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_issue_content_history_edited_unix` ON `issue_content_history` (`edited_unix`);
CREATE INDEX `IDX_issue_content_history_issue_id` ON `issue_content_history` (`issue_id`);
CREATE INDEX `IDX_issue_content_history_comment_id` ON `issue_content_history` (`comment_id`);

CREATE TABLE IF NOT EXISTS `issue_dependency` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `user_id` BIGINT(20) NOT NULL, `issue_id` BIGINT(20) NOT NULL, `dependency_id` BIGINT(20) NOT NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_issue_dependency_issue_dependency` ON `issue_dependency` (`issue_id`,`dependency_id`);

CREATE TABLE IF NOT EXISTS `issue` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NULL, `index` BIGINT(20) NULL, `poster_id` BIGINT(20) NULL, `original_author` VARCHAR(255) NULL, `original_author_id` BIGINT(20) NULL, `name` VARCHAR(255) NULL, `content` LONGTEXT NULL, `milestone_id` BIGINT(20) NULL, `priority` INT NULL, `is_closed` TINYINT(1) NULL, `is_pull` TINYINT(1) NULL, `num_comments` INT NULL, `ref` VARCHAR(255) NULL, `deadline_unix` BIGINT(20) NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL, `closed_unix` BIGINT(20) NULL, `is_locked` TINYINT(1) DEFAULT false NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_issue_is_closed` ON `issue` (`is_closed`);
CREATE INDEX `IDX_issue_deadline_unix` ON `issue` (`deadline_unix`);
CREATE INDEX `IDX_issue_created_unix` ON `issue` (`created_unix`);
CREATE INDEX `IDX_issue_updated_unix` ON `issue` (`updated_unix`);
CREATE INDEX `IDX_issue_closed_unix` ON `issue` (`closed_unix`);
CREATE UNIQUE INDEX `UQE_issue_repo_index` ON `issue` (`repo_id`,`index`);
CREATE INDEX `IDX_issue_repo_id` ON `issue` (`repo_id`);
CREATE INDEX `IDX_issue_original_author_id` ON `issue` (`original_author_id`);
CREATE INDEX `IDX_issue_poster_id` ON `issue` (`poster_id`);
CREATE INDEX `IDX_issue_milestone_id` ON `issue` (`milestone_id`);
CREATE INDEX `IDX_issue_is_pull` ON `issue` (`is_pull`);

CREATE TABLE IF NOT EXISTS `issue_index` (`group_id` BIGINT(20) PRIMARY KEY NOT NULL, `max_index` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_issue_index_max_index` ON `issue_index` (`max_index`);

CREATE TABLE IF NOT EXISTS `issue_user` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `uid` BIGINT(20) NULL, `issue_id` BIGINT(20) NULL, `is_read` TINYINT(1) NULL, `is_mentioned` TINYINT(1) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_issue_user_uid` ON `issue_user` (`uid`);

CREATE TABLE IF NOT EXISTS `issue_watch` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `user_id` BIGINT(20) NOT NULL, `issue_id` BIGINT(20) NOT NULL, `is_watching` TINYINT(1) NOT NULL, `created_unix` BIGINT(20) NOT NULL, `updated_unix` BIGINT(20) NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_issue_watch_watch` ON `issue_watch` (`user_id`,`issue_id`);

CREATE TABLE IF NOT EXISTS `label` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NULL, `org_id` BIGINT(20) NULL, `name` VARCHAR(255) NULL, `description` VARCHAR(255) NULL, `color` VARCHAR(7) NULL, `num_issues` INT NULL, `num_closed_issues` INT NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_label_org_id` ON `label` (`org_id`);
CREATE INDEX `IDX_label_created_unix` ON `label` (`created_unix`);
CREATE INDEX `IDX_label_updated_unix` ON `label` (`updated_unix`);
CREATE INDEX `IDX_label_repo_id` ON `label` (`repo_id`);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (1,0,12,'Priority::Critical','Serious issue requiring immediate focus','#e8000b',0,0,1637192725,1637192725);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (2,0,12,'Priority::High','Issue with higher priority','#ff7c00',0,0,1637192725,1637192725);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (3,0,12,'Priority::Medium','Issue to be resolved in a timely fashion','#ffc400',0,0,1637192725,1637192725);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (4,0,12,'Priority::Low','Issue can be postponed due to low criticality or need','#1ac938',1,0,1637192725,1656340929);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (5,0,12,'Type::Bug','An unwanted behaviour has been observed','#c44e52',0,0,1637192725,1637192725);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (6,0,12,'Type::Regression','A previous behaviours is no longer observable','#da8bc3',0,0,1637192725,1637192725);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (7,0,12,'Type::Enhancement','A modification to existing behaviour being requested','#64b5cd',0,0,1637192725,1637192725);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (8,0,12,'Type::Question','RFC/RFI type query','#8172b3',0,0,1637192725,1637192725);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (9,0,12,'Type::New','A new feature being requested','#55a868',0,0,1637192725,1637192725);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (10,0,12,'Status::Abandoned','No long needed','#3c3c3c',0,0,1637192725,1637192725);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (11,0,12,'Status::Accepted','The issue has been accepted','#8de5a1',1,0,1637192725,1656340929);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (12,0,12,'Status::Blocked','Issue depends on additional functional changes','#ffb482',0,0,1637192725,1637192725);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (13,0,12,'Status::Completed','Issue is resolved','#006374',0,0,1637192725,1637192725);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (14,0,12,'Status::In Progress','Issue is being worked on','#cfcfcf',1,0,1637192725,1656340929);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (15,0,12,'Status::On Hold','Work on Issue postponed','#ffb482',0,0,1637192725,1637192725);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (16,0,12,'Status::Review Needed','Issue/PR requires independent review','#a1c9f4',0,0,1637192725,1637192725);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (17,0,12,'Status::Information required','Additional information is required to proceed','#a1c9f4',0,0,1637192725,1637192725);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (18,0,11,'Priority::Critical','Serious issue requiring immediate focus','#e8000b',0,0,1637192829,1637192829);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (19,0,11,'Priority::High','Issue with higher priority','#ff7c00',0,0,1637192829,1637192829);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (20,0,11,'Priority::Medium','Issue to be resolved in a timely fashion','#ffc400',0,0,1637192829,1637192829);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (21,0,11,'Priority::Low','Issue can be postponed due to low criticality or need','#1ac938',0,0,1637192829,1637192829);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (22,0,11,'Type::Bug','An unwanted behaviour has been observed','#c44e52',1,0,1637192829,1641990964);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (23,0,11,'Type::Regression','A previous behaviours is no longer observable','#da8bc3',0,0,1637192829,1637192829);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (24,0,11,'Type::Enhancement','A modification to existing behaviour being requested','#64b5cd',2,0,1637192829,1641991216);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (25,0,11,'Type::Question','RFC/RFI type query','#8172b3',0,0,1637192829,1637192829);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (26,0,11,'Type::New','A new feature being requested','#55a868',0,0,1637192829,1637192829);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (27,0,11,'Status::Abandoned','No long needed','#3c3c3c',0,0,1637192829,1637192829);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (28,0,11,'Status::Accepted','The issue has been accepted','#8de5a1',0,0,1637192829,1637192829);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (29,0,11,'Status::Blocked','Issue depends on additional functional changes','#ffb482',0,0,1637192829,1637192829);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (30,0,11,'Status::Completed','Issue is resolved','#006374',1,0,1637192829,1641330408);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (31,0,11,'Status::In Progress','Issue is being worked on','#cfcfcf',0,0,1637192829,1641330408);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (32,0,11,'Status::On Hold','Work on Issue postponed','#ffb482',0,0,1637192829,1637192829);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (33,0,11,'Status::Review Needed','Issue/PR requires independent review','#a1c9f4',0,0,1637192829,1637192829);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (34,0,11,'Status::Information required','Additional information is required to proceed','#a1c9f4',0,0,1637192829,1637192829);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (35,0,13,'Priority::Critical','Serious issue requiring immediate focus','#e8000b',0,0,1637193191,1637193191);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (36,0,13,'Priority::High','Issue with higher priority','#ff7c00',0,0,1637193191,1637193191);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (37,0,13,'Priority::Medium','Issue to be resolved in a timely fashion','#ffc400',0,0,1637193191,1637193191);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (38,0,13,'Priority::Low','Issue can be postponed due to low criticality or need','#1ac938',0,0,1637193191,1637193191);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (39,0,13,'Type::Bug','An unwanted behaviour has been observed','#c44e52',0,0,1637193191,1637193191);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (40,0,13,'Type::Regression','A previous behaviours is no longer observable','#da8bc3',0,0,1637193191,1637193191);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (41,0,13,'Type::Enhancement','A modification to existing behaviour being requested','#64b5cd',0,0,1637193191,1637193191);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (42,0,13,'Type::Question','RFC/RFI type query','#8172b3',0,0,1637193191,1637193191);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (43,0,13,'Type::New','A new feature being requested','#55a868',0,0,1637193191,1637193191);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (44,0,13,'Status::Abandoned','No long needed','#3c3c3c',0,0,1637193191,1637193191);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (45,0,13,'Status::Accepted','The issue has been accepted','#8de5a1',0,0,1637193191,1637193191);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (46,0,13,'Status::Blocked','Issue depends on additional functional changes','#ffb482',0,0,1637193191,1637193191);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (47,0,13,'Status::Completed','Issue is resolved','#006374',0,0,1637193191,1637193191);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (48,0,13,'Status::In Progress','Issue is being worked on','#cfcfcf',0,0,1637193191,1637193191);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (49,0,13,'Status::On Hold','Work on Issue postponed','#ffb482',0,0,1637193191,1637193191);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (50,0,13,'Status::Review Needed','Issue/PR requires independent review','#a1c9f4',0,0,1637193191,1637193191);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (51,0,13,'Status::Information required','Additional information is required to proceed','#a1c9f4',0,0,1637193191,1637193191);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (120,0,15,'Priority::Critical','Serious issue requiring immediate focus','#e8000b',0,0,1638527227,1638527227);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (121,0,15,'Priority::High','Issue with higher priority','#ff7c00',3,0,1638527227,1652697567);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (122,0,15,'Priority::Medium','Issue to be resolved in a timely fashion','#ffc400',0,0,1638527227,1638527227);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (123,0,15,'Priority::Low','Issue can be postponed due to low criticality or need','#1ac938',1,0,1638527227,1646250089);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (124,0,15,'Type::Bug','An unwanted behaviour has been observed','#c44e52',2,0,1638527227,1652697567);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (125,0,15,'Type::Regression','A previous behaviours is no longer observable','#da8bc3',0,0,1638527227,1638527227);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (126,0,15,'Type::Enhancement','A modification to existing behaviour being requested','#64b5cd',6,0,1638527227,1648048604);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (127,0,15,'Type::Question','RFC/RFI type query','#8172b3',0,0,1638527227,1638527227);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (128,0,15,'Type::New','A new feature being requested','#55a868',0,0,1638527227,1638527227);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (129,0,15,'Status::Abandoned','No long needed','#3c3c3c',1,0,1638527227,1651670054);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (130,0,15,'Status::Accepted','The issue has been accepted','#8de5a1',4,0,1638527227,1652697567);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (131,0,15,'Status::Blocked','Issue depends on additional functional changes','#ffb482',0,0,1638527227,1638527227);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (132,0,15,'Status::Completed','Issue is resolved','#006374',1,0,1638527227,1652800336);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (133,0,15,'Status::In Progress','Issue is being worked on','#cfcfcf',0,0,1638527227,1638527227);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (134,0,15,'Status::On Hold','Work on Issue postponed','#ffb482',0,0,1638527227,1638527227);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (135,0,15,'Status::Review Needed','Issue/PR requires independent review','#a1c9f4',0,0,1638527227,1638527227);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (136,0,15,'Status::Information required','Additional information is required to proceed','#a1c9f4',0,0,1638527227,1638527227);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (188,0,16,'Priority::Critical','Serious issue requiring immediate focus','#e8000b',0,0,1638554508,1641461381);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (189,0,16,'Priority::High','Issue with higher priority','#ff7c00',2,0,1638554508,1659086757);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (190,0,16,'Priority::Medium','Issue to be resolved in a timely fashion','#ffc400',3,0,1638554508,1659086757);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (191,0,16,'Priority::Low','Issue can be postponed due to low criticality or need','#1ac938',3,0,1638554508,1656318855);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (192,0,16,'Type::Bug','An unwanted behaviour has been observed','#c44e52',0,0,1638554508,1638554508);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (193,0,16,'Type::Regression','A previous behaviours is no longer observable','#da8bc3',0,0,1638554508,1638554508);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (194,0,16,'Type::Enhancement','A modification to existing behaviour being requested','#64b5cd',1,0,1638554508,1641380182);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (195,0,16,'Type::Question','RFC/RFI type query','#8172b3',2,0,1638554508,1656318855);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (196,0,16,'Type::New','A new feature being requested','#55a868',3,0,1638554508,1659086757);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (197,0,16,'Status::Abandoned','No long needed','#3c3c3c',0,0,1638554508,1638554508);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (198,0,16,'Status::Accepted','The issue has been accepted','#8de5a1',0,0,1638554508,1638554508);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (199,0,16,'Status::Blocked','Issue depends on additional functional changes','#ffb482',0,0,1638554508,1638554508);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (200,0,16,'Status::Completed','Issue is resolved','#006374',0,0,1638554508,1638554508);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (201,0,16,'Status::In Progress','Issue is being worked on','#cfcfcf',1,0,1638554508,1652968623);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (202,0,16,'Status::On Hold','Work on Issue postponed','#ffb482',0,0,1638554508,1638554508);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (203,0,16,'Status::Review Needed','Issue/PR requires independent review','#a1c9f4',0,0,1638554508,1638554508);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (204,0,16,'Status::Information required','Additional information is required to proceed','#a1c9f4',0,0,1638554508,1638554508);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (205,0,14,'Priority::Critical','Serious issue requiring immediate focus','#e8000b',0,0,1638577039,1638577039);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (206,0,14,'Priority::High','Issue with higher priority','#ff7c00',0,0,1638577039,1638577039);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (207,0,14,'Priority::Medium','Issue to be resolved in a timely fashion','#ffc400',0,0,1638577039,1638577039);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (208,0,14,'Priority::Low','Issue can be postponed due to low criticality or need','#1ac938',0,0,1638577039,1638577039);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (209,0,14,'Type::Bug','An unwanted behaviour has been observed','#c44e52',0,0,1638577039,1638577039);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (210,0,14,'Type::Regression','A previous behaviours is no longer observable','#da8bc3',0,0,1638577039,1638577039);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (211,0,14,'Type::Enhancement','A modification to existing behaviour being requested','#64b5cd',0,0,1638577039,1638577039);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (212,0,14,'Type::Question','RFC/RFI type query','#8172b3',0,0,1638577039,1638577039);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (213,0,14,'Type::New','A new feature being requested','#55a868',0,0,1638577039,1638577039);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (214,0,14,'Status::Abandoned','No long needed','#3c3c3c',0,0,1638577039,1638577039);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (215,0,14,'Status::Accepted','The issue has been accepted','#8de5a1',0,0,1638577039,1638577039);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (216,0,14,'Status::Blocked','Issue depends on additional functional changes','#ffb482',0,0,1638577039,1638577039);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (217,0,14,'Status::Completed','Issue is resolved','#006374',0,0,1638577039,1638577039);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (218,0,14,'Status::In Progress','Issue is being worked on','#cfcfcf',0,0,1638577039,1638577039);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (219,0,14,'Status::On Hold','Work on Issue postponed','#ffb482',0,0,1638577039,1638577039);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (220,0,14,'Status::Review Needed','Issue/PR requires independent review','#a1c9f4',0,0,1638577039,1638577039);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (221,0,14,'Status::Information required','Additional information is required to proceed','#a1c9f4',0,0,1638577039,1638577039);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (307,0,22,'Priority::Critical','Serious issue requiring immediate focus','#e8000b',0,0,1646222207,1646222207);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (308,0,22,'Priority::High','Issue with higher priority','#ff7c00',1,0,1646222207,1656674000);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (309,0,22,'Priority::Medium','Issue to be resolved in a timely fashion','#ffc400',1,0,1646222207,1659007716);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (310,0,22,'Priority::Low','Issue can be postponed due to low criticality or need','#1ac938',1,0,1646222207,1659020936);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (311,0,22,'Type::Bug','An unwanted behaviour has been observed','#c44e52',0,0,1646222207,1646222207);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (312,0,22,'Type::Regression','A previous behaviours is no longer observable','#da8bc3',0,0,1646222207,1646222207);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (313,0,22,'Type::Enhancement','A modification to existing behaviour being requested','#64b5cd',0,0,1646222207,1646222207);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (314,0,22,'Type::Question','RFC/RFI type query','#8172b3',0,0,1646222207,1646222207);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (315,0,22,'Type::New','A new feature being requested','#55a868',0,0,1646222207,1646222207);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (316,0,22,'Status::Abandoned','No long needed','#3c3c3c',0,0,1646222207,1646222207);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (317,0,22,'Status::Accepted','The issue has been accepted','#8de5a1',0,0,1646222207,1646222207);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (318,0,22,'Status::Blocked','Issue depends on additional functional changes','#ffb482',0,0,1646222207,1646222207);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (319,0,22,'Status::Completed','Issue is resolved','#006374',0,0,1646222207,1646222207);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (320,0,22,'Status::In Progress','Issue is being worked on','#cfcfcf',0,0,1646222207,1646222207);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (321,0,22,'Status::On Hold','Work on Issue postponed','#ffb482',0,0,1646222207,1646222207);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (322,0,22,'Status::Review Needed','Issue/PR requires independent review','#a1c9f4',0,0,1646222207,1646222207);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (323,0,22,'Status::Information required','Additional information is required to proceed','#a1c9f4',0,0,1646222207,1646222207);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (341,0,26,'Priority::Critical','Serious issue requiring immediate focus','#e8000b',2,0,1648724753,1658839776);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (342,0,26,'Priority::High','Issue with higher priority','#ff7c00',26,0,1648724753,1658396782);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (343,0,26,'Priority::Medium','Issue to be resolved in a timely fashion','#ffc400',25,0,1648724753,1658915673);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (344,0,26,'Priority::Low','Issue can be postponed due to low criticality or need','#1ac938',86,0,1648724754,1658939167);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (345,0,26,'Type::Bug','An unwanted behaviour has been observed','#c44e52',6,0,1648724754,1652631177);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (346,0,26,'Type::Regression','A previous behaviours is no longer observable','#da8bc3',0,0,1648724754,1648724754);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (347,0,26,'Type::Enhancement','A modification to existing behaviour being requested','#64b5cd',4,0,1648724754,1658162676);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (348,0,26,'Type::Question','RFC/RFI type query','#8172b3',14,0,1648724754,1658313654);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (349,0,26,'Type::New','A new feature being requested','#55a868',0,0,1648724754,1648724754);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (350,0,26,'Status::Abandoned','No long needed','#3c3c3c',42,0,1648724754,1657632782);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (351,0,26,'Status::Accepted','The issue has been accepted','#8de5a1',24,0,1648724754,1658396782);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (352,0,26,'Status::Blocked','Issue depends on additional functional changes','#ffb482',0,0,1648724754,1648724754);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (353,0,26,'Status::Completed','Issue is resolved','#006374',26,0,1648724754,1655992780);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (354,0,26,'Status::In Progress','Issue is being worked on','#cfcfcf',4,0,1648724754,1656517026);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (355,0,26,'Status::On Hold','Work on Issue postponed','#ffb482',0,0,1648724754,1648724754);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (356,0,26,'Status::Review Needed','Issue/PR requires independent review','#a1c9f4',0,0,1648724754,1648724754);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (357,0,26,'Status::Information required','Additional information is required to proceed','#a1c9f4',1,0,1648724754,1654707618);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (390,0,22,'Type::HW','Hardware design problem','#d4c5f9',7,0,1659008293,1659111429);
INSERT INTO `label` (`id`, `repo_id`, `org_id`, `name`, `description`, `color`, `num_issues`, `num_closed_issues`, `created_unix`, `updated_unix`) VALUES (391,0,22,'Type::Testing','Problem with the testing setup vs operational environment','#207de5',2,0,1659099675,1659099791);

CREATE TABLE IF NOT EXISTS `issue_label` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `issue_id` BIGINT(20) NULL, `label_id` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_issue_label_s` ON `issue_label` (`issue_id`,`label_id`);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (43,45,190);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (37,54,24);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (39,54,30);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (40,55,191);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (41,55,194);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (42,57,189);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (46,57,201);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (45,58,126);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (47,59,189);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (49,61,126);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (50,62,22);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (51,63,24);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (52,65,123);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (53,65,126);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (54,65,130);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (58,66,121);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (59,66,126);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (60,66,130);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (61,69,126);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (62,70,126);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (410,71,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (81,71,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (76,72,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (77,72,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (72,73,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (73,73,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (69,74,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (70,74,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (234,75,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (323,75,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (210,76,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (211,76,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (63,77,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (67,77,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (337,77,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (64,78,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (66,78,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (208,79,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (209,79,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (207,80,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (87,81,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (205,82,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (206,82,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (84,84,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (85,84,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (88,85,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (89,85,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (203,85,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (204,86,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (212,87,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (308,87,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (213,88,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (214,88,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (215,89,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (216,89,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (217,90,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (218,90,354);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (220,91,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (221,91,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (223,92,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (224,92,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (226,93,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (227,93,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (229,94,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (230,94,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (232,95,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (233,95,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (235,96,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (236,96,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (306,97,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (307,97,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (238,98,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (239,98,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (242,99,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (150,100,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (151,100,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (152,100,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (148,101,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (244,101,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (142,102,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (245,102,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (309,103,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (310,103,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (298,104,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (299,104,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (137,105,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (304,106,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (305,106,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (270,107,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (271,107,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (95,108,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (96,108,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (98,109,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (99,109,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (102,110,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (103,110,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (104,111,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (105,111,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (107,112,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (108,112,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (110,113,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (111,113,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (113,114,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (114,114,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (116,115,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (117,115,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (119,116,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (120,116,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (122,117,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (123,117,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (125,118,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (126,118,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (128,119,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (129,119,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (131,120,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (266,120,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (133,121,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (134,121,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (283,122,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (284,122,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (281,123,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (282,123,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (316,124,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (317,124,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (258,125,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (259,125,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (314,126,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (315,126,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (288,127,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (289,127,354);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (276,128,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (277,130,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (278,130,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (273,131,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (274,131,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (291,132,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (292,132,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (293,133,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (295,134,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (296,134,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (285,135,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (301,136,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (302,136,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (279,137,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (280,137,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (264,138,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (265,138,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (262,139,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (263,139,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (248,140,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (249,140,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (246,141,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (247,141,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (423,142,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (424,142,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (311,143,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (312,143,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (250,144,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (251,144,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (286,145,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (287,145,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (253,146,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (254,146,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (260,147,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (261,147,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (267,148,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (268,148,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (300,149,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (321,150,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (320,151,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (354,152,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (355,152,357);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (338,153,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (339,153,345);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (350,154,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (351,154,348);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (343,155,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (344,155,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (340,156,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (349,157,348);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (358,158,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (359,158,345);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (360,158,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (361,159,121);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (362,159,124);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (363,159,130);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (365,160,129);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (366,161,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (367,161,348);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (368,161,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (372,162,121);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (373,162,124);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (374,162,130);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (470,162,132);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (375,163,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (379,164,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (385,164,345);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (386,164,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (382,165,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (383,165,347);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (389,165,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (387,166,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (388,166,345);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (390,167,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (391,167,348);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (392,167,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (396,168,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (397,168,348);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (408,169,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (400,169,348);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (402,170,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (403,170,348);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (420,171,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (421,171,347);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (409,172,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (411,177,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (412,177,348);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (414,179,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (415,179,345);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (416,179,348);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (428,180,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (418,181,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (419,181,347);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (451,184,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (429,185,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (432,185,345);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (455,186,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (456,186,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (452,187,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (453,187,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (442,188,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (443,188,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (445,189,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (446,189,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (448,190,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (449,190,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (436,191,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (437,191,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (439,192,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (440,192,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (434,193,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (435,193,348);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (458,194,190);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (459,194,196);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (460,195,191);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (461,195,195);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (462,196,191);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (463,196,195);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (464,197,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (465,197,354);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (472,198,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (473,198,348);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (474,199,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (475,199,348);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (477,202,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (481,203,341);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (483,205,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (484,205,348);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (485,205,353);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (490,206,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (491,206,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (493,207,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (494,207,348);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (497,208,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (498,208,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (503,214,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (506,222,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (509,227,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (510,227,347);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (511,229,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (512,229,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (513,229,354);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (514,230,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (517,231,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (518,231,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (520,232,4);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (521,232,11);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (522,232,14);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (523,234,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (524,235,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (526,236,308);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (527,238,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (528,238,351);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (530,239,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (531,240,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (532,241,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (535,245,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (536,246,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (537,247,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (538,250,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (539,251,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (540,252,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (541,253,344);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (546,256,350);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (554,258,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (558,263,342);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (565,266,343);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (570,267,341);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (571,270,309);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (574,270,390);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (572,271,310);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (573,271,390);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (588,272,390);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (586,273,391);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (587,274,390);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (585,275,390);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (584,276,391);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (582,277,390);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (578,279,196);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (580,280,190);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (581,280,196);
INSERT INTO `issue_label` (`id`, `issue_id`, `label_id`) VALUES (589,281,390);

CREATE TABLE IF NOT EXISTS `milestone` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NULL, `name` VARCHAR(255) NULL, `content` TEXT NULL, `is_closed` TINYINT(1) NULL, `num_issues` INT NULL, `num_closed_issues` INT NULL, `completeness` INT NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL, `deadline_unix` BIGINT(20) NULL, `closed_date_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_milestone_repo_id` ON `milestone` (`repo_id`);
CREATE INDEX `IDX_milestone_created_unix` ON `milestone` (`created_unix`);
CREATE INDEX `IDX_milestone_updated_unix` ON `milestone` (`updated_unix`);

CREATE TABLE IF NOT EXISTS `pull_request` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `type` INT NULL, `status` INT NULL, `conflicted_files` TEXT NULL, `commits_ahead` INT NULL, `commits_behind` INT NULL, `changed_protected_files` TEXT NULL, `issue_id` BIGINT(20) NULL, `index` BIGINT(20) NULL, `head_repo_id` BIGINT(20) NULL, `base_repo_id` BIGINT(20) NULL, `head_branch` VARCHAR(255) NULL, `base_branch` VARCHAR(255) NULL, `merge_base` VARCHAR(40) NULL, `allow_maintainer_edit` TINYINT(1) DEFAULT false NOT NULL, `has_merged` TINYINT(1) NULL, `merged_commit_id` VARCHAR(40) NULL, `merger_id` BIGINT(20) NULL, `merged_unix` BIGINT(20) NULL, `flow` INT DEFAULT 0 NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_pull_request_has_merged` ON `pull_request` (`has_merged`);
CREATE INDEX `IDX_pull_request_merger_id` ON `pull_request` (`merger_id`);
CREATE INDEX `IDX_pull_request_merged_unix` ON `pull_request` (`merged_unix`);
CREATE INDEX `IDX_pull_request_issue_id` ON `pull_request` (`issue_id`);
CREATE INDEX `IDX_pull_request_head_repo_id` ON `pull_request` (`head_repo_id`);
CREATE INDEX `IDX_pull_request_base_repo_id` ON `pull_request` (`base_repo_id`);

CREATE TABLE IF NOT EXISTS `reaction` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `type` VARCHAR(255) NOT NULL, `issue_id` BIGINT(20) NOT NULL, `comment_id` BIGINT(20) NULL, `user_id` BIGINT(20) NOT NULL, `original_author_id` BIGINT(20) DEFAULT 0 NOT NULL, `original_author` VARCHAR(255) NULL, `created_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_reaction_issue_id` ON `reaction` (`issue_id`);
CREATE INDEX `IDX_reaction_comment_id` ON `reaction` (`comment_id`);
CREATE INDEX `IDX_reaction_user_id` ON `reaction` (`user_id`);
CREATE INDEX `IDX_reaction_original_author_id` ON `reaction` (`original_author_id`);
CREATE INDEX `IDX_reaction_original_author` ON `reaction` (`original_author`);
CREATE INDEX `IDX_reaction_created_unix` ON `reaction` (`created_unix`);
CREATE UNIQUE INDEX `UQE_reaction_s` ON `reaction` (`type`,`issue_id`,`comment_id`,`user_id`,`original_author_id`,`original_author`);
CREATE INDEX `IDX_reaction_type` ON `reaction` (`type`);

CREATE TABLE IF NOT EXISTS `review` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `type` INT NULL, `reviewer_id` BIGINT(20) NULL, `reviewer_team_id` BIGINT(20) DEFAULT 0 NOT NULL, `original_author` VARCHAR(255) NULL, `original_author_id` BIGINT(20) NULL, `issue_id` BIGINT(20) NULL, `content` TEXT NULL, `official` TINYINT(1) DEFAULT false NOT NULL, `commit_id` VARCHAR(40) NULL, `stale` TINYINT(1) DEFAULT false NOT NULL, `dismissed` TINYINT(1) DEFAULT false NOT NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_review_reviewer_id` ON `review` (`reviewer_id`);
CREATE INDEX `IDX_review_issue_id` ON `review` (`issue_id`);
CREATE INDEX `IDX_review_created_unix` ON `review` (`created_unix`);
CREATE INDEX `IDX_review_updated_unix` ON `review` (`updated_unix`);
INSERT INTO `review` (`id`, `type`, `reviewer_id`, `reviewer_team_id`, `original_author`, `original_author_id`, `issue_id`, `content`, `official`, `commit_id`, `stale`, `dismissed`, `created_unix`, `updated_unix`) VALUES (1,4,0,24,'',0,83,'',0,'',1,0,1649414664,1649414664);

CREATE TABLE IF NOT EXISTS `stopwatch` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `issue_id` BIGINT(20) NULL, `user_id` BIGINT(20) NULL, `created_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_stopwatch_issue_id` ON `stopwatch` (`issue_id`);
CREATE INDEX `IDX_stopwatch_user_id` ON `stopwatch` (`user_id`);

CREATE TABLE IF NOT EXISTS `tracked_time` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `issue_id` BIGINT(20) NULL, `user_id` BIGINT(20) NULL, `created_unix` BIGINT(20) NULL, `time` BIGINT(20) NOT NULL, `deleted` TINYINT(1) DEFAULT false NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_tracked_time_issue_id` ON `tracked_time` (`issue_id`);
CREATE INDEX `IDX_tracked_time_user_id` ON `tracked_time` (`user_id`);

CREATE TABLE IF NOT EXISTS `hook_task` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NULL, `hook_id` BIGINT(20) NULL, `uuid` VARCHAR(255) NULL, `payload_content` LONGTEXT NULL, `event_type` VARCHAR(255) NULL, `is_delivered` TINYINT(1) NULL, `delivered` BIGINT(20) NULL, `is_succeed` TINYINT(1) NULL, `request_content` LONGTEXT NULL, `response_content` LONGTEXT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_hook_task_repo_id` ON `hook_task` (`repo_id`);

CREATE TABLE IF NOT EXISTS `webhook` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NULL, `org_id` BIGINT(20) NULL, `is_system_webhook` TINYINT(1) NULL, `url` TEXT NULL, `http_method` VARCHAR(255) NULL, `content_type` INT NULL, `secret` TEXT NULL, `events` TEXT NULL, `is_active` TINYINT(1) NULL, `type` VARCHAR(16) NULL, `meta` TEXT NULL, `last_status` INT NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_webhook_repo_id` ON `webhook` (`repo_id`);
CREATE INDEX `IDX_webhook_org_id` ON `webhook` (`org_id`);
CREATE INDEX `IDX_webhook_is_active` ON `webhook` (`is_active`);
CREATE INDEX `IDX_webhook_created_unix` ON `webhook` (`created_unix`);
CREATE INDEX `IDX_webhook_updated_unix` ON `webhook` (`updated_unix`);

CREATE TABLE IF NOT EXISTS `action` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `user_id` BIGINT(20) NULL, `op_type` INT NULL, `act_user_id` BIGINT(20) NULL, `repo_id` BIGINT(20) NULL, `comment_id` BIGINT(20) NULL, `is_deleted` TINYINT(1) DEFAULT false NOT NULL, `ref_name` VARCHAR(255) NULL, `is_private` TINYINT(1) DEFAULT false NOT NULL, `content` TEXT NULL, `created_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_action_comment_id` ON `action` (`comment_id`);
CREATE INDEX `IDX_action_au_r_c_u_d` ON `action` (`act_user_id`,`repo_id`,`created_unix`,`user_id`,`is_deleted`);
CREATE INDEX `IDX_action_r_u_d` ON `action` (`repo_id`,`user_id`,`is_deleted`);
INSERT INTO `action` (`id`, `user_id`, `op_type`, `act_user_id`, `repo_id`, `comment_id`, `is_deleted`, `ref_name`, `is_private`, `content`, `created_unix`) VALUES (1,2,1,2,1,0,0,'',0,'',1659475208);
INSERT INTO `action` (`id`, `user_id`, `op_type`, `act_user_id`, `repo_id`, `comment_id`, `is_deleted`, `ref_name`, `is_private`, `content`, `created_unix`) VALUES (2,23,1,2,1,0,0,'',0,'',1659475208);

CREATE TABLE IF NOT EXISTS `notification` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `user_id` BIGINT(20) NOT NULL, `repo_id` BIGINT(20) NOT NULL, `status` SMALLINT NOT NULL, `source` SMALLINT NOT NULL, `issue_id` BIGINT(20) NOT NULL, `commit_id` VARCHAR(255) NULL, `comment_id` BIGINT(20) NULL, `updated_by` BIGINT(20) NOT NULL, `created_unix` BIGINT(20) NOT NULL, `updated_unix` BIGINT(20) NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_notification_user_id` ON `notification` (`user_id`);
CREATE INDEX `IDX_notification_issue_id` ON `notification` (`issue_id`);
CREATE INDEX `IDX_notification_updated_by` ON `notification` (`updated_by`);
CREATE INDEX `IDX_notification_created_unix` ON `notification` (`created_unix`);
CREATE INDEX `IDX_notification_repo_id` ON `notification` (`repo_id`);
CREATE INDEX `IDX_notification_status` ON `notification` (`status`);
CREATE INDEX `IDX_notification_source` ON `notification` (`source`);
CREATE INDEX `IDX_notification_commit_id` ON `notification` (`commit_id`);
CREATE INDEX `IDX_notification_updated_unix` ON `notification` (`updated_unix`);

CREATE TABLE IF NOT EXISTS `release` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `repo_id` BIGINT(20) NULL, `publisher_id` BIGINT(20) NULL, `tag_name` VARCHAR(255) NULL, `original_author` VARCHAR(255) NULL, `original_author_id` BIGINT(20) NULL, `lower_tag_name` VARCHAR(255) NULL, `target` VARCHAR(255) NULL, `title` VARCHAR(255) NULL, `sha1` VARCHAR(40) NULL, `num_commits` BIGINT(20) NULL, `note` TEXT NULL, `is_draft` TINYINT(1) DEFAULT false NOT NULL, `is_prerelease` TINYINT(1) DEFAULT false NOT NULL, `is_tag` TINYINT(1) DEFAULT false NOT NULL, `created_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_release_n` ON `release` (`repo_id`,`tag_name`);
CREATE INDEX `IDX_release_repo_id` ON `release` (`repo_id`);
CREATE INDEX `IDX_release_publisher_id` ON `release` (`publisher_id`);
CREATE INDEX `IDX_release_tag_name` ON `release` (`tag_name`);
CREATE INDEX `IDX_release_original_author_id` ON `release` (`original_author_id`);
CREATE INDEX `IDX_release_created_unix` ON `release` (`created_unix`);

CREATE TABLE IF NOT EXISTS `repo_transfer` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `doer_id` BIGINT(20) NULL, `recipient_id` BIGINT(20) NULL, `repo_id` BIGINT(20) NULL, `team_i_ds` TEXT NULL, `created_unix` BIGINT(20) NOT NULL, `updated_unix` BIGINT(20) NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_repo_transfer_updated_unix` ON `repo_transfer` (`updated_unix`);
CREATE INDEX `IDX_repo_transfer_created_unix` ON `repo_transfer` (`created_unix`);
INSERT INTO `repo_transfer` (`id`, `doer_id`, `recipient_id`, `repo_id`, `team_i_ds`, `created_unix`, `updated_unix`) VALUES (1,7,15,68,'[]',1647951532,1647951532);

CREATE TABLE IF NOT EXISTS `task` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `doer_id` BIGINT(20) NULL, `owner_id` BIGINT(20) NULL, `repo_id` BIGINT(20) NULL, `type` INT NULL, `status` INT NULL, `start_time` BIGINT(20) NULL, `end_time` BIGINT(20) NULL, `payload_content` TEXT NULL, `message` TEXT NULL, `created` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_task_doer_id` ON `task` (`doer_id`);
CREATE INDEX `IDX_task_owner_id` ON `task` (`owner_id`);
CREATE INDEX `IDX_task_repo_id` ON `task` (`repo_id`);
CREATE INDEX `IDX_task_status` ON `task` (`status`);
INSERT INTO `task` (`id`, `doer_id`, `owner_id`, `repo_id`, `type`, `status`, `start_time`, `end_time`, `payload_content`, `message`, `created`) VALUES (1,2,2,0,0,3,1638526918,1638526918,'{"clone_addr":"http://bhx-lnx3.utcain.com:3000/ITI_Devel","clone_addr_encrypted":"7c37900692fe906ad72938ccc6681c4fbd5d71faf5bae232a00f281f7cca23e6005ebb589b355edc3bece9441bf2f7275a0e508ec09aebb4e169553ad6390dac4c94790d14a83bbd","auth_username":"","auth_password_encrypted":"e3622c3815fbf6b6efd9123dd415312a","auth_token_encrypted":"587f7e08c726f1f44389b806baa8d144a6dd9ca04354d727fb71c9a1dcfe09b42915009a3a19850a808b1fd26a88f6c4050bb1393e3cbe58703e39b68e513c3105b8045b98fb87f1","uid":0,"repo_name":"ITI_Devel","mirror":false,"lfs":false,"lfs_endpoint":"","private":false,"description":"","OriginalURL":"http://bhx-lnx3.utcain.com:3000/ITI_Devel","GitServiceType":3,"Wiki":true,"Issues":true,"Milestones":true,"Labels":true,"Releases":true,"Comments":true,"PullRequests":true,"ReleaseAssets":false,"MigrateToRepoID":0,"mirror_interval":""}','',1638526917);

CREATE TABLE IF NOT EXISTS `access_token` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `uid` BIGINT(20) NULL, `name` VARCHAR(255) NULL, `token_hash` VARCHAR(255) NULL, `token_salt` VARCHAR(255) NULL, `token_last_eight` VARCHAR(255) NULL, `created_unix` BIGINT(20) NULL, `updated_unix` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_access_token_token_hash` ON `access_token` (`token_hash`);
CREATE INDEX `IDX_access_token_created_unix` ON `access_token` (`created_unix`);
CREATE INDEX `IDX_access_token_updated_unix` ON `access_token` (`updated_unix`);
CREATE INDEX `IDX_access_token_uid` ON `access_token` (`uid`);

CREATE TABLE IF NOT EXISTS `upload` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `uuid` VARCHAR(40) NULL, `name` VARCHAR(255) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE UNIQUE INDEX `UQE_upload_uuid` ON `upload` (`uuid`);
INSERT INTO `upload` (`id`, `uuid`, `name`) VALUES (10,'7eae897e-41cb-476f-ad92-a09cf2b882d2','85001597_BOM_iss1.csv');

CREATE TABLE IF NOT EXISTS `package` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `owner_id` BIGINT(20) NOT NULL, `repo_id` BIGINT(20) NULL, `type` VARCHAR(255) NOT NULL, `name` VARCHAR(255) NOT NULL, `lower_name` VARCHAR(255) NOT NULL, `semver_compatible` TINYINT(1) DEFAULT false NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_package_type` ON `package` (`type`);
CREATE INDEX `IDX_package_lower_name` ON `package` (`lower_name`);
CREATE UNIQUE INDEX `UQE_package_s` ON `package` (`owner_id`,`type`,`lower_name`);
CREATE INDEX `IDX_package_owner_id` ON `package` (`owner_id`);
CREATE INDEX `IDX_package_repo_id` ON `package` (`repo_id`);

CREATE TABLE IF NOT EXISTS `package_blob` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `size` BIGINT(20) DEFAULT 0 NOT NULL, `hash_md5` CHAR(32) NOT NULL, `hash_sha1` CHAR(40) NOT NULL, `hash_sha256` CHAR(64) NOT NULL, `hash_sha512` CHAR(128) NOT NULL, `created_unix` BIGINT(20) NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_package_blob_hash_sha256` ON `package_blob` (`hash_sha256`);
CREATE INDEX `IDX_package_blob_created_unix` ON `package_blob` (`created_unix`);
CREATE INDEX `IDX_package_blob_hash_md5` ON `package_blob` (`hash_md5`);
CREATE UNIQUE INDEX `UQE_package_blob_sha1` ON `package_blob` (`hash_sha1`);
CREATE UNIQUE INDEX `UQE_package_blob_sha256` ON `package_blob` (`hash_sha256`);
CREATE UNIQUE INDEX `UQE_package_blob_sha512` ON `package_blob` (`hash_sha512`);
CREATE INDEX `IDX_package_blob_hash_sha512` ON `package_blob` (`hash_sha512`);
CREATE UNIQUE INDEX `UQE_package_blob_md5` ON `package_blob` (`hash_md5`);
CREATE INDEX `IDX_package_blob_hash_sha1` ON `package_blob` (`hash_sha1`);

CREATE TABLE IF NOT EXISTS `package_blob_upload` (`id` VARCHAR(255) PRIMARY KEY NOT NULL, `bytes_received` BIGINT(20) DEFAULT 0 NOT NULL, `hash_state_bytes` BLOB NULL, `created_unix` BIGINT(20) NOT NULL, `updated_unix` BIGINT(20) NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_package_blob_upload_updated_unix` ON `package_blob_upload` (`updated_unix`);

CREATE TABLE IF NOT EXISTS `package_file` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `version_id` BIGINT(20) NOT NULL, `blob_id` BIGINT(20) NOT NULL, `name` VARCHAR(255) NOT NULL, `lower_name` VARCHAR(255) NOT NULL, `composite_key` VARCHAR(255) NULL, `is_lead` TINYINT(1) DEFAULT false NOT NULL, `created_unix` BIGINT(20) NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_package_file_version_id` ON `package_file` (`version_id`);
CREATE INDEX `IDX_package_file_blob_id` ON `package_file` (`blob_id`);
CREATE INDEX `IDX_package_file_lower_name` ON `package_file` (`lower_name`);
CREATE INDEX `IDX_package_file_composite_key` ON `package_file` (`composite_key`);
CREATE INDEX `IDX_package_file_created_unix` ON `package_file` (`created_unix`);
CREATE UNIQUE INDEX `UQE_package_file_s` ON `package_file` (`version_id`,`lower_name`,`composite_key`);

CREATE TABLE IF NOT EXISTS `package_property` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `ref_type` BIGINT(20) NOT NULL, `ref_id` BIGINT(20) NOT NULL, `name` VARCHAR(255) NOT NULL, `value` TEXT NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_package_property_ref_type` ON `package_property` (`ref_type`);
CREATE INDEX `IDX_package_property_ref_id` ON `package_property` (`ref_id`);
CREATE INDEX `IDX_package_property_name` ON `package_property` (`name`);

CREATE TABLE IF NOT EXISTS `package_version` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `package_id` BIGINT(20) NOT NULL, `creator_id` BIGINT(20) DEFAULT 0 NOT NULL, `version` VARCHAR(255) NOT NULL, `lower_version` VARCHAR(255) NOT NULL, `created_unix` BIGINT(20) NOT NULL, `is_internal` TINYINT(1) DEFAULT false NOT NULL, `metadata_json` TEXT NULL, `download_count` BIGINT(20) DEFAULT 0 NOT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
CREATE INDEX `IDX_package_version_package_id` ON `package_version` (`package_id`);
CREATE INDEX `IDX_package_version_lower_version` ON `package_version` (`lower_version`);
CREATE INDEX `IDX_package_version_created_unix` ON `package_version` (`created_unix`);
CREATE INDEX `IDX_package_version_is_internal` ON `package_version` (`is_internal`);
CREATE UNIQUE INDEX `UQE_package_version_s` ON `package_version` (`package_id`,`lower_version`);

CREATE TABLE IF NOT EXISTS `app_state` (`id` VARCHAR(200) PRIMARY KEY NOT NULL, `revision` BIGINT(20) NULL, `content` LONGTEXT NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `app_state` (`id`, `revision`, `content`) VALUES ('runtime-state',4,'{"last_app_path":"/usr/bin/gitea"}');
INSERT INTO `app_state` (`id`, `revision`, `content`) VALUES ('update-checker',1,'{"LatestVersion":"1.17.0"}');

CREATE TABLE IF NOT EXISTS `version` (`id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT NOT NULL, `version` BIGINT(20) NULL) DEFAULT CHARSET utf8 ROW_FORMAT=DYNAMIC;
INSERT INTO `version` (`id`, `version`) VALUES (1,224);
