#import "MyFlutterViewController.h"
#import "FlutterDelegate.h"

#import "Flutter/Flutter.h"

@interface MyFlutterViewController ()

/*! Flutter test channel */
@property (nonatomic, strong) FlutterBasicMessageChannel *testChannel;

@end

@implementation MyFlutterViewController

- (instancetype)initWithEngine:(FlutterEngine*)engine
{
    self = [self initWithEngine:engine nibName:nil bundle:nil];

    return self;
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    self.testChannel = [FlutterBasicMessageChannel messageChannelWithName:@"io.flutter.add2apptest.testmessages"
                                                          binaryMessenger:FlutterDelegate.sharedInstance.flutterEngine.binaryMessenger
                                                                    codec:FlutterStringCodec.sharedInstance];
    __strong MyFlutterViewController *strongSelf = self;
    [self.testChannel setMessageHandler:^(id message, FlutterReply reply) {
        if ([message isEqualToString:@"pop"]) {
            [strongSelf popRoute];
        }
    }];
}

@end
