#import "FlutterDelegate.h"
#import "FLTWebViewFlutterPlugin.h"

@interface FlutterDelegate ()

/*! Flutter control channel */
@property (nonatomic, strong) FlutterMethodChannel *controlChannel;

@property (nonatomic, strong) NSString* launchingRoute;
@property (nonatomic, assign, readwrite) BOOL isInitialized;
@property (nonatomic, assign, readwrite) BOOL isClosing;

@end

@implementation FlutterDelegate

+ (FlutterDelegate *)sharedInstance
{
    static dispatch_once_t predicate;
    static FlutterDelegate *flutterDelegate = nil;

    dispatch_once(&predicate, ^{ flutterDelegate = [[self alloc] initSingleton]; });

    return flutterDelegate;
}

- (id)initSingleton
{
    self = [super init];
    if (self) {
        [self setUpFlutterEngineWithEntryPoint];
    }
    return self;
}

- (void)setUpFlutterEngineWithEntryPoint
{
    self.flutterEngine = [[FlutterEngine alloc] initWithName:@"io.flutter.add2apptest" project:nil];
    if (self.flutterEngine != nil) {
        [self.flutterEngine runWithEntrypoint:@"main"];

        // Register webview_flutter plugin
        [FLTWebViewFlutterPlugin registerWithRegistrar:[self.flutterEngine registrarForPlugin:@"FLTWebViewFlutterPlugin"]];

        __strong FlutterDelegate *strongSelf = self;
        self.controlChannel = [FlutterMethodChannel methodChannelWithName:@"io.flutter.add2apptest.control"
                                                          binaryMessenger:self.flutterEngine.binaryMessenger
                                                                    codec:FlutterJSONMethodCodec.sharedInstance];
        [self.controlChannel setMethodCallHandler:^(FlutterMethodCall * _Nonnull call, FlutterResult  _Nonnull result) {
            if ([call.method isEqualToString:@"initialize"]) {
                result(nil);
                [strongSelf.controlChannel invokeMethod:@"initialized" arguments:nil result:^(id  _Nullable result) {
                    [strongSelf onInitialized];
                }];
            }
            else if ([call.method isEqualToString:@"prepareForPop"]) {
                if (strongSelf.flutterViewController != nil) {
                    strongSelf.isClosing = YES;
                }
                else {
                    result([FlutterError errorWithCode:@"no_flutter_view_controller"
                                               message:@"No FlutterViewController present"
                                               details:nil]);
                }
            }
            else if ([call.method isEqualToString:@"pop"]) {
                if (strongSelf.flutterViewController != nil) {
                    [strongSelf.flutterViewController.presentingViewController dismissViewControllerAnimated:NO completion:^{
                        strongSelf.isClosing = NO;
                        strongSelf.flutterViewController = nil;
                        [strongSelf.flutterEngine setViewController:nil];

                        // launch a new view controller if needed
                        if (strongSelf.launchingRoute != nil) {
                            [strongSelf launchFlutterViewController];
                        }
                    }];
                }
                else {
                    result([FlutterError errorWithCode:@"no_flutter_view_controller"
                                               message:@"No FlutterViewController present"
                                               details:nil]);
                }
            }
        }];
    }
}

- (void)pushFlutterRoute:(NSString*) route
{
    if (self.flutterViewController == nil || self.isClosing) {
        self.launchingRoute = route;
        if (self.isInitialized && self.flutterViewController == nil) {
            [self launchFlutterViewController];
        }
    }
    else {
        [self.flutterViewController pushRoute:route];
    }
}

- (void) popFlutterRoute
{
    if (self.flutterViewController != nil) {
        [self.flutterViewController popRoute];
    }
}

- (void)launchFlutterViewController
{
    if (self.flutterViewController == nil) {
        self.flutterViewController = [[MyFlutterViewController alloc] initWithEngine:self.flutterEngine];
        [self.flutterViewController.view setBackgroundColor:[[UIColor blackColor] colorWithAlphaComponent:0.0f]];
        [self.flutterViewController.view setOpaque:NO];
        [self.flutterViewController setModalPresentationStyle:UIModalPresentationOverFullScreen];
        self.flutterViewController.modalPresentationCapturesStatusBarAppearance = YES;

        [self presentFlutterView:self.launchingRoute];
        self.launchingRoute = nil;
    }
}

- (void) presentFlutterView:(NSString*)route
{
    // push the launching route
    [self.flutterViewController pushRoute:route];

    UIViewController *presenter = [UIApplication sharedApplication].keyWindow.rootViewController;
    while (presenter.presentedViewController) {
        presenter = presenter.presentedViewController;
    }

    [presenter presentViewController:self.flutterViewController
                            animated:NO
                          completion:nil];
}

- (void)onInitialized
{
    self.isInitialized = YES;
    if (self.flutterViewController == nil && self.launchingRoute != nil) {
        [self launchFlutterViewController];
    }
}

@end
