import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

import 'control.dart';

// Main app entry
void main() {
  WidgetsFlutterBinding.ensureInitialized();
  Controller.init().then((_) {
    runApp(MyApp());
  });
}

class DefaultHomePage extends StatefulWidget {
  DefaultHomePageState createState() => DefaultHomePageState();
}

class DefaultHomePageState extends State<DefaultHomePage> with TickerProviderStateMixin {

  BasicMessageChannel testChannel;

  @override
  void initState() {
    testChannel = BasicMessageChannel("io.flutter.add2apptest.testmessages", StringCodec());

    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    print("DefaultHomePageState build!");

    return Scaffold(
      backgroundColor: Colors.transparent,
      body: Container(
        color: Colors.grey,
        child: GestureDetector(
          behavior: HitTestBehavior.opaque,
          onTapDown: (details) => print("on tap down!"),
          onTap: () => print("on tap!"),
          onTapCancel: () => print("on tap cancel!"),
          onPanStart: (details) => print("on pan started!"),
          onPanEnd: (details) => print("on pan ended!"),
          child: Center(
            child: Column(
              mainAxisSize: MainAxisSize.min,
              children: <Widget>[
                MaterialButton(
                    child: Text("Launch native activity!"),
                    onPressed: () {
                      print("launch native activity button pressed");
                      testChannel.send("launch_second_activity");
                    }
                ),
                MaterialButton(
                  child: Text("Close!"),
                  onPressed: () => testChannel.send(("pop"))
                ),
              ],
            )
          ),
        )
      ),
    );
  }
}

class MyApp extends StatelessWidget {
  MyApp({Key key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      navigatorKey: Controller.navigatorKey,
      debugShowCheckedModeBanner: false,
      title: 'Add2App',
      theme: ThemeData(
          primarySwatch: Colors.grey,
          brightness: Brightness.light,
      ),
      onGenerateRoute: onGenerateRoute,
      initialRoute: Controller.getInitialRoute()
    );
  }
  
  // Generate route based on routeSetting name
  Route onGenerateRoute(RouteSettings routeSettings) {
    if (routeSettings.name == "/") {
      return MyInitialRoute(settings: routeSettings);
    }
    else if (routeSettings.name == "/test") {
      return TestRoute(settings: routeSettings);
    }

    return null;
  }
}

class MyInitialRoute extends PageRouteBuilder {

  MyInitialRoute({
    RouteSettings settings
  }) : super(
      settings: settings,
      transitionDuration: Duration.zero,
      pageBuilder: (BuildContext context, Animation<double> animation, Animation<double> secondaryAnimation) {
        return Container();
      },
      transitionsBuilder: (BuildContext context, Animation<double> animation, Animation<double> secondaryAnimation, Widget child) {
        return child;
      }
  );
  
  @override
  void didPopNext(Route nextRoute) {
    super.didPopNext(nextRoute);

    // This fake route is becoming the only route on the navigator's stack once
    // again, so we should close the Flutter view. We do this by calling
    // SystemNavigator.pop()
    Controller.getChannel().invokeMethod("prepareForPop");

    // If the route being popped is a TransitionRoute, then be sure to only close
    // the Flutter view once the route is fully animated out
    if (nextRoute is TransitionRoute) {
      nextRoute.completed.then((_) => Controller.getChannel().invokeMethod("pop"));
    }
    else {
      nextRoute.popped.then((_) => Controller.getChannel().invokeMethod("pop"));
    }
  }
}

class TestRoute extends PageRouteBuilder {

  TestRoute({
    RouteSettings settings
  }) : super(
      settings: settings,
      transitionDuration: Duration.zero,
      pageBuilder: (BuildContext context, Animation<double> animation, Animation<double> secondaryAnimation) {
        return DefaultHomePage();
      },
      transitionsBuilder: (BuildContext context, Animation<double> animation, Animation<double> secondaryAnimation, Widget child) {
        return child;
      }
  );
}
