package io.flutter.add2apptest;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;

import io.flutter.embedding.android.FlutterFragment;
import io.flutter.embedding.android.RenderMode;
import io.flutter.embedding.android.TransparencyMode;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.StringCodec;


public final class MyFlutterActivity extends FragmentActivity {
    private static final String TAG_FLUTTER_FRAGMENT = "flutter_fragment";
    private static final int FRAGMENT_CONTAINER_ID = 609893468;

    private BasicMessageChannel<String> testChannel;

    @Override
    public void onCreate(Bundle savedInstanceState) {

        setTheme(R.style.MyFlutterWindow);
        super.onCreate(savedInstanceState);

        setContentView(getFragmentContainer());
        ensureFlutterFragmentCreated();

        FlutterDelegate.getInstance(null).setFlutterActivity(this);

        testChannel = new BasicMessageChannel<>(
                FlutterDelegate.getInstance(null).getFlutterEngine().getDartExecutor(),
                "io.flutter.add2apptest.testmessages", StringCodec.INSTANCE);
        testChannel.setMessageHandler((message, reply) -> reply.reply(handleControlMessage(message)));
    }

    private void ensureFlutterFragmentCreated() {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        FlutterFragment flutterFragment = (FlutterFragment)fragmentManager.findFragmentByTag(TAG_FLUTTER_FRAGMENT);
        if (flutterFragment == null) {
            flutterFragment = FlutterFragment.withCachedEngine(FlutterDelegate.getInstance(null).getFlutterEngineId())
                    .renderMode(RenderMode.surface)
                    .transparencyMode(TransparencyMode.transparent)
                    .build();

            // Add the fragment to the FrameLayout in the view hierarchy with an ID of FRAGMENT_CONTAINER_ID.
            fragmentManager
                    .beginTransaction()
                    .add(FRAGMENT_CONTAINER_ID, flutterFragment, TAG_FLUTTER_FRAGMENT)
                    .commit();
        }
    }

    private String handleControlMessage(String message) {
        if (message.equals("pop")) {
            FlutterDelegate.getInstance(null).getFlutterEngine().getNavigationChannel().popRoute();
        }
        else if (message.equals("launch_second_activity")) {
            Intent intent = new Intent(this, SecondActivity.class);
            this.startActivity(intent);
        }
        return null;
    }

    @Override
    public void onStart() {
        super.onStart();

        // Flutter will animate the view in, if needed
        overridePendingTransition(0, 0);
    }

    @Override
    public void finish() {
        super.finish();

        // Flutter will animate the view out, if needed
        overridePendingTransition(0, 0);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

        FlutterDelegate.getInstance(null).setFlutterActivity(null);
    }

    @NonNull
    private View getFragmentContainer() {
        FrameLayout container = new FrameLayout(this);
        container.setId(FRAGMENT_CONTAINER_ID);
        container.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        return container;
    }
}
