package test;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class Main extends ApplicationWindow {

    /**
     * Create the application window.
     */
    public Main() {
        super(null);
        createActions();
        addToolBar(SWT.FLAT | SWT.WRAP);
        addMenuBar();
        addStatusLine();
    }

    /**
     * Create contents of the application window.
     * 
     * @param parent
     */
    @Override
    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, SWT.NONE);

        container.setLayout(new FillLayout(SWT.HORIZONTAL));
        Document document = new Document();
        SourceViewer sourceViewer = new SourceViewer(container, null, SWT.V_SCROLL | SWT.H_SCROLL);
        sourceViewer.setDocument(document);
        sourceViewer.getTextWidget().addKeyListener(new KeyAdapter() {

            public void keyPressed(KeyEvent e) {
                try {
                    if (e.character == ' ' && (e.stateMask & SWT.CTRL) != 0)
                        showContentAssist();
                } catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }

            private void showContentAssist() throws BadLocationException {
                ContentAssistant ca1 = new ContentAssistant();
                ca1.install(sourceViewer);
                ca1.addContentAssistProcessor(new IContentAssistProcessor() {

                    @Override
                    public String getErrorMessage() {
                        // TODO Auto-generated method stub
                        return null;

                    }

                    @Override
                    public IContextInformationValidator getContextInformationValidator() {
                        // TODO Auto-generated method stub
                        return null;

                    }

                    @Override
                    public char[] getContextInformationAutoActivationCharacters() {
                        // TODO Auto-generated method stub
                        return null;

                    }

                    @Override
                    public char[] getCompletionProposalAutoActivationCharacters() {
                        // TODO Auto-generated method stub
                        return null;

                    }

                    @Override
                    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
                        return null;
                    }

                    @Override
                    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {

                        ICompletionProposal p1 = new ICompletionProposal() {

                            @Override
                            public void apply(IDocument document) {
                                // TODO Auto-generated method stub

                            }

                            @Override
                            public Point getSelection(IDocument document) {
                                // TODO Auto-generated method stub
                                return null;

                            }

                            @Override
                            public String getAdditionalProposalInfo() {
                                // TODO Auto-generated method stub
                                return null;

                            }

                            @Override
                            public String getDisplayString() {
                                // TODO Auto-generated method stub
                                return "SomeProposal";

                            }

                            @Override
                            public Image getImage() {
                                // TODO Auto-generated method stub
                                return null;

                            }

                            @Override
                            public IContextInformation getContextInformation() {
                                // TODO Auto-generated method stub
                                return null;

                            }

                        };

                        return new ICompletionProposal[] {p1, p1 };

                    }
                }, document.getContentType(0));
                ca1.showPossibleCompletions();
            }
        });

        return container;
    }

    /**
     * Create the actions.
     */
    private void createActions() {
        // Create the actions
    }

    /**
     * Create the menu manager.
     * 
     * @return the menu manager
     */
    @Override
    protected MenuManager createMenuManager() {
        MenuManager menuManager = new MenuManager("menu");
        return menuManager;
    }

    /**
     * Create the toolbar manager.
     * 
     * @return the toolbar manager
     */
    @Override
    protected ToolBarManager createToolBarManager(int style) {
        ToolBarManager toolBarManager = new ToolBarManager(style);
        return toolBarManager;
    }

    /**
     * Create the status line manager.
     * 
     * @return the status line manager
     */
    @Override
    protected StatusLineManager createStatusLineManager() {
        StatusLineManager statusLineManager = new StatusLineManager();
        return statusLineManager;
    }

    /**
     * Launch the application.
     * 
     * @param args
     */
    public static void main(String args[]) {
        try {
            Main window = new Main();
            window.setBlockOnOpen(true);
            window.open();
            Display.getCurrent().dispose();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Configure the shell.
     * 
     * @param newShell
     */
    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("New Application");
    }

    /**
     * Return the initial size of the window.
     */
    @Override
    protected Point getInitialSize() {
        return new Point(450, 300);
    }

}
