/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.
 
 http://www.cocos2d-x.org
 
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

function AddNode1(node, pos, screenSize, font) {
    var helloLabel = new cc.LabelTTF.create("Test Label", font, 38);

    helloLabel.x = screenSize.width / 2;
    helloLabel.y = pos;
    helloLabel.setAnchorPoint(cc.p(0,0));
    // add the label as a child to this layer
    node.addChild(helloLabel, 5);
    helloLabel.setColor(new cc.Color(51, 51, 51));
    
    node.drawNode = cc.DrawNode.create();
    node.addChild(node.drawNode,5);
    node.drawNode.clear();
    node.drawNode.drawRect(cc.p(helloLabel.x,helloLabel.y), cc.p(helloLabel.x+helloLabel.width,helloLabel.y+helloLabel.height),
                           cc.color(255,255,255,128), 1 , cc.color(255,255,255,128) );
}

var HelloWorldLayer = cc.Layer.extend({
                                      sprite:null,
                                      ctor:function () {
                                      //////////////////////////////
                                      // 1. super init first
                                      this._super();
    
                                      var size = cc.winSize;
                                      

                                      var pos = size.height / 2 + 200

                                    AddNode1(this, pos, size, "Calibri");
                                      
                                    pos = size.height / 2 + 100
                                    AddNode1(this, pos, size, "Arial");
                                      
                                      return true;
                                      }
                                      });

var HelloWorldScene = cc.Scene.extend({
                                      onEnter:function () {
                                      this._super();
                                      var layer = new HelloWorldLayer();
                                      this.addChild(layer);
                                      }
                                      });

